#!/usr/bin/env python
##################################################
# Gnuradio Python Flow Graph
# Title: Power Event Frontend Demo
# Generated: Tue Mar 13 13:48:31 2012
##################################################

from gnuradio import digital
from gnuradio import eng_notation
from gnuradio import gr
from gnuradio import uhd
from gnuradio.eng_option import eng_option
from gnuradio.gr import firdes
from optparse import OptionParser

class power_event_frontend_demo(gr.top_block):

	def __init__(self, freq=144.39e6, samp_rate=125e3, antenna="TX/RX", alpha=0.5, log_threshold=-75):
		gr.top_block.__init__(self, "Power Event Frontend Demo")

		##################################################
		# Parameters
		##################################################
		self.freq = freq
		self.samp_rate = samp_rate
		self.antenna = antenna
		self.alpha = alpha
		self.log_threshold = log_threshold

		##################################################
		# Variables
		##################################################
		self.threshold_0 = threshold_0 = 10**(log_threshold/20.0)
		self.threshold = threshold = 10**(log_threshold/20.0)
		self.keep_n = keep_n = 1000
		self.filter_decim = filter_decim = 5

		##################################################
		# Blocks
		##################################################
		self.uhd_usrp_source_0 = uhd.usrp_source(
			device_addr="",
			stream_args=uhd.stream_args(
				cpu_format="fc32",
				channels=range(1),
			),
		)
		self.uhd_usrp_source_0.set_samp_rate(samp_rate)
		self.uhd_usrp_source_0.set_center_freq(freq, 0)
		self.uhd_usrp_source_0.set_gain(20, 0)
		self.uhd_usrp_source_0.set_antenna(antenna, 0)
		self.low_pass_filter_0_1_0 = gr.fir_filter_ccf(filter_decim, firdes.low_pass(
			1, samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0_1 = gr.fir_filter_ccf(filter_decim, firdes.low_pass(
			1, samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0_0_0 = gr.fir_filter_ccf(filter_decim, firdes.low_pass(
			1, samp_rate, 10e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0_0 = gr.fir_filter_ccf(filter_decim, firdes.low_pass(
			1, samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0 = gr.fir_filter_ccf(filter_decim, firdes.low_pass(
			1, samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.gr_uchar_to_float_0_4 = gr.uchar_to_float()
		self.gr_uchar_to_float_0_3 = gr.uchar_to_float()
		self.gr_uchar_to_float_0_2 = gr.uchar_to_float()
		self.gr_uchar_to_float_0_0 = gr.uchar_to_float()
		self.gr_uchar_to_float_0 = gr.uchar_to_float()
		self.gr_sig_source_x_0_0_0_0 = gr.sig_source_c(samp_rate, gr.GR_COS_WAVE, -(25e3+25e3), 1, 0)
		self.gr_sig_source_x_0_0_0 = gr.sig_source_c(samp_rate, gr.GR_COS_WAVE, -(25e3), 1, 0)
		self.gr_sig_source_x_0_0 = gr.sig_source_c(samp_rate, gr.GR_COS_WAVE, (25e3), 1, 0)
		self.gr_sig_source_x_0 = gr.sig_source_c(samp_rate, gr.GR_COS_WAVE, (25e3+25e3), 1, 0)
		self.gr_rms_xx_0_3 = gr.rms_cf(alpha)
		self.gr_rms_xx_0_2 = gr.rms_cf(alpha)
		self.gr_rms_xx_0_1 = gr.rms_cf(alpha)
		self.gr_rms_xx_0_0 = gr.rms_cf(alpha)
		self.gr_rms_xx_0 = gr.rms_cf(alpha)
		self.gr_multiply_xx_0_0_2 = gr.multiply_vcc(1)
		self.gr_multiply_xx_0_0_1 = gr.multiply_vcc(1)
		self.gr_multiply_xx_0_0 = gr.multiply_vcc(1)
		self.gr_multiply_xx_0 = gr.multiply_vcc(1)
		self.gr_multiply_const_vxx_0_3 = gr.multiply_const_vff((16, ))
		self.gr_multiply_const_vxx_0_2 = gr.multiply_const_vff((8, ))
		self.gr_multiply_const_vxx_0_1 = gr.multiply_const_vff((4, ))
		self.gr_multiply_const_vxx_0_0 = gr.multiply_const_vff((2, ))
		self.gr_multiply_const_vxx_0 = gr.multiply_const_vff((1, ))
		self.gr_keep_one_in_n_0_0_0_0_0_0 = gr.keep_one_in_n(gr.sizeof_float*1, keep_n)
		self.gr_keep_one_in_n_0_0_0_0_0 = gr.keep_one_in_n(gr.sizeof_float*1, keep_n)
		self.gr_keep_one_in_n_0_0_0_0 = gr.keep_one_in_n(gr.sizeof_float*1, keep_n)
		self.gr_keep_one_in_n_0_0_0 = gr.keep_one_in_n(gr.sizeof_float*1, keep_n)
		self.gr_keep_one_in_n_0_0 = gr.keep_one_in_n(gr.sizeof_float*1, keep_n)
		self.gr_float_to_uchar_0 = gr.float_to_uchar()
		self.gr_file_sink_0 = gr.file_sink(gr.sizeof_char*1, "detect_fifo")
		self.gr_file_sink_0.set_unbuffered(True)
		self.gr_add_xx_0 = gr.add_vff(1)
		self.gr_add_const_vxx_0_0_2 = gr.add_const_vff((-threshold, ))
		self.gr_add_const_vxx_0_0_1 = gr.add_const_vff((-threshold, ))
		self.gr_add_const_vxx_0_0_0 = gr.add_const_vff((-threshold, ))
		self.gr_add_const_vxx_0_0 = gr.add_const_vff((-threshold, ))
		self.gr_add_const_vxx_0 = gr.add_const_vff((-threshold, ))
		self.digital_binary_slicer_fb_0_3 = digital.binary_slicer_fb()
		self.digital_binary_slicer_fb_0_2 = digital.binary_slicer_fb()
		self.digital_binary_slicer_fb_0_1 = digital.binary_slicer_fb()
		self.digital_binary_slicer_fb_0_0 = digital.binary_slicer_fb()
		self.digital_binary_slicer_fb_0 = digital.binary_slicer_fb()

		##################################################
		# Connections
		##################################################
		self.connect((self.low_pass_filter_0_0_0, 0), (self.gr_rms_xx_0_3, 0))
		self.connect((self.gr_rms_xx_0_2, 0), (self.gr_keep_one_in_n_0_0_0_0_0, 0))
		self.connect((self.gr_rms_xx_0_3, 0), (self.gr_keep_one_in_n_0_0_0_0_0_0, 0))
		self.connect((self.gr_keep_one_in_n_0_0_0_0_0_0, 0), (self.gr_add_const_vxx_0, 0))
		self.connect((self.gr_keep_one_in_n_0_0_0_0_0, 0), (self.gr_add_const_vxx_0_0, 0))
		self.connect((self.digital_binary_slicer_fb_0_2, 0), (self.gr_uchar_to_float_0_3, 0))
		self.connect((self.digital_binary_slicer_fb_0_3, 0), (self.gr_uchar_to_float_0_4, 0))
		self.connect((self.gr_add_const_vxx_0, 0), (self.digital_binary_slicer_fb_0_3, 0))
		self.connect((self.gr_add_const_vxx_0_0, 0), (self.digital_binary_slicer_fb_0_2, 0))
		self.connect((self.gr_rms_xx_0, 0), (self.gr_keep_one_in_n_0_0, 0))
		self.connect((self.gr_keep_one_in_n_0_0, 0), (self.gr_add_const_vxx_0_0_2, 0))
		self.connect((self.digital_binary_slicer_fb_0, 0), (self.gr_uchar_to_float_0, 0))
		self.connect((self.gr_uchar_to_float_0, 0), (self.gr_multiply_const_vxx_0, 0))
		self.connect((self.gr_add_const_vxx_0_0_2, 0), (self.digital_binary_slicer_fb_0, 0))
		self.connect((self.gr_rms_xx_0_0, 0), (self.gr_keep_one_in_n_0_0_0, 0))
		self.connect((self.gr_keep_one_in_n_0_0_0, 0), (self.gr_add_const_vxx_0_0_1, 0))
		self.connect((self.gr_add_const_vxx_0_0_1, 0), (self.digital_binary_slicer_fb_0_0, 0))
		self.connect((self.gr_keep_one_in_n_0_0_0_0, 0), (self.gr_add_const_vxx_0_0_0, 0))
		self.connect((self.gr_rms_xx_0_1, 0), (self.gr_keep_one_in_n_0_0_0_0, 0))
		self.connect((self.digital_binary_slicer_fb_0_1, 0), (self.gr_uchar_to_float_0_2, 0))
		self.connect((self.gr_add_const_vxx_0_0_0, 0), (self.digital_binary_slicer_fb_0_1, 0))
		self.connect((self.gr_multiply_const_vxx_0_3, 0), (self.gr_add_xx_0, 4))
		self.connect((self.gr_add_xx_0, 0), (self.gr_float_to_uchar_0, 0))
		self.connect((self.gr_uchar_to_float_0_2, 0), (self.gr_multiply_const_vxx_0_1, 0))
		self.connect((self.gr_multiply_const_vxx_0_1, 0), (self.gr_add_xx_0, 2))
		self.connect((self.gr_uchar_to_float_0_4, 0), (self.gr_multiply_const_vxx_0_3, 0))
		self.connect((self.gr_multiply_const_vxx_0_0, 0), (self.gr_add_xx_0, 1))
		self.connect((self.gr_multiply_const_vxx_0, 0), (self.gr_add_xx_0, 0))
		self.connect((self.gr_uchar_to_float_0_0, 0), (self.gr_multiply_const_vxx_0_0, 0))
		self.connect((self.digital_binary_slicer_fb_0_0, 0), (self.gr_uchar_to_float_0_0, 0))
		self.connect((self.gr_uchar_to_float_0_3, 0), (self.gr_multiply_const_vxx_0_2, 0))
		self.connect((self.gr_multiply_const_vxx_0_2, 0), (self.gr_add_xx_0, 3))
		self.connect((self.gr_sig_source_x_0_0_0, 0), (self.gr_multiply_xx_0_0_1, 0))
		self.connect((self.gr_sig_source_x_0_0_0_0, 0), (self.gr_multiply_xx_0_0_2, 0))
		self.connect((self.gr_sig_source_x_0_0, 0), (self.gr_multiply_xx_0_0, 0))
		self.connect((self.gr_sig_source_x_0, 0), (self.gr_multiply_xx_0, 0))
		self.connect((self.gr_multiply_xx_0_0, 0), (self.low_pass_filter_0_1, 0))
		self.connect((self.gr_multiply_xx_0_0_1, 0), (self.low_pass_filter_0_0, 0))
		self.connect((self.gr_multiply_xx_0_0_2, 0), (self.low_pass_filter_0_0_0, 0))
		self.connect((self.gr_multiply_xx_0, 0), (self.low_pass_filter_0_1_0, 0))
		self.connect((self.low_pass_filter_0_1, 0), (self.gr_rms_xx_0_0, 0))
		self.connect((self.low_pass_filter_0_1_0, 0), (self.gr_rms_xx_0, 0))
		self.connect((self.low_pass_filter_0_0, 0), (self.gr_rms_xx_0_2, 0))
		self.connect((self.low_pass_filter_0, 0), (self.gr_rms_xx_0_1, 0))
		self.connect((self.uhd_usrp_source_0, 0), (self.gr_multiply_xx_0, 1))
		self.connect((self.uhd_usrp_source_0, 0), (self.gr_multiply_xx_0_0, 1))
		self.connect((self.uhd_usrp_source_0, 0), (self.low_pass_filter_0, 0))
		self.connect((self.uhd_usrp_source_0, 0), (self.gr_multiply_xx_0_0_1, 1))
		self.connect((self.uhd_usrp_source_0, 0), (self.gr_multiply_xx_0_0_2, 1))
		self.connect((self.gr_float_to_uchar_0, 0), (self.gr_file_sink_0, 0))

	def get_freq(self):
		return self.freq

	def set_freq(self, freq):
		self.freq = freq
		self.uhd_usrp_source_0.set_center_freq(self.freq, 0)

	def get_samp_rate(self):
		return self.samp_rate

	def set_samp_rate(self, samp_rate):
		self.samp_rate = samp_rate
		self.gr_sig_source_x_0_0_0.set_sampling_freq(self.samp_rate)
		self.gr_sig_source_x_0_0_0_0.set_sampling_freq(self.samp_rate)
		self.low_pass_filter_0_1_0.set_taps(firdes.low_pass(1, self.samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0.set_taps(firdes.low_pass(1, self.samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0_0_0.set_taps(firdes.low_pass(1, self.samp_rate, 10e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0_0.set_taps(firdes.low_pass(1, self.samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.low_pass_filter_0_1.set_taps(firdes.low_pass(1, self.samp_rate, 8e3, 2.5e3, firdes.WIN_HAMMING, 6.76))
		self.gr_sig_source_x_0_0.set_sampling_freq(self.samp_rate)
		self.gr_sig_source_x_0.set_sampling_freq(self.samp_rate)
		self.uhd_usrp_source_0.set_samp_rate(self.samp_rate)

	def get_antenna(self):
		return self.antenna

	def set_antenna(self, antenna):
		self.antenna = antenna
		self.uhd_usrp_source_0.set_antenna(self.antenna, 0)

	def get_alpha(self):
		return self.alpha

	def set_alpha(self, alpha):
		self.alpha = alpha
		self.gr_rms_xx_0.set_alpha(self.alpha)
		self.gr_rms_xx_0_3.set_alpha(self.alpha)
		self.gr_rms_xx_0_2.set_alpha(self.alpha)
		self.gr_rms_xx_0_1.set_alpha(self.alpha)
		self.gr_rms_xx_0_0.set_alpha(self.alpha)

	def get_log_threshold(self):
		return self.log_threshold

	def set_log_threshold(self, log_threshold):
		self.log_threshold = log_threshold
		self.set_threshold_0(10**(self.log_threshold/20.0))
		self.set_threshold(10**(self.log_threshold/20.0))

	def get_threshold_0(self):
		return self.threshold_0

	def set_threshold_0(self, threshold_0):
		self.threshold_0 = threshold_0

	def get_threshold(self):
		return self.threshold

	def set_threshold(self, threshold):
		self.threshold = threshold
		self.gr_add_const_vxx_0.set_k((-self.threshold, ))
		self.gr_add_const_vxx_0_0.set_k((-self.threshold, ))
		self.gr_add_const_vxx_0_0_2.set_k((-self.threshold, ))
		self.gr_add_const_vxx_0_0_1.set_k((-self.threshold, ))
		self.gr_add_const_vxx_0_0_0.set_k((-self.threshold, ))

	def get_keep_n(self):
		return self.keep_n

	def set_keep_n(self, keep_n):
		self.keep_n = keep_n
		self.gr_keep_one_in_n_0_0_0_0.set_n(self.keep_n)
		self.gr_keep_one_in_n_0_0_0_0_0.set_n(self.keep_n)
		self.gr_keep_one_in_n_0_0_0_0_0_0.set_n(self.keep_n)
		self.gr_keep_one_in_n_0_0.set_n(self.keep_n)
		self.gr_keep_one_in_n_0_0_0.set_n(self.keep_n)

	def get_filter_decim(self):
		return self.filter_decim

	def set_filter_decim(self, filter_decim):
		self.filter_decim = filter_decim

if __name__ == '__main__':
	parser = OptionParser(option_class=eng_option, usage="%prog: [options]")
	parser.add_option("-f", "--freq", dest="freq", type="eng_float", default=eng_notation.num_to_str(144.39e6),
		help="Set freq [default=%default]")
	parser.add_option("-s", "--samp-rate", dest="samp_rate", type="eng_float", default=eng_notation.num_to_str(125e3),
		help="Set samp_rate [default=%default]")
	parser.add_option("-a", "--antenna", dest="antenna", type="string", default="TX/RX",
		help="Set antenna [default=%default]")
	parser.add_option("", "--alpha", dest="alpha", type="eng_float", default=eng_notation.num_to_str(0.5),
		help="Set alpha [default=%default]")
	parser.add_option("-t", "--log-threshold", dest="log_threshold", type="eng_float", default=eng_notation.num_to_str(-75),
		help="Set log_threshold [default=%default]")
	(options, args) = parser.parse_args()
	tb = power_event_frontend_demo(freq=options.freq, samp_rate=options.samp_rate, antenna=options.antenna, alpha=options.alpha, log_threshold=options.log_threshold)
	tb.start()
	raw_input('Press Enter to quit: ')
	tb.stop()

