import time
import socket
import thread
import string
import struct
from optparse import OptionParser

CHANNEL_COUNT = 5

state_array = [0,0,0,0,0]	#channel power state array
			

def report_event(channel_num, event_string, network_socket, options):
	
	#assemble report string and output to udp socket
	report_string = time.asctime(time.gmtime(time.time())) + ',' + event_string + ',' + 'Chan. ' + str(channel_num) 
	
	network_socket.sendto(report_string + "\n\r",(options.ip, options.port) )

	if(options.verbose):
		print report_string

def apply_detection_logic(file_object,network_socket,options):

	#get byte from fifo
	byte = int(struct.unpack('B', file_object.read(1))[0])

	#look at CHANNEL_COUNT LSBs to determine if power is detected
	for j in range(0,CHANNEL_COUNT):
	
		result = ( byte >> j ) & 1

		#apply simple logic to determine TX on/off transission
		if state_array[j] == 0:
			if result == 1:
				report_event(j,"Tx On",network_socket,options)	
		if state_array[j] == 1:
			if result == 0:
				report_event(j,"Tx Off",network_socket,options)
	
		state_array[j] = result
		
				
def main():
	
	#command parser
	parser = OptionParser()
	parser.add_option("-p", "--port", dest="port",action="store",type="int",
		help="Port for outging UDP Socket.", metavar="PORT")
	parser.add_option("-a", "--address", dest="ip",action="store",type="string",
		help="IP Address for outgoing UDP Socket.", metavar="ADDR")
	parser.add_option("-f", "--file", dest="filename",action="store",type="string",
		help="File w/ incoming bytes", metavar="FILE")
	parser.add_option("-v", action="store_true", dest="verbose",help="Print reports to stdout.",
		default=False)
	(options, args) = parser.parse_args()

	print "The program is starting"
	
	#open file pipe for itnerface to flow graph
	print "Opening Pipe to GNU Radio Flow Graph"
	file = open(options.filename,"rb")
	
	#bind UDP socket
	print "Opening Outgoing UDP Socket"
	sock_network = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
	
	#process output from gnuradio flowgraph
	while(1):
		apply_detection_logic(file,sock_network,options)

if __name__ == "__main__":
    main()
