<%
    # Because we are modifying 'clocks' immediately, Mako doesn't understand
    # that it should be a normal variable in the local context, so we have to
    # pull it out of 'context' manually.
    clocks = [c.strip() for c in context.get('clocks').split(",") if c.strip()]
    width_map = {
        "sc16": 32,
        "sc8":  16,
        "s16":  16,
        "s8":   8,
        "u8":   8,
        "fc32": 64,
        "f32":  32,
    }
    in_item_width = width_map.get(in_type, 'unknown')
    out_item_width = width_map.get(out_type, 'unknown')
%>\
#
# This file was auto-generated by rfnoc_modtool. It is recommended to edit this
# file and make any desired modifications, then remove this comment.
#
schema: rfnoc_modtool_args
module_name: ${ blockname }    # It is good practice to make this name match the filename, but it is not a requirement
version: "1.0"
rfnoc_version: "1.0"
chdr_width: 64
noc_id: ${ hex(noc_id) }

# List all block parameters here.
#parameters:
#  param1: foo
#  param2: bar

# List all clocks required for this RFNoC block. rfnoc_chdr and rfnoc_ctrl
# are always required and available.
clocks:
  - name: rfnoc_chdr
  - name: rfnoc_ctrl
%for clock_name in clocks:
  - name: ${ clock_name }
%endfor

# A control interface is always required. This is used for the control
# traffic between host software and this RFNoC block on the FPGA.
control:
  fpga_iface: ctrlport
  interface_direction: slave
  # The FIFO depth determines how many commands may be queued up.
  fifo_depth: ${ ctrl_fifo_depth }
  # The clock domain of this control interface must be one of the domains
  # listed in the 'clocks' section.
  clk_domain: ${ ctrl_clk_domain }
  ctrlport:
    byte_mode: False
    # Set to True if this RFNoC block understands timed commands.
    timed: False
    # Set to True if your block returns a controlport status response.
    has_status: False

%if (num_inputs or num_outputs) and data_iface_type in ('axis_chdr', 'axis_pyld_ctxt', 'axis_data'):
data:
  # The FPGA interface defines how the block IP handles data streams.
  fpga_iface: ${ data_iface_type }
  # The clock domain must be either rfnoc_chdr or an additional clock as
  # provided in the 'clocks' section.
  clk_domain: ${ data_clk_domain }
%  if num_inputs:
  inputs:
    # This will generate one or more ports all called 'in'. It is also
    # possible to have multiple ports with different names.
    in:
      # The number of ports sub-summed under 'in'. This may also be a mako
      # expression, or a name of a parameter.
%    if data_iface_type == 'axis_data':
      num_ports: ${ num_inputs }
      item_width: ${ in_item_width }
      nipc: 1
      info_fifo_depth: 32
      payload_fifo_depth: 32
      format: ${ in_type }
%    elif data_iface_type == 'axis_pyld_ctxt':
      num_ports: ${ num_inputs }
      item_width: ${ in_item_width }
      nipc: 1
      payload_fifo_depth: 32
      context_fifo_depth: 32
      format: ${ in_type }
%    elif data_iface_type == 'axis_chdr':
      num_ports: ${ num_inputs }
      format: ${ in_type }
%    else:
      # Unknown data interface type
%    endif
%  endif
%  if num_outputs:
  outputs:
    # This will generate one or more ports all called 'out'. It is also
    # possible to have multiple ports with different names.
%    if data_iface_type == 'axis_data':
      num_ports: ${ num_outputs }
      item_width: ${ out_item_width }
      nipc: 1
      info_fifo_depth: 32
      sideband_at_end: True
      payload_fifo_depth: 2**32
      format: ${ out_type }
%    elif data_iface_type == 'axis_pyld_ctxt':
      num_ports: ${ num_outputs }
      item_width: ${ out_item_width }
      nipc: 1
      payload_fifo_depth: 32
      context_fifo_depth: 32
      format: ${ out_type }
%    elif data_iface_type == 'axis_chdr':
      num_ports: ${ num_outputs }
      format: ${ out_type }
%    else:
      # Unknown data interface type
%    endif
%  endif
%else:
# No data interfaces defined -- this block will not be able to consume or
# produce any data.
%endif

fpga_includes:
  - include: "fpga/${ MODULE_NAME }/rfnoc_${ type }_${ blockname }/Makefile.srcs"
    make_var: "$(RFNOC_BLOCK_${ MODULE_NAME.upper() }_SRCS)"
