//Original:/testcases/core/c_dsp32shift_ahalf_rn/c_dsp32shift_ahalf_rn.dsp
// Spec Reference: dsp32shift ashift
# mach: bfin

.include "testutils.inc"
	start



// Ashift : positive data, count (+)=right (half reg)
// d_lo = ashft (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000000;
R0.L = -1;
imm32 r1, 0x00008001;
imm32 r2, 0x00008002;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
//rl0 = ashift (rl0 by rl0);
R1.L = ASHIFT R1.L BY R0.L;
R2.L = ASHIFT R2.L BY R0.L;
R3.L = ASHIFT R3.L BY R0.L;
R4.L = ASHIFT R4.L BY R0.L;
R5.L = ASHIFT R5.L BY R0.L;
R6.L = ASHIFT R6.L BY R0.L;
R7.L = ASHIFT R7.L BY R0.L;
//CHECKREG r0, 0x00000000;
CHECKREG r1, 0x0000c000;
CHECKREG r2, 0x0000c001;
CHECKREG r3, 0x0000c001;
CHECKREG r4, 0x0000c002;
CHECKREG r5, 0x0000c002;
CHECKREG r6, 0x0000c003;
CHECKREG r7, 0x0000c003;

imm32 r0, 0x00008001;
R1.L = -1;
imm32 r2, 0x00008002;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R0.L = ASHIFT R0.L BY R1.L;
//rl1 = ashift (rl1 by rl1);
R2.L = ASHIFT R2.L BY R1.L;
R3.L = ASHIFT R3.L BY R1.L;
R4.L = ASHIFT R4.L BY R1.L;
R5.L = ASHIFT R5.L BY R1.L;
R6.L = ASHIFT R6.L BY R1.L;
R7.L = ASHIFT R7.L BY R1.L;
CHECKREG r0, 0x0000c000;
//CHECKREG r1, 0x00000001;
CHECKREG r2, 0x0000c001;
CHECKREG r3, 0x0000c001;
CHECKREG r4, 0x0000c002;
CHECKREG r5, 0x0000c002;
CHECKREG r6, 0x0000c003;
CHECKREG r7, 0x0000c003;


imm32 r0, 0x00008001;
imm32 r1, 0x00008001;
R2.L = -15;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R0.L = ASHIFT R0.L BY R2.L;
R1.L = ASHIFT R1.L BY R2.L;
//rl2 = ashift (rl2 by rl2);
R3.L = ASHIFT R3.L BY R2.L;
R4.L = ASHIFT R4.L BY R2.L;
R5.L = ASHIFT R5.L BY R2.L;
R6.L = ASHIFT R6.L BY R2.L;
R7.L = ASHIFT R7.L BY R2.L;
CHECKREG r0, 0x0000ffff;
CHECKREG r1, 0x0000ffff;
//CHECKREG r2, 0x0000000f;
CHECKREG r3, 0x0000ffff;
CHECKREG r4, 0x0000ffff;
CHECKREG r5, 0x0000ffff;
CHECKREG r6, 0x0000ffff;
CHECKREG r7, 0x0000ffff;

imm32 r0, 0x00008001;
imm32 r1, 0x00008001;
imm32 r2, 0x00008002;
R3.L = -16;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R0.L = ASHIFT R0.L BY R3.L;
R1.L = ASHIFT R1.L BY R3.L;
R2.L = ASHIFT R2.L BY R3.L;
//rl3 = ashift (rl3 by rl3);
R4.L = ASHIFT R4.L BY R3.L;
R5.L = ASHIFT R5.L BY R3.L;
R6.L = ASHIFT R6.L BY R3.L;
R7.L = ASHIFT R7.L BY R3.L;
CHECKREG r0, 0x0000ffff;
CHECKREG r1, 0x0000ffff;
CHECKREG r2, 0x0000ffff;
//CHECKREG r3, 0x00000010;
CHECKREG r4, 0x0000ffff;
CHECKREG r5, 0x0000ffff;
CHECKREG r6, 0x0000ffff;
CHECKREG r7, 0x0000ffff;

// d_lo = ashft (d_hi BY d_lo)
// RHx by RLx
imm32 r0, 0x00000000;
imm32 r1, 0x80010000;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
imm32 r4, 0x80040000;
imm32 r5, 0x80050000;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R0.L = ASHIFT R0.H BY R0.L;
R1.L = ASHIFT R1.H BY R0.L;
R2.L = ASHIFT R2.H BY R0.L;
R3.L = ASHIFT R3.H BY R0.L;
R4.L = ASHIFT R4.H BY R0.L;
R5.L = ASHIFT R5.H BY R0.L;
R6.L = ASHIFT R6.H BY R0.L;
R7.L = ASHIFT R7.H BY R0.L;
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x80018001;
CHECKREG r2, 0x80028002;
CHECKREG r3, 0x80038003;
CHECKREG r4, 0x80048004;
CHECKREG r5, 0x80058005;
CHECKREG r6, 0x80068006;
CHECKREG r7, 0x80078007;

imm32 r0, 0x80010000;
R1.L = -1;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
imm32 r4, 0x80040000;
imm32 r5, 0x80050000;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R0.L = ASHIFT R0.H BY R1.L;
//rl1 = ashift (rh1 by rl1);
R2.L = ASHIFT R2.H BY R1.L;
R3.L = ASHIFT R3.H BY R1.L;
R4.L = ASHIFT R4.H BY R1.L;
R5.L = ASHIFT R5.H BY R1.L;
R6.L = ASHIFT R6.H BY R1.L;
R7.L = ASHIFT R7.H BY R1.L;
CHECKREG r0, 0x8001c000;
//CHECKREG r1, 0x00010001;
CHECKREG r2, 0x8002c001;
CHECKREG r3, 0x8003c001;
CHECKREG r4, 0x8004c002;
CHECKREG r5, 0x8005c002;
CHECKREG r6, 0x8006c003;
CHECKREG r7, 0x8007c003;


imm32 r0, 0xa0010000;
imm32 r1, 0xa0010000;
R2.L = -15;
imm32 r3, 0xa0030000;
imm32 r4, 0xa0040000;
imm32 r5, 0xa0050000;
imm32 r6, 0xa0060000;
imm32 r7, 0xa0070000;
R0.L = ASHIFT R0.H BY R2.L;
R1.L = ASHIFT R1.H BY R2.L;
//rl2 = ashift (rh2 by rl2);
R3.L = ASHIFT R3.H BY R2.L;
R4.L = ASHIFT R4.H BY R2.L;
R5.L = ASHIFT R5.H BY R2.L;
R6.L = ASHIFT R6.H BY R2.L;
R7.L = ASHIFT R7.H BY R2.L;
CHECKREG r0, 0xa001ffff;
CHECKREG r1, 0xa001ffff;
//CHECKREG r2, 0x2002000f;
CHECKREG r3, 0xa003ffff;
CHECKREG r4, 0xa004ffff;
CHECKREG r5, 0xa005ffff;
CHECKREG r6, 0xa006ffff;
CHECKREG r7, 0xa007ffff;

imm32 r0, 0xb0010001;
imm32 r1, 0xb0010001;
imm32 r2, 0xb0020002;
R3.L = -16;
imm32 r4, 0xb0040004;
imm32 r5, 0xb0050005;
imm32 r6, 0xb0060006;
imm32 r7, 0xb0070007;
R0.L = ASHIFT R0.H BY R3.L;
R1.L = ASHIFT R1.H BY R3.L;
R2.L = ASHIFT R2.H BY R3.L;
//rl3 = ashift (rh3 by rl3);
R4.L = ASHIFT R4.H BY R3.L;
R5.L = ASHIFT R5.H BY R3.L;
R6.L = ASHIFT R6.H BY R3.L;
R7.L = ASHIFT R7.H BY R3.L;
CHECKREG r0, 0xb001ffff;
CHECKREG r1, 0xb001ffff;
CHECKREG r2, 0xb002ffff;
//CHECKREG r3, 0x30030010;
CHECKREG r4, 0xb004ffff;
CHECKREG r5, 0xb005ffff;
CHECKREG r6, 0xb006ffff;
CHECKREG r7, 0xb007ffff;

// d_hi = ashft (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000001;
imm32 r1, 0x00000001;
imm32 r2, 0x00000002;
imm32 r3, 0x00000003;
imm32 r4, 0x00000000;
imm32 r5, 0x00000005;
imm32 r6, 0x00000006;
imm32 r7, 0x00000007;
R0.H = ASHIFT R0.L BY R4.L;
R1.H = ASHIFT R1.L BY R4.L;
R2.H = ASHIFT R2.L BY R4.L;
R3.H = ASHIFT R3.L BY R4.L;
//rh4 = ashift (rl4 by rl4);
R5.H = ASHIFT R5.L BY R4.L;
R6.H = ASHIFT R6.L BY R4.L;
R7.H = ASHIFT R7.L BY R4.L;
CHECKREG r0, 0x00010001;
CHECKREG r1, 0x00010001;
CHECKREG r2, 0x00020002;
CHECKREG r3, 0x00030003;
//CHECKREG r4, 0x00040004;
CHECKREG r5, 0x00050005;
CHECKREG r6, 0x00060006;
CHECKREG r7, 0x00070007;

imm32 r0, 0x00008001;
imm32 r1, 0x00008001;
imm32 r2, 0x00008002;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
R5.L = -1;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R0.H = ASHIFT R0.L BY R5.L;
R1.H = ASHIFT R1.L BY R5.L;
R2.H = ASHIFT R2.L BY R5.L;
R3.H = ASHIFT R3.L BY R5.L;
R4.H = ASHIFT R4.L BY R5.L;
//rh5 = ashift (rl5 by rl5);
R6.H = ASHIFT R6.L BY R5.L;
R7.H = ASHIFT R7.L BY R5.L;
CHECKREG r0, 0xc0008001;
CHECKREG r1, 0xc0008001;
CHECKREG r2, 0xc0018002;
CHECKREG r3, 0xc0018003;
CHECKREG r4, 0xc0028004;
//CHECKREG r5, 0x00020005;
CHECKREG r6, 0xc0038006;
CHECKREG r7, 0xc0038007;


imm32 r0, 0x00009001;
imm32 r1, 0x00009001;
imm32 r2, 0x00009002;
imm32 r3, 0x00009003;
imm32 r4, 0x00009004;
imm32 r5, 0x00009005;
R6.L = -15;
imm32 r7, 0x00009007;
R0.H = ASHIFT R0.L BY R6.L;
R1.H = ASHIFT R1.L BY R6.L;
R2.H = ASHIFT R2.L BY R6.L;
R3.H = ASHIFT R3.L BY R6.L;
R4.H = ASHIFT R4.L BY R6.L;
R5.H = ASHIFT R5.L BY R6.L;
//rh6 = ashift (rl6 by rl6);
R7.H = ASHIFT R7.L BY R6.L;
CHECKREG r0, 0xffff9001;
CHECKREG r1, 0xffff9001;
CHECKREG r2, 0xffff9002;
CHECKREG r3, 0xffff9003;
CHECKREG r4, 0xffff9004;
CHECKREG r5, 0xffff9005;
//CHECKREG r6, 0x00006006;
CHECKREG r7, 0xffff9007;

imm32 r0, 0x0000a001;
imm32 r1, 0x0000a001;
imm32 r2, 0x0000a002;
imm32 r3, 0x0000a003;
imm32 r4, 0x0000a004;
imm32 r5, 0x0000a005;
imm32 r6, 0x0000a006;
R7.L = -16;
R0.H = ASHIFT R0.L BY R7.L;
R1.H = ASHIFT R1.L BY R7.L;
R2.H = ASHIFT R2.L BY R7.L;
R3.H = ASHIFT R3.L BY R7.L;
R4.H = ASHIFT R4.L BY R7.L;
R5.H = ASHIFT R5.L BY R7.L;
R6.H = ASHIFT R6.L BY R7.L;
R7.H = ASHIFT R7.L BY R7.L;
CHECKREG r0, 0xffffa001;
CHECKREG r1, 0xffffa001;
CHECKREG r2, 0xffffa002;
CHECKREG r3, 0xffffa003;
CHECKREG r4, 0xffffa004;
CHECKREG r5, 0xffffa005;
CHECKREG r6, 0xffffa006;
//CHECKREG r7, 0x00007007;

// d_lo = ashft (d_hi BY d_lo)
// RHx by RLx
imm32 r0, 0x80010000;
imm32 r1, 0x80010000;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
R4.L = -1;
imm32 r5, 0x80050000;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R0.H = ASHIFT R0.H BY R4.L;
R1.H = ASHIFT R1.H BY R4.L;
R2.H = ASHIFT R2.H BY R4.L;
R3.H = ASHIFT R3.H BY R4.L;
//rh4 = ashift (rh4 by rl4);
R5.H = ASHIFT R5.H BY R4.L;
R6.H = ASHIFT R6.H BY R4.L;
R7.H = ASHIFT R7.H BY R4.L;
CHECKREG r0, 0xc0000000;
CHECKREG r1, 0xc0000000;
CHECKREG r2, 0xc0010000;
CHECKREG r3, 0xc0010000;
//CHECKREG r4, 0x00020000;
CHECKREG r5, 0xc0020000;
CHECKREG r6, 0xc0030000;
CHECKREG r7, 0xc0030000;

imm32 r0, 0x80010000;
imm32 r1, 0x80010000;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
imm32 r4, 0x80040000;
R5.L = -1;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R0.H = ASHIFT R0.H BY R5.L;
R1.H = ASHIFT R1.H BY R5.L;
R2.H = ASHIFT R2.H BY R5.L;
R3.H = ASHIFT R3.H BY R5.L;
R4.H = ASHIFT R4.H BY R5.L;
//rh5 = ashift (rh5 by rl5);
R6.H = ASHIFT R6.H BY R5.L;
R7.H = ASHIFT R7.H BY R5.L;
CHECKREG r0, 0xc0000000;
CHECKREG r1, 0xc0000000;
CHECKREG r2, 0xc0010000;
CHECKREG r3, 0xc0010000;
CHECKREG r4, 0xc0020000;
//CHECKREG r5, 0x28020000;
CHECKREG r6, 0xc0030000;
CHECKREG r7, 0xc0030000;


imm32 r0, 0xd0010000;
imm32 r1, 0xd0010000;
imm32 r2, 0xd0020000;
imm32 r3, 0xd0030000;
imm32 r4, 0xd0040000;
imm32 r5, 0xd0050000;
R6.L = -15;
imm32 r7, 0xd0070000;
R0.L = ASHIFT R0.H BY R6.L;
R1.L = ASHIFT R1.H BY R6.L;
R2.L = ASHIFT R2.H BY R6.L;
R3.L = ASHIFT R3.H BY R6.L;
R4.L = ASHIFT R4.H BY R6.L;
R5.L = ASHIFT R5.H BY R6.L;
//rl6 = ashift (rh6 by rl6);
R7.L = ASHIFT R7.H BY R6.L;
CHECKREG r0, 0xd001ffff;
CHECKREG r1, 0xd001ffff;
CHECKREG r2, 0xd002ffff;
CHECKREG r3, 0xd003ffff;
CHECKREG r4, 0xd004ffff;
CHECKREG r5, 0xd005ffff;
//CHECKREG r6, 0x60060000;
CHECKREG r7, 0xd007ffff;

imm32 r0, 0xe0010000;
imm32 r1, 0xe0010000;
imm32 r2, 0xe0020000;
imm32 r3, 0xe0030000;
imm32 r4, 0xe0040000;
imm32 r5, 0xe0050000;
imm32 r6, 0xe0060000;
R7.L = -16;
R0.H = ASHIFT R0.H BY R7.L;
R1.H = ASHIFT R1.H BY R7.L;
R2.H = ASHIFT R2.H BY R7.L;
R3.H = ASHIFT R3.H BY R7.L;
R4.H = ASHIFT R4.H BY R7.L;
R5.H = ASHIFT R5.H BY R7.L;
R6.H = ASHIFT R6.H BY R7.L;
//rh7 = ashift (rh7 by rl7);
CHECKREG r0, 0xffff0000;
CHECKREG r1, 0xffff0000;
CHECKREG r2, 0xffff0000;
CHECKREG r3, 0xffff0000;
CHECKREG r4, 0xffff0000;
CHECKREG r5, 0xffff0000;
CHECKREG r6, 0xffff0000;
//CHECKREG r7, -16;
pass
