#!/bin/bash

function user_confirmation {
    echo # new line
    read -p "Press \"y\" to continue " -n 1 -r
    echo -e "\n" # two new lines

    if [[ ! $REPLY =~ ^[Yy]$ ]]; then
        echo "aborting"
        exit 1
    fi
}


read -d '' DISCLAIMER <<- EOF
This script updates the microcontroller firmware (RO part). The change is
persistent across power cycles. Incorrect updates can only fixed be a manual
process which requires opening the enclosure.

Updating the microcontroller firmware (RO part) is only required if the Ettus
Research support told you to do so.

EOF

echo "$DISCLAIMER"
user_confirmation

if (grep -q -e musl /usr/lib/libc.so 2>/dev/null); then
    # musl is used as libc
    ECTOOL=./ectool-musl
else
    ECTOOL=./ectool
fi

CURRENT_VERSION=$($ECTOOL version)
CURRENT_RO_VERSION=$(echo "$CURRENT_VERSION" | grep "^RO version")
BOARD=$(echo "$CURRENT_RO_VERSION" | sed "s|^RO version:\s*\([a-z0-9\-]*\).*|\1|")
REV=$($ECTOOL boardversion)

case $BOARD in
    "neon"):
        let RO_SIZE=0x10000
     ;;
     *):
        echo "unsupported board: $BOARD"
        exit 1
esac

BASENAME="ec-$BOARD-rev$REV"
RO_FILE="$BASENAME.RO.flat"
if [ ! -e $RO_FILE ]; then
    echo "could not find file $RO_FILE"
    exit 1
fi

if [ -r $RO_FILE.version ]; then
    NEW_RO_VERSION="$(cat $RO_FILE.version)"
else
    NEW_RO_VERSION="RO version:    N/A"
fi

echo "This script will flash $RO_FILE to the device"
echo "old $CURRENT_RO_VERSION"
echo "new $NEW_RO_VERSION"

user_confirmation

ECTOOL=$ECTOOL RO_FILE=$RO_FILE RO_SIZE=$RO_SIZE make flash

if [ $? -ne 0 ]; then
    echo "update failed"
    exit 1
fi

echo
echo "copying new firmware files"
cp -v $BASENAME.bin $BASENAME.RW.bin /lib/firmware/ni

