#!/bin/sh
#
# (c) Copyright 2014,
# National Instruments Corporation.
# All rights reserved.
#
# File: nikaliInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nikali installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nikalDir="`cat /etc/natinst/nikal/nikal.dir`"
nikaliVersion=14.0.0b3
statusSuccess=0
statusSuccessReboot=1
statusFail=2

nikaliPreInstall()
{
   return $statusSuccess
}


nikaliPostInstall()
{
   if ! /usr/local/bin/updateNIDrivers --no-prompt; then
      return $statusFail
   fi
   return $statusSuccess
}


nikaliPreUninstall()
{
   cd "$nikalDir"/src/client
   make clean
   cd - > /dev/null 2>&1

   cd "$nikalDir"/src/nikal
   make clean
   make uninstall
   rm -f Makefile.in
   cd - > /dev/null 2>&1
   return $statusSuccess
}


nikaliPostUninstall()
{
   return $statusSuccess
}

