#!/bin/sh
#
# (c) Copyright 2015,
# National Instruments Corporation.
# All rights reserved.
#
# File: nibdskiInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nibdski installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nibdsDir="`cat /etc/natinst/nibds/nibds.dir`"
nibdskiVersion=15.0.0f0
statusSuccess=0
statusSuccessReboot=1
statusFail=2

nibdskiPreInstall()
{
   return $statusSuccess
}


nibdskiPostInstall()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nibds -i "$nibdsDir"/src/objects/nibds-unversioned.o
   return $statusSuccess
}


nibdskiPreUninstall()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nibds -r "$nibdsDir"/src/objects/nibds-unversioned.o
   return $statusSuccess
}


nibdskiPostUninstall()
{
   return $statusSuccess
}

