#!/bin/sh
#
# (c) Copyright 2015,
# National Instruments Corporation.
# All rights reserved.
#
# File: nip2pkiInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nip2pki installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nip2pDir="`cat /etc/natinst/nip2p/nip2p.dir`"
nip2pkiVersion=15.0.0f0
statusSuccess=0
statusSuccessReboot=1
statusFail=2

nip2pkiPreInstall()
{
   return $statusSuccess
}


nip2pkiPostInstall()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nip2p -i "$nip2pDir"/src/objects/nistreamk-unversioned.o
   return $statusSuccess
}


nip2pkiPreUninstall()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nip2p -r "$nip2pDir"/src/objects/nistreamk-unversioned.o
   return $statusSuccess
}


nip2pkiPostUninstall()
{
   return $statusSuccess
}

