#!/bin/sh
#
# (c) Copyright 2015,
# National Instruments Corporation.
# All rights reserved.
#
# File: nikaliInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nikali installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nikalDir="`cat /etc/natinst/nikal/nikal.dir`"
nikaliVersion=15.0.1f0
statusSuccess=0
statusSuccessReboot=1
statusFail=2

nikaliPreInstall()
{
   return $statusSuccess
}


nikaliPostInstall()
{
mkdir -p /usr/local/sbin
if ! /usr/local/bin/updateNIDrivers --no-prompt; then
   return $statusFail
fi

   return $statusSuccess
}


nikaliPreUninstall()
{
for kalmod in /lib/modules/*/kernel/natinst/nikal/nikal.ko; do
   rm -f ${kalmod}
   rmdir -p $(dirname ${kalmod}) 2>&1 > /dev/null
done

rm -f /usr/local/sbin/nidevnode
rm -rf /var/lib/nikal

/sbin/depmod

   return $statusSuccess
}


nikaliPostUninstall()
{
   return $statusSuccess
}

