#!/bin/sh
#
# (c) Copyright 2015,
# National Instruments Corporation.
# All rights reserved.
#
# File: ni_kalInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   ni_kal installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nikalDir="/usr/local/natinst/nikal"
statusSuccess=0
statusSuccessReboot=1
statusFail=2

ni_kalPreInstall()
{
   return $statusSuccess
}


ni_kalPostInstall()
{
   return $statusSuccess
}


ni_kalPreUninstall()
{
   for kalmod in /lib/modules/*/kernel/natinst/nikal/nikal.ko; do
      rm -f ${kalmod}
      rmdir -p $(dirname ${kalmod}) > /dev/null 2>&1
   done

   return $statusSuccess
}


ni_kalPostUninstall()
{
   # Client modules may be getting unregistered after the package system
   # transaction has completed, in which case clientkdb may not have been
   # empty yet during uninstall
   rmdir -p ${nikalDir}/etc/clientkdb > /dev/null 2>&1
   return $statusSuccess
}

