#!/bin/sh
#
# (c) Copyright 2018,
# National Instruments Corporation.
# All rights reserved.
#
# File: nirioiInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nirioi installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nirioDir="`cat /etc/natinst/nirio/nirio.dir`"
nirioiVersion=17.0.0f0
statusSuccess=0
statusSuccessReboot=1
statusFail=2

nirioiPreInstall()
{
   return $statusSuccess
}


nirioiPostInstall64()
{
   # Create NI-RIO ini file directory
   mkdir -p /var/local/natinst/nirio/etc
   chmod 0777 /var/local/natinst/nirio/etc

   mkdir -p /usr/local/natinst/share/NI-RIO/Plugins
   ln -sf /usr/local/natinst/nirio/etc/NiRioSrvEnumeratorPlugin.ini /usr/local/natinst/share/NI-RIO/Plugins/NiRioSrvEnumeratorPlugin.ini

   touch /var/local/natinst/nirio/DeviceList.lck
   chmod a+r /var/local/natinst/nirio/DeviceList.lck

   return $statusSuccess
}


nirioiPreUninstall64()
{
   # Create NI-RIO ini file directory
   mkdir -p /var/local/natinst/nirio/etc
   chmod 0777 /var/local/natinst/nirio/etc

   mkdir -p /usr/local/natinst/share/NI-RIO/Plugins
   ln -sf /usr/local/natinst/nirio/etc/NiRioSrvEnumeratorPlugin.ini /usr/local/natinst/share/NI-RIO/Plugins/NiRioSrvEnumeratorPlugin.ini

   touch /var/local/natinst/nirio/DeviceList.lck
   chmod a+r /var/local/natinst/nirio/DeviceList.lck

   return $statusSuccess
}


nirioiPostUninstall64()
{
   return $statusSuccess
}

