#!/bin/sh
#
# (c) Copyright 2018,
# National Instruments Corporation.
# All rights reserved.
#
# File: niusrpriokiInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   niusrprioki installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

niusrpDir="`cat /etc/natinst/niusrp/niusrp.dir`"
niusrpriokiVersion=18.0.0.49154f2
statusSuccess=0
statusSuccessReboot=1
statusFail=2

niusrpriokiPreInstall()
{
   return $statusSuccess
}


niusrpriokiPostInstall64()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d niusrp -i "$niusrpDir"/src/objects64/niusrpriok-unversioned.o
   return $statusSuccess
}


niusrpriokiPreUninstall64()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d niusrp -r "$niusrpDir"/src/objects64/niusrpriok-unversioned.o
   return $statusSuccess
}


niusrpriokiPostUninstall64()
{
   return $statusSuccess
}

