#!/bin/sh
#
# (c) Copyright 2018,
# National Instruments Corporation.
# All rights reserved.
#
# File: niriokiInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nirioki installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nirioDir="`cat /etc/natinst/nirio/nirio.dir`"
niriokiVersion=17.0.0f1
statusSuccess=0
statusSuccessReboot=1
statusFail=2

niriokiPreInstall()
{
   return $statusSuccess
}


niriokiPostInstall64()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nirio -i "$nirioDir"/src/objects64/NiRioSrv-unversioned.o
   return $statusSuccess
}


niriokiPreUninstall64()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nirio -r "$nirioDir"/src/objects64/NiRioSrv-unversioned.o
   return $statusSuccess
}


niriokiPostUninstall64()
{
   return $statusSuccess
}

