#!/bin/sh
#
# (c) Copyright 2015,
# National Instruments Corporation.
# All rights reserved.
#
# File: ni_bds_nikalmodInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   ni_bds_nikalmod installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nibdsDir="/usr/local/natinst/nibds"
statusSuccess=0
statusSuccessReboot=1
statusFail=2

ni_bds_nikalmodPreInstall()
{
   return $statusSuccess
}


ni_bds_nikalmodPostInstall()
{
   "/usr/local/natinst/nikal/bin/nikalKernelInstaller.sh" -d nibds -i "/usr/local/natinst/nibds/src/objects/nibds-unversioned.o"
   return $statusSuccess
}


ni_bds_nikalmodPreUninstall()
{
   "/usr/local/natinst/nikal/bin/nikalKernelInstaller.sh" -d nibds -r "/usr/local/natinst/nibds/src/objects/nibds-unversioned.o"
   return $statusSuccess
}


ni_bds_nikalmodPostUninstall()
{
   return $statusSuccess
}

