#ifndef ___nip2p_status_h___
#define ___nip2p_status_h___

#include "PublicIncludes/nistreamCommon/prefix.h"

//============================================================================
//  Error Codes
//============================================================================

#define NIP2P_ERROR_BASE                              -308000L
#define NIP2P_MAX_NUM_ERROR_CODES                     1000L
#define kNIP2PStatusSuccess                           0L
#define kNIP2PStatusMemoryFull                        (NIP2P_ERROR_BASE - 0)
#define kNIP2PStatusNotSupported                      (NIP2P_ERROR_BASE - 1)
#define kNIP2PStatusIOOperationFailed                 (NIP2P_ERROR_BASE - 2)
#define kNIP2PStatusDeviceNotFound                    (NIP2P_ERROR_BASE - 3)
#define kNIP2PStatusBadPointer                        (NIP2P_ERROR_BASE - 4)
#define kNIP2PStatusStreamResourcesInUse              (NIP2P_ERROR_BASE - 5)
#define kNIP2PStatusEndpointAlreadyExists             (NIP2P_ERROR_BASE - 6)
#define kNIP2PStatusEndpointNotFound                  (NIP2P_ERROR_BASE - 7)
#define kNIP2PStatusEndpointsAreEquivalent            (NIP2P_ERROR_BASE - 8)
#define kNIP2PStatusInvalidStreamId                   (NIP2P_ERROR_BASE - 9)
#define kNIP2PStatusDeviceAlreadyExists               (NIP2P_ERROR_BASE - 10)
#define kNIP2PStatusStreamNotFound                    (NIP2P_ERROR_BASE - 11)
#define kNIP2PStatusStreamNotLinked                   (NIP2P_ERROR_BASE - 12)
#define kNIP2PStatusInvalidEndpointInterface          (NIP2P_ERROR_BASE - 13)
#define kNIP2PStatusEndpointNotCapable                (NIP2P_ERROR_BASE - 14)
#define kNIP2PStatusStreamNotEnabled                  (NIP2P_ERROR_BASE - 15)
#define kNIP2PStatusInvalidStreamHandle               (NIP2P_ERROR_BASE - 16)
#define kNIP2PStatusInvalidAttributeType              (NIP2P_ERROR_BASE - 17)
#define kNIP2PStatusInvalidAttribute                  (NIP2P_ERROR_BASE - 18)
#define kNIP2PStatusIncompatibleEndpoints             (NIP2P_ERROR_BASE - 19)
#define kNIP2PStatusPeerInterfaceNotSupported         (NIP2P_ERROR_BASE - 20)
#define kNIP2PStatusInvalidEndpointHandle             (NIP2P_ERROR_BASE - 21)
#define kNIP2PStatusIncompatibleDataTypes             (NIP2P_ERROR_BASE - 22)
#define kNIP2PStatusInvalidEvent                      (NIP2P_ERROR_BASE - 23)
#define kNIP2PStatusOperationTimedOut                 (NIP2P_ERROR_BASE - 24)
#define kNIP2PStatusStreamWasClosed                   (NIP2P_ERROR_BASE - 25)
#define kNIP2PStatusAttributeNotSettable              (NIP2P_ERROR_BASE - 26)
#define kNIP2PStatusEndpointsOnSameDevice             (NIP2P_ERROR_BASE - 27)
#define kNIP2PStatusEventNotSupported                 (NIP2P_ERROR_BASE - 28)
#define kNIP2PStatusEventUnregistered                 (NIP2P_ERROR_BASE - 29)
#define kNIP2PStatusInvalidP2PLinkPath                (NIP2P_ERROR_BASE - 30)
#define kNIP2PStatusSoftwareFault                     (NIP2P_ERROR_BASE - 31)
#define kNIP2PStatusInvalidDataType                   (NIP2P_ERROR_BASE - 32)


//============================================================================
//  Warning Codes
//============================================================================
#define NIP2P_WARNING_BASE                            308000L
#define NIP2P_MAX_NUM_WARNING_CODES                   100L
#define kNIP2PStatusDataTypeSignMismatch              (NIP2P_WARNING_BASE + 0)

#include "PublicIncludes/nistreamCommon/postfix.h"

#endif
