#!/bin/sh
#
# (c) Copyright 2015,
# National Instruments Corporation.
# All rights reserved.
#
# File: niriokiInstallerUtility.sh
#
#   This utility script provides installation functions for the
#   nirioki installer.  Each function is meant to execute at the
#   specified time (preInstall) in order to properly install the package.
#   Without calling these functions the package is not completely installed.
#   The INSTALL script provided with the distribution calls these functions.
#

nirioDir="`cat /etc/natinst/nirio/nirio.dir`"
niriokiVersion=15.0.0f0
statusSuccess=0
statusSuccessReboot=1
statusFail=2

niriokiPreInstall()
{
   return $statusSuccess
}


niriokiPostInstall()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nirio -i "$nirioDir"/src/objects/NiRioSrv-unversioned.o
   return $statusSuccess
}


niriokiPreUninstall()
{
   "`cat /etc/natinst/nikal/nikal.dir`"/bin/nikalKernelInstaller.sh -d nirio -r "$nirioDir"/src/objects/NiRioSrv-unversioned.o
   return $statusSuccess
}


niriokiPostUninstall()
{
   return $statusSuccess
}

