//
// Copyright 2025 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: dig_ifc_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // SPI_SLAVE_CONFIG       : 0x0 (x4xx_gpio_spi.v)
  // SPI_TRANSACTION_CONFIG : 0x10 (x4xx_gpio_spi.v)
  // SPI_TRANSACTION_GO     : 0x14 (x4xx_gpio_spi.v)
  // SPI_STATUS             : 0x18 (x4xx_gpio_spi.v)
  // CONTROLLER_INFO        : 0x1C (x4xx_gpio_spi.v)

//===============================================================================
// RegTypes
//===============================================================================

  // SPI_SETUP Type (from x4xx_gpio_spi.v)
  localparam SPI_SETUP_SIZE = 32;
  localparam SPI_SETUP_MASK = 32'hFFFFFFF;
  localparam SLAVE_CLK_SIZE = 5;  //SPI_SETUP:SLAVE_CLK
  localparam SLAVE_CLK_MSB  = 4;  //SPI_SETUP:SLAVE_CLK
  localparam SLAVE_CLK      = 0;  //SPI_SETUP:SLAVE_CLK
  localparam SLAVE_MOSI_SIZE = 5;  //SPI_SETUP:SLAVE_MOSI
  localparam SLAVE_MOSI_MSB  = 9;  //SPI_SETUP:SLAVE_MOSI
  localparam SLAVE_MOSI      = 5;  //SPI_SETUP:SLAVE_MOSI
  localparam SLAVE_MISO_SIZE =  5;  //SPI_SETUP:SLAVE_MISO
  localparam SLAVE_MISO_MSB  = 14;  //SPI_SETUP:SLAVE_MISO
  localparam SLAVE_MISO      = 10;  //SPI_SETUP:SLAVE_MISO
  localparam SLAVE_CS_SIZE =  5;  //SPI_SETUP:SLAVE_CS
  localparam SLAVE_CS_MSB  = 19;  //SPI_SETUP:SLAVE_CS
  localparam SLAVE_CS      = 15;  //SPI_SETUP:SLAVE_CS
  localparam SPI_LENGTH_SIZE =  6;  //SPI_SETUP:SPI_LENGTH
  localparam SPI_LENGTH_MSB  = 25;  //SPI_SETUP:SPI_LENGTH
  localparam SPI_LENGTH      = 20;  //SPI_SETUP:SPI_LENGTH
  localparam MISO_EDGE_SIZE =  1;  //SPI_SETUP:MISO_EDGE
  localparam MISO_EDGE_MSB  = 26;  //SPI_SETUP:MISO_EDGE
  localparam MISO_EDGE      = 26;  //SPI_SETUP:MISO_EDGE
  localparam MOSI_EDGE_SIZE =  1;  //SPI_SETUP:MOSI_EDGE
  localparam MOSI_EDGE_MSB  = 27;  //SPI_SETUP:MOSI_EDGE
  localparam MOSI_EDGE      = 27;  //SPI_SETUP:MOSI_EDGE

//===============================================================================
// Register Group SPI_OVER_GPIO_REGS
//===============================================================================

  // SPI_SLAVE_CONFIG Register (from x4xx_gpio_spi.v)
  localparam SPI_SLAVE_CONFIG_COUNT = 4; // Number of elements in array

  // SPI_TRANSACTION_CONFIG Register (from x4xx_gpio_spi.v)
  localparam SPI_TRANSACTION_CONFIG = 'h10; // Register Offset
  localparam SPI_TRANSACTION_CONFIG_SIZE = 32;  // register width in bits
  localparam SPI_TRANSACTION_CONFIG_MASK = 32'h3FFFF;
  localparam SPI_CLK_DIV_SIZE = 16;  //SPI_TRANSACTION_CONFIG:SPI_CLK_DIV
  localparam SPI_CLK_DIV_MSB  = 15;  //SPI_TRANSACTION_CONFIG:SPI_CLK_DIV
  localparam SPI_CLK_DIV      =  0;  //SPI_TRANSACTION_CONFIG:SPI_CLK_DIV
  localparam SPI_SLAVE_SELECT_SIZE =  2;  //SPI_TRANSACTION_CONFIG:SPI_SLAVE_SELECT
  localparam SPI_SLAVE_SELECT_MSB  = 17;  //SPI_TRANSACTION_CONFIG:SPI_SLAVE_SELECT
  localparam SPI_SLAVE_SELECT      = 16;  //SPI_TRANSACTION_CONFIG:SPI_SLAVE_SELECT

  // SPI_TRANSACTION_GO Register (from x4xx_gpio_spi.v)
  localparam SPI_TRANSACTION_GO = 'h14; // Register Offset
  localparam SPI_TRANSACTION_GO_SIZE = 32;  // register width in bits
  localparam SPI_TRANSACTION_GO_MASK = 32'hFFFFFFFF;
  localparam SPI_DATA_SIZE = 32;  //SPI_TRANSACTION_GO:SPI_DATA
  localparam SPI_DATA_MSB  = 31;  //SPI_TRANSACTION_GO:SPI_DATA
  localparam SPI_DATA      =  0;  //SPI_TRANSACTION_GO:SPI_DATA

  // SPI_STATUS Register (from x4xx_gpio_spi.v)
  localparam SPI_STATUS = 'h18; // Register Offset
  localparam SPI_STATUS_SIZE = 32;  // register width in bits
  localparam SPI_STATUS_MASK = 32'h1FFFFFF;
  localparam SPI_RESPONSE_SIZE = 24;  //SPI_STATUS:SPI_RESPONSE
  localparam SPI_RESPONSE_MSB  = 23;  //SPI_STATUS:SPI_RESPONSE
  localparam SPI_RESPONSE      =  0;  //SPI_STATUS:SPI_RESPONSE
  localparam SPI_READY_SIZE =  1;  //SPI_STATUS:SPI_READY
  localparam SPI_READY_MSB  = 24;  //SPI_STATUS:SPI_READY
  localparam SPI_READY      = 24;  //SPI_STATUS:SPI_READY

  // CONTROLLER_INFO Register (from x4xx_gpio_spi.v)
  localparam CONTROLLER_INFO = 'h1C; // Register Offset
  localparam CONTROLLER_INFO_SIZE = 32;  // register width in bits
  localparam CONTROLLER_INFO_MASK = 32'hF;
  localparam SLAVE_COUNT_SIZE = 4;  //CONTROLLER_INFO:SLAVE_COUNT
  localparam SLAVE_COUNT_MSB  = 3;  //CONTROLLER_INFO:SLAVE_COUNT
  localparam SLAVE_COUNT      = 0;  //CONTROLLER_INFO:SLAVE_COUNT

  // Return the offset of an element of register array SPI_SLAVE_CONFIG
  function automatic integer SPI_SLAVE_CONFIG (input integer i);
  begin
    SPI_SLAVE_CONFIG = (i * 'h4) + 'h0;
  end
  endfunction
