/***********************************************************************
 * This file was generated by /root/uhddev/host/lib/ic_reg_maps/gen_ad9522_regs.py on Fri Sep  6 06:41:44 2013
 **********************************************************************/

#ifndef INCLUDED_AD9522_REGS_HPP
#define INCLUDED_AD9522_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <boost/cstdint.hpp>
#include <set>

class ad9522_regs_t{
public:
    enum sdo_active_t{
        SDO_ACTIVE_SDIO = 0,
        SDO_ACTIVE_SDO_SDIO = 1
    };
    sdo_active_t sdo_active;
    enum lsb_first_addr_incr_t{
        LSB_FIRST_ADDR_INCR_MSB = 0,
        LSB_FIRST_ADDR_INCR_LSB = 1
    };
    lsb_first_addr_incr_t lsb_first_addr_incr;
    boost::uint8_t soft_reset;
    boost::uint8_t mirror;
    enum readback_active_registers_t{
        READBACK_ACTIVE_REGISTERS_BUFFER = 0,
        READBACK_ACTIVE_REGISTERS_ACTIVE = 1
    };
    readback_active_registers_t readback_active_registers;
    enum pfd_polarity_t{
        PFD_POLARITY_POS = 0,
        PFD_POLARITY_NEG = 1
    };
    pfd_polarity_t pfd_polarity;
    enum cp_current_t{
        CP_CURRENT_0_6MA = 0,
        CP_CURRENT_1_2MA = 1,
        CP_CURRENT_1_8MA = 2,
        CP_CURRENT_2_4MA = 3,
        CP_CURRENT_3_0MA = 4,
        CP_CURRENT_3_6MA = 5,
        CP_CURRENT_4_2MA = 6,
        CP_CURRENT_4_8MA = 7
    };
    cp_current_t cp_current;
    enum cp_mode_t{
        CP_MODE_HIGH_IMP = 0,
        CP_MODE_FORCE_SOURCE = 1,
        CP_MODE_FORCE_SINK = 2,
        CP_MODE_NORMAL = 3
    };
    cp_mode_t cp_mode;
    enum pll_power_down_t{
        PLL_POWER_DOWN_NORMAL = 0,
        PLL_POWER_DOWN_ASYNC = 1,
        PLL_POWER_DOWN_SYNC = 3
    };
    pll_power_down_t pll_power_down;
    boost::uint8_t r_counter_lsb;
    boost::uint8_t r_counter_msb;
    boost::uint8_t a_counter;
    boost::uint8_t b_counter_lsb;
    boost::uint8_t b_counter_msb;
    enum set_cp_pin_to_vcp_2_t{
        SET_CP_PIN_TO_VCP_2_NORMAL = 0,
        SET_CP_PIN_TO_VCP_2_VCP_2 = 1
    };
    set_cp_pin_to_vcp_2_t set_cp_pin_to_vcp_2;
    boost::uint8_t reset_r_counter;
    boost::uint8_t reset_a_and_b_counters;
    boost::uint8_t reset_all_counters;
    enum b_counter_bypass_t{
        B_COUNTER_BYPASS_NORMAL = 0,
        B_COUNTER_BYPASS_DIV1 = 1
    };
    b_counter_bypass_t b_counter_bypass;
    enum prescaler_p_t{
        PRESCALER_P_DIV1 = 0,
        PRESCALER_P_DIV2 = 1,
        PRESCALER_P_DIV2_3 = 2,
        PRESCALER_P_DIV4_5 = 3,
        PRESCALER_P_DIV8_9 = 4,
        PRESCALER_P_DIV16_17 = 5,
        PRESCALER_P_DIV32_33 = 6,
        PRESCALER_P_DIV3 = 7
    };
    prescaler_p_t prescaler_p;
    boost::uint8_t status_pin_control;
    enum antibacklash_pulse_width_t{
        ANTIBACKLASH_PULSE_WIDTH_2_9NS = 0,
        ANTIBACKLASH_PULSE_WIDTH_1_3NS = 1,
        ANTIBACKLASH_PULSE_WIDTH_6_0NS = 2
    };
    antibacklash_pulse_width_t antibacklash_pulse_width;
    boost::uint8_t enb_cmos_ref_input_dc_off;
    enum lock_detect_counter_t{
        LOCK_DETECT_COUNTER_5CYC = 0,
        LOCK_DETECT_COUNTER_16CYC = 1,
        LOCK_DETECT_COUNTER_64CYC = 2,
        LOCK_DETECT_COUNTER_255CYC = 3
    };
    lock_detect_counter_t lock_detect_counter;
    enum digital_lock_detect_window_t{
        DIGITAL_LOCK_DETECT_WINDOW_HIGH_RANGE = 0,
        DIGITAL_LOCK_DETECT_WINDOW_LOW_RANGE = 1
    };
    digital_lock_detect_window_t digital_lock_detect_window;
    enum disable_digital_lock_detect_t{
        DISABLE_DIGITAL_LOCK_DETECT_NORMAL = 0,
        DISABLE_DIGITAL_LOCK_DETECT_DISABLED = 1
    };
    disable_digital_lock_detect_t disable_digital_lock_detect;
    enum vco_calibration_divider_t{
        VCO_CALIBRATION_DIVIDER_DIV2 = 0,
        VCO_CALIBRATION_DIVIDER_DIV4 = 1,
        VCO_CALIBRATION_DIVIDER_DIV8 = 2,
        VCO_CALIBRATION_DIVIDER_DIV16 = 3
    };
    vco_calibration_divider_t vco_calibration_divider;
    boost::uint8_t vco_calibration_now;
    enum r_a_b_counters_sync_pin_rst_t{
        R_A_B_COUNTERS_SYNC_PIN_RST_NOTHING = 0,
        R_A_B_COUNTERS_SYNC_PIN_RST_ASYNC = 1,
        R_A_B_COUNTERS_SYNC_PIN_RST_SYNC = 2
    };
    r_a_b_counters_sync_pin_rst_t r_a_b_counters_sync_pin_rst;
    boost::uint8_t r_path_delay;
    boost::uint8_t n_path_delay;
    boost::uint8_t enable_status_pin_divider;
    enum ref_freq_monitor_threshold_t{
        REF_FREQ_MONITOR_THRESHOLD_1_02MHZ = 0,
        REF_FREQ_MONITOR_THRESHOLD_6KHZ = 1
    };
    ref_freq_monitor_threshold_t ref_freq_monitor_threshold;
    boost::uint8_t ld_pin_control;
    boost::uint8_t enable_vco_freq_monitor;
    boost::uint8_t enable_ref2_freq_monitor;
    boost::uint8_t enable_ref1_freq_monitor;
    boost::uint8_t refmon_pin_control;
    boost::uint8_t disable_switchover_deglitch;
    enum select_ref_t{
        SELECT_REF_REF1 = 0,
        SELECT_REF_REF2 = 1
    };
    select_ref_t select_ref;
    enum use_ref_sel_pin_t{
        USE_REF_SEL_PIN_REGISTER = 0,
        USE_REF_SEL_PIN_REF_SEL = 1
    };
    use_ref_sel_pin_t use_ref_sel_pin;
    enum enb_auto_ref_switchover_t{
        ENB_AUTO_REF_SWITCHOVER_MANUAL = 0,
        ENB_AUTO_REF_SWITCHOVER_AUTO = 1
    };
    enb_auto_ref_switchover_t enb_auto_ref_switchover;
    enum stay_on_ref2_t{
        STAY_ON_REF2_RETURN_REF1 = 0,
        STAY_ON_REF2_STAY_REF2 = 1
    };
    stay_on_ref2_t stay_on_ref2;
    boost::uint8_t enable_ref2;
    boost::uint8_t enable_ref1;
    boost::uint8_t enable_differential_ref;
    boost::uint8_t enb_stat_eeprom_at_stat_pin;
    boost::uint8_t enable_xtal_osc;
    boost::uint8_t enable_clock_doubler;
    boost::uint8_t disable_pll_status_reg;
    boost::uint8_t enable_ld_pin_comparator;
    boost::uint8_t enable_external_holdover;
    boost::uint8_t enable_holdover;
    boost::uint8_t external_zero_delay_fcds;
    boost::uint8_t enable_external_zero_delay;
    boost::uint8_t enable_zero_delay;
    boost::uint8_t vco_calibration_finished;
    boost::uint8_t holdover_active;
    boost::uint8_t ref2_selected;
    boost::uint8_t vco_freq_gt_thresh;
    boost::uint8_t ref2_freq_gt_thresh;
    boost::uint8_t ref1_freq_gt_thresh;
    boost::uint8_t digital_lock_detect;
    enum out0_format_t{
        OUT0_FORMAT_LVDS = 0,
        OUT0_FORMAT_CMOS = 1
    };
    out0_format_t out0_format;
    enum out0_cmos_configuration_t{
        OUT0_CMOS_CONFIGURATION_OFF = 0,
        OUT0_CMOS_CONFIGURATION_A_ON = 1,
        OUT0_CMOS_CONFIGURATION_B_ON = 2,
        OUT0_CMOS_CONFIGURATION_AB_ON = 3
    };
    out0_cmos_configuration_t out0_cmos_configuration;
    enum out0_polarity_t{
        OUT0_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT0_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT0_POLARITY_CMOS_AB_NON = 0,
        OUT0_POLARITY_CMOS_AB_INV = 1,
        OUT0_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT0_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out0_polarity_t out0_polarity;
    enum out0_lvds_diff_voltage_t{
        OUT0_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT0_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT0_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT0_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out0_lvds_diff_voltage_t out0_lvds_diff_voltage;
    boost::uint8_t out0_lvds_power_down;
    enum out1_format_t{
        OUT1_FORMAT_LVDS = 0,
        OUT1_FORMAT_CMOS = 1
    };
    out1_format_t out1_format;
    enum out1_cmos_configuration_t{
        OUT1_CMOS_CONFIGURATION_OFF = 0,
        OUT1_CMOS_CONFIGURATION_A_ON = 1,
        OUT1_CMOS_CONFIGURATION_B_ON = 2,
        OUT1_CMOS_CONFIGURATION_AB_ON = 3
    };
    out1_cmos_configuration_t out1_cmos_configuration;
    enum out1_polarity_t{
        OUT1_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT1_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT1_POLARITY_CMOS_AB_NON = 0,
        OUT1_POLARITY_CMOS_AB_INV = 1,
        OUT1_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT1_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out1_polarity_t out1_polarity;
    enum out1_lvds_diff_voltage_t{
        OUT1_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT1_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT1_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT1_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out1_lvds_diff_voltage_t out1_lvds_diff_voltage;
    boost::uint8_t out1_lvds_power_down;
    enum out2_format_t{
        OUT2_FORMAT_LVDS = 0,
        OUT2_FORMAT_CMOS = 1
    };
    out2_format_t out2_format;
    enum out2_cmos_configuration_t{
        OUT2_CMOS_CONFIGURATION_OFF = 0,
        OUT2_CMOS_CONFIGURATION_A_ON = 1,
        OUT2_CMOS_CONFIGURATION_B_ON = 2,
        OUT2_CMOS_CONFIGURATION_AB_ON = 3
    };
    out2_cmos_configuration_t out2_cmos_configuration;
    enum out2_polarity_t{
        OUT2_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT2_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT2_POLARITY_CMOS_AB_NON = 0,
        OUT2_POLARITY_CMOS_AB_INV = 1,
        OUT2_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT2_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out2_polarity_t out2_polarity;
    enum out2_lvds_diff_voltage_t{
        OUT2_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT2_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT2_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT2_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out2_lvds_diff_voltage_t out2_lvds_diff_voltage;
    boost::uint8_t out2_lvds_power_down;
    enum out3_format_t{
        OUT3_FORMAT_LVDS = 0,
        OUT3_FORMAT_CMOS = 1
    };
    out3_format_t out3_format;
    enum out3_cmos_configuration_t{
        OUT3_CMOS_CONFIGURATION_OFF = 0,
        OUT3_CMOS_CONFIGURATION_A_ON = 1,
        OUT3_CMOS_CONFIGURATION_B_ON = 2,
        OUT3_CMOS_CONFIGURATION_AB_ON = 3
    };
    out3_cmos_configuration_t out3_cmos_configuration;
    enum out3_polarity_t{
        OUT3_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT3_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT3_POLARITY_CMOS_AB_NON = 0,
        OUT3_POLARITY_CMOS_AB_INV = 1,
        OUT3_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT3_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out3_polarity_t out3_polarity;
    enum out3_lvds_diff_voltage_t{
        OUT3_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT3_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT3_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT3_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out3_lvds_diff_voltage_t out3_lvds_diff_voltage;
    boost::uint8_t out3_lvds_power_down;
    enum out4_format_t{
        OUT4_FORMAT_LVDS = 0,
        OUT4_FORMAT_CMOS = 1
    };
    out4_format_t out4_format;
    enum out4_cmos_configuration_t{
        OUT4_CMOS_CONFIGURATION_OFF = 0,
        OUT4_CMOS_CONFIGURATION_A_ON = 1,
        OUT4_CMOS_CONFIGURATION_B_ON = 2,
        OUT4_CMOS_CONFIGURATION_AB_ON = 3
    };
    out4_cmos_configuration_t out4_cmos_configuration;
    enum out4_polarity_t{
        OUT4_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT4_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT4_POLARITY_CMOS_AB_NON = 0,
        OUT4_POLARITY_CMOS_AB_INV = 1,
        OUT4_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT4_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out4_polarity_t out4_polarity;
    enum out4_lvds_diff_voltage_t{
        OUT4_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT4_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT4_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT4_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out4_lvds_diff_voltage_t out4_lvds_diff_voltage;
    boost::uint8_t out4_lvds_power_down;
    enum out5_format_t{
        OUT5_FORMAT_LVDS = 0,
        OUT5_FORMAT_CMOS = 1
    };
    out5_format_t out5_format;
    enum out5_cmos_configuration_t{
        OUT5_CMOS_CONFIGURATION_OFF = 0,
        OUT5_CMOS_CONFIGURATION_A_ON = 1,
        OUT5_CMOS_CONFIGURATION_B_ON = 2,
        OUT5_CMOS_CONFIGURATION_AB_ON = 3
    };
    out5_cmos_configuration_t out5_cmos_configuration;
    enum out5_polarity_t{
        OUT5_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT5_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT5_POLARITY_CMOS_AB_NON = 0,
        OUT5_POLARITY_CMOS_AB_INV = 1,
        OUT5_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT5_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out5_polarity_t out5_polarity;
    enum out5_lvds_diff_voltage_t{
        OUT5_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT5_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT5_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT5_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out5_lvds_diff_voltage_t out5_lvds_diff_voltage;
    boost::uint8_t out5_lvds_power_down;
    enum out6_format_t{
        OUT6_FORMAT_LVDS = 0,
        OUT6_FORMAT_CMOS = 1
    };
    out6_format_t out6_format;
    enum out6_cmos_configuration_t{
        OUT6_CMOS_CONFIGURATION_OFF = 0,
        OUT6_CMOS_CONFIGURATION_A_ON = 1,
        OUT6_CMOS_CONFIGURATION_B_ON = 2,
        OUT6_CMOS_CONFIGURATION_AB_ON = 3
    };
    out6_cmos_configuration_t out6_cmos_configuration;
    enum out6_polarity_t{
        OUT6_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT6_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT6_POLARITY_CMOS_AB_NON = 0,
        OUT6_POLARITY_CMOS_AB_INV = 1,
        OUT6_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT6_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out6_polarity_t out6_polarity;
    enum out6_lvds_diff_voltage_t{
        OUT6_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT6_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT6_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT6_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out6_lvds_diff_voltage_t out6_lvds_diff_voltage;
    boost::uint8_t out6_lvds_power_down;
    enum out7_format_t{
        OUT7_FORMAT_LVDS = 0,
        OUT7_FORMAT_CMOS = 1
    };
    out7_format_t out7_format;
    enum out7_cmos_configuration_t{
        OUT7_CMOS_CONFIGURATION_OFF = 0,
        OUT7_CMOS_CONFIGURATION_A_ON = 1,
        OUT7_CMOS_CONFIGURATION_B_ON = 2,
        OUT7_CMOS_CONFIGURATION_AB_ON = 3
    };
    out7_cmos_configuration_t out7_cmos_configuration;
    enum out7_polarity_t{
        OUT7_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT7_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT7_POLARITY_CMOS_AB_NON = 0,
        OUT7_POLARITY_CMOS_AB_INV = 1,
        OUT7_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT7_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out7_polarity_t out7_polarity;
    enum out7_lvds_diff_voltage_t{
        OUT7_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT7_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT7_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT7_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out7_lvds_diff_voltage_t out7_lvds_diff_voltage;
    boost::uint8_t out7_lvds_power_down;
    enum out8_format_t{
        OUT8_FORMAT_LVDS = 0,
        OUT8_FORMAT_CMOS = 1
    };
    out8_format_t out8_format;
    enum out8_cmos_configuration_t{
        OUT8_CMOS_CONFIGURATION_OFF = 0,
        OUT8_CMOS_CONFIGURATION_A_ON = 1,
        OUT8_CMOS_CONFIGURATION_B_ON = 2,
        OUT8_CMOS_CONFIGURATION_AB_ON = 3
    };
    out8_cmos_configuration_t out8_cmos_configuration;
    enum out8_polarity_t{
        OUT8_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT8_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT8_POLARITY_CMOS_AB_NON = 0,
        OUT8_POLARITY_CMOS_AB_INV = 1,
        OUT8_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT8_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out8_polarity_t out8_polarity;
    enum out8_lvds_diff_voltage_t{
        OUT8_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT8_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT8_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT8_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out8_lvds_diff_voltage_t out8_lvds_diff_voltage;
    boost::uint8_t out8_lvds_power_down;
    enum out9_format_t{
        OUT9_FORMAT_LVDS = 0,
        OUT9_FORMAT_CMOS = 1
    };
    out9_format_t out9_format;
    enum out9_cmos_configuration_t{
        OUT9_CMOS_CONFIGURATION_OFF = 0,
        OUT9_CMOS_CONFIGURATION_A_ON = 1,
        OUT9_CMOS_CONFIGURATION_B_ON = 2,
        OUT9_CMOS_CONFIGURATION_AB_ON = 3
    };
    out9_cmos_configuration_t out9_cmos_configuration;
    enum out9_polarity_t{
        OUT9_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT9_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT9_POLARITY_CMOS_AB_NON = 0,
        OUT9_POLARITY_CMOS_AB_INV = 1,
        OUT9_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT9_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out9_polarity_t out9_polarity;
    enum out9_lvds_diff_voltage_t{
        OUT9_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT9_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT9_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT9_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out9_lvds_diff_voltage_t out9_lvds_diff_voltage;
    boost::uint8_t out9_lvds_power_down;
    enum out10_format_t{
        OUT10_FORMAT_LVDS = 0,
        OUT10_FORMAT_CMOS = 1
    };
    out10_format_t out10_format;
    enum out10_cmos_configuration_t{
        OUT10_CMOS_CONFIGURATION_OFF = 0,
        OUT10_CMOS_CONFIGURATION_A_ON = 1,
        OUT10_CMOS_CONFIGURATION_B_ON = 2,
        OUT10_CMOS_CONFIGURATION_AB_ON = 3
    };
    out10_cmos_configuration_t out10_cmos_configuration;
    enum out10_polarity_t{
        OUT10_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT10_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT10_POLARITY_CMOS_AB_NON = 0,
        OUT10_POLARITY_CMOS_AB_INV = 1,
        OUT10_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT10_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out10_polarity_t out10_polarity;
    enum out10_lvds_diff_voltage_t{
        OUT10_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT10_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT10_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT10_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out10_lvds_diff_voltage_t out10_lvds_diff_voltage;
    boost::uint8_t out10_lvds_power_down;
    enum out11_format_t{
        OUT11_FORMAT_LVDS = 0,
        OUT11_FORMAT_CMOS = 1
    };
    out11_format_t out11_format;
    enum out11_cmos_configuration_t{
        OUT11_CMOS_CONFIGURATION_OFF = 0,
        OUT11_CMOS_CONFIGURATION_A_ON = 1,
        OUT11_CMOS_CONFIGURATION_B_ON = 2,
        OUT11_CMOS_CONFIGURATION_AB_ON = 3
    };
    out11_cmos_configuration_t out11_cmos_configuration;
    enum out11_polarity_t{
        OUT11_POLARITY_LVDS_A_NON_B_INV = 0,
        OUT11_POLARITY_LVDS_A_INV_B_NON = 1,
        OUT11_POLARITY_CMOS_AB_NON = 0,
        OUT11_POLARITY_CMOS_AB_INV = 1,
        OUT11_POLARITY_CMOS_A_NON_B_INV = 2,
        OUT11_POLARITY_CMOS_A_INV_B_NON = 3
    };
    out11_polarity_t out11_polarity;
    enum out11_lvds_diff_voltage_t{
        OUT11_LVDS_DIFF_VOLTAGE_1_75MA = 0,
        OUT11_LVDS_DIFF_VOLTAGE_3_5MA = 1,
        OUT11_LVDS_DIFF_VOLTAGE_5_25MA = 2,
        OUT11_LVDS_DIFF_VOLTAGE_7_0MA = 3
    };
    out11_lvds_diff_voltage_t out11_lvds_diff_voltage;
    boost::uint8_t out11_lvds_power_down;
    enum csdld_en_out_7_t{
        CSDLD_EN_OUT_7_IGNORE = 0,
        CSDLD_EN_OUT_7_ASYNC = 1
    };
    csdld_en_out_7_t csdld_en_out_7;
    enum csdld_en_out_6_t{
        CSDLD_EN_OUT_6_IGNORE = 0,
        CSDLD_EN_OUT_6_ASYNC = 1
    };
    csdld_en_out_6_t csdld_en_out_6;
    enum csdld_en_out_5_t{
        CSDLD_EN_OUT_5_IGNORE = 0,
        CSDLD_EN_OUT_5_ASYNC = 1
    };
    csdld_en_out_5_t csdld_en_out_5;
    enum csdld_en_out_4_t{
        CSDLD_EN_OUT_4_IGNORE = 0,
        CSDLD_EN_OUT_4_ASYNC = 1
    };
    csdld_en_out_4_t csdld_en_out_4;
    enum csdld_en_out_3_t{
        CSDLD_EN_OUT_3_IGNORE = 0,
        CSDLD_EN_OUT_3_ASYNC = 1
    };
    csdld_en_out_3_t csdld_en_out_3;
    enum csdld_en_out_2_t{
        CSDLD_EN_OUT_2_IGNORE = 0,
        CSDLD_EN_OUT_2_ASYNC = 1
    };
    csdld_en_out_2_t csdld_en_out_2;
    enum csdld_en_out_1_t{
        CSDLD_EN_OUT_1_IGNORE = 0,
        CSDLD_EN_OUT_1_ASYNC = 1
    };
    csdld_en_out_1_t csdld_en_out_1;
    enum csdld_en_out_0_t{
        CSDLD_EN_OUT_0_IGNORE = 0,
        CSDLD_EN_OUT_0_ASYNC = 1
    };
    csdld_en_out_0_t csdld_en_out_0;
    enum csdld_en_out_11_t{
        CSDLD_EN_OUT_11_IGNORE = 0,
        CSDLD_EN_OUT_11_ASYNC = 1
    };
    csdld_en_out_11_t csdld_en_out_11;
    enum csdld_en_out_10_t{
        CSDLD_EN_OUT_10_IGNORE = 0,
        CSDLD_EN_OUT_10_ASYNC = 1
    };
    csdld_en_out_10_t csdld_en_out_10;
    enum csdld_en_out_9_t{
        CSDLD_EN_OUT_9_IGNORE = 0,
        CSDLD_EN_OUT_9_ASYNC = 1
    };
    csdld_en_out_9_t csdld_en_out_9;
    enum csdld_en_out_8_t{
        CSDLD_EN_OUT_8_IGNORE = 0,
        CSDLD_EN_OUT_8_ASYNC = 1
    };
    csdld_en_out_8_t csdld_en_out_8;
    boost::uint8_t divider0_low_cycles;
    boost::uint8_t divider0_high_cycles;
    boost::uint8_t divider0_bypass;
    boost::uint8_t divider0_ignore_sync;
    boost::uint8_t divider0_force_high;
    boost::uint8_t divider0_start_high;
    boost::uint8_t divider0_phase_offset;
    boost::uint8_t channel0_power_down;
    boost::uint8_t disable_divider0_ddc;
    boost::uint8_t divider1_low_cycles;
    boost::uint8_t divider1_high_cycles;
    boost::uint8_t divider1_bypass;
    boost::uint8_t divider1_ignore_sync;
    boost::uint8_t divider1_force_high;
    boost::uint8_t divider1_start_high;
    boost::uint8_t divider1_phase_offset;
    boost::uint8_t channel1_power_down;
    boost::uint8_t disable_divider1_ddc;
    boost::uint8_t divider2_low_cycles;
    boost::uint8_t divider2_high_cycles;
    boost::uint8_t divider2_bypass;
    boost::uint8_t divider2_ignore_sync;
    boost::uint8_t divider2_force_high;
    boost::uint8_t divider2_start_high;
    boost::uint8_t divider2_phase_offset;
    boost::uint8_t channel2_power_down;
    boost::uint8_t disable_divider2_ddc;
    boost::uint8_t divider3_low_cycles;
    boost::uint8_t divider3_high_cycles;
    boost::uint8_t divider3_bypass;
    boost::uint8_t divider3_ignore_sync;
    boost::uint8_t divider3_force_high;
    boost::uint8_t divider3_start_high;
    boost::uint8_t divider3_phase_offset;
    boost::uint8_t channel3_power_down;
    boost::uint8_t disable_divider3_ddc;
    enum vco_divider_t{
        VCO_DIVIDER_DIV2 = 0,
        VCO_DIVIDER_DIV3 = 1,
        VCO_DIVIDER_DIV4 = 2,
        VCO_DIVIDER_DIV5 = 3,
        VCO_DIVIDER_DIV6 = 4,
        VCO_DIVIDER_STATIC = 5,
        VCO_DIVIDER_DIV1 = 6
    };
    vco_divider_t vco_divider;
    boost::uint8_t power_down_clock_input_sel;
    boost::uint8_t power_down_vco_clock_ifc;
    boost::uint8_t power_down_vco_and_clock;
    enum select_vco_or_clock_t{
        SELECT_VCO_OR_CLOCK_EXTERNAL = 0,
        SELECT_VCO_OR_CLOCK_VCO = 1
    };
    select_vco_or_clock_t select_vco_or_clock;
    boost::uint8_t bypass_vco_divider;
    boost::uint8_t disable_power_on_sync;
    boost::uint8_t power_down_sync;
    boost::uint8_t power_down_dist_ref;
    boost::uint8_t soft_sync;
    boost::uint8_t io_update;
    boost::uint8_t soft_eeprom;
    boost::uint8_t enable_eeprom_write;
    boost::uint8_t reg2eeprom;

    ad9522_regs_t(void){
        _state = NULL;
        sdo_active = SDO_ACTIVE_SDIO;
        lsb_first_addr_incr = LSB_FIRST_ADDR_INCR_MSB;
        soft_reset = 0;
        mirror = 0;
        readback_active_registers = READBACK_ACTIVE_REGISTERS_BUFFER;
        pfd_polarity = PFD_POLARITY_POS;
        cp_current = CP_CURRENT_4_8MA;
        cp_mode = CP_MODE_NORMAL;
        pll_power_down = PLL_POWER_DOWN_ASYNC;
        r_counter_lsb = 1;
        r_counter_msb = 0;
        a_counter = 0;
        b_counter_lsb = 3;
        b_counter_msb = 0;
        set_cp_pin_to_vcp_2 = SET_CP_PIN_TO_VCP_2_NORMAL;
        reset_r_counter = 0;
        reset_a_and_b_counters = 0;
        reset_all_counters = 0;
        b_counter_bypass = B_COUNTER_BYPASS_NORMAL;
        prescaler_p = PRESCALER_P_DIV32_33;
        status_pin_control = 0;
        antibacklash_pulse_width = ANTIBACKLASH_PULSE_WIDTH_2_9NS;
        enb_cmos_ref_input_dc_off = 0;
        lock_detect_counter = LOCK_DETECT_COUNTER_5CYC;
        digital_lock_detect_window = DIGITAL_LOCK_DETECT_WINDOW_HIGH_RANGE;
        disable_digital_lock_detect = DISABLE_DIGITAL_LOCK_DETECT_NORMAL;
        vco_calibration_divider = VCO_CALIBRATION_DIVIDER_DIV16;
        vco_calibration_now = 0;
        r_a_b_counters_sync_pin_rst = R_A_B_COUNTERS_SYNC_PIN_RST_NOTHING;
        r_path_delay = 0;
        n_path_delay = 0;
        enable_status_pin_divider = 0;
        ref_freq_monitor_threshold = REF_FREQ_MONITOR_THRESHOLD_1_02MHZ;
        ld_pin_control = 0;
        enable_vco_freq_monitor = 0;
        enable_ref2_freq_monitor = 0;
        enable_ref1_freq_monitor = 0;
        refmon_pin_control = 0;
        disable_switchover_deglitch = 0;
        select_ref = SELECT_REF_REF1;
        use_ref_sel_pin = USE_REF_SEL_PIN_REGISTER;
        enb_auto_ref_switchover = ENB_AUTO_REF_SWITCHOVER_MANUAL;
        stay_on_ref2 = STAY_ON_REF2_RETURN_REF1;
        enable_ref2 = 0;
        enable_ref1 = 0;
        enable_differential_ref = 0;
        enb_stat_eeprom_at_stat_pin = 1;
        enable_xtal_osc = 0;
        enable_clock_doubler = 0;
        disable_pll_status_reg = 0;
        enable_ld_pin_comparator = 0;
        enable_external_holdover = 0;
        enable_holdover = 0;
        external_zero_delay_fcds = 0;
        enable_external_zero_delay = 0;
        enable_zero_delay = 0;
        vco_calibration_finished = 0;
        holdover_active = 0;
        ref2_selected = 0;
        vco_freq_gt_thresh = 0;
        ref2_freq_gt_thresh = 0;
        ref1_freq_gt_thresh = 0;
        digital_lock_detect = 0;
        out0_format = OUT0_FORMAT_LVDS;
        out0_cmos_configuration = OUT0_CMOS_CONFIGURATION_AB_ON;
        out0_polarity = OUT0_POLARITY_LVDS_A_NON_B_INV;
        out0_lvds_diff_voltage = OUT0_LVDS_DIFF_VOLTAGE_3_5MA;
        out0_lvds_power_down = 0;
        out1_format = OUT1_FORMAT_LVDS;
        out1_cmos_configuration = OUT1_CMOS_CONFIGURATION_AB_ON;
        out1_polarity = OUT1_POLARITY_LVDS_A_NON_B_INV;
        out1_lvds_diff_voltage = OUT1_LVDS_DIFF_VOLTAGE_3_5MA;
        out1_lvds_power_down = 0;
        out2_format = OUT2_FORMAT_LVDS;
        out2_cmos_configuration = OUT2_CMOS_CONFIGURATION_AB_ON;
        out2_polarity = OUT2_POLARITY_LVDS_A_NON_B_INV;
        out2_lvds_diff_voltage = OUT2_LVDS_DIFF_VOLTAGE_3_5MA;
        out2_lvds_power_down = 0;
        out3_format = OUT3_FORMAT_LVDS;
        out3_cmos_configuration = OUT3_CMOS_CONFIGURATION_AB_ON;
        out3_polarity = OUT3_POLARITY_LVDS_A_NON_B_INV;
        out3_lvds_diff_voltage = OUT3_LVDS_DIFF_VOLTAGE_3_5MA;
        out3_lvds_power_down = 0;
        out4_format = OUT4_FORMAT_LVDS;
        out4_cmos_configuration = OUT4_CMOS_CONFIGURATION_AB_ON;
        out4_polarity = OUT4_POLARITY_LVDS_A_NON_B_INV;
        out4_lvds_diff_voltage = OUT4_LVDS_DIFF_VOLTAGE_3_5MA;
        out4_lvds_power_down = 0;
        out5_format = OUT5_FORMAT_LVDS;
        out5_cmos_configuration = OUT5_CMOS_CONFIGURATION_AB_ON;
        out5_polarity = OUT5_POLARITY_LVDS_A_NON_B_INV;
        out5_lvds_diff_voltage = OUT5_LVDS_DIFF_VOLTAGE_3_5MA;
        out5_lvds_power_down = 0;
        out6_format = OUT6_FORMAT_LVDS;
        out6_cmos_configuration = OUT6_CMOS_CONFIGURATION_AB_ON;
        out6_polarity = OUT6_POLARITY_LVDS_A_NON_B_INV;
        out6_lvds_diff_voltage = OUT6_LVDS_DIFF_VOLTAGE_3_5MA;
        out6_lvds_power_down = 0;
        out7_format = OUT7_FORMAT_LVDS;
        out7_cmos_configuration = OUT7_CMOS_CONFIGURATION_AB_ON;
        out7_polarity = OUT7_POLARITY_LVDS_A_NON_B_INV;
        out7_lvds_diff_voltage = OUT7_LVDS_DIFF_VOLTAGE_3_5MA;
        out7_lvds_power_down = 0;
        out8_format = OUT8_FORMAT_LVDS;
        out8_cmos_configuration = OUT8_CMOS_CONFIGURATION_AB_ON;
        out8_polarity = OUT8_POLARITY_LVDS_A_NON_B_INV;
        out8_lvds_diff_voltage = OUT8_LVDS_DIFF_VOLTAGE_3_5MA;
        out8_lvds_power_down = 0;
        out9_format = OUT9_FORMAT_LVDS;
        out9_cmos_configuration = OUT9_CMOS_CONFIGURATION_AB_ON;
        out9_polarity = OUT9_POLARITY_LVDS_A_NON_B_INV;
        out9_lvds_diff_voltage = OUT9_LVDS_DIFF_VOLTAGE_3_5MA;
        out9_lvds_power_down = 0;
        out10_format = OUT10_FORMAT_LVDS;
        out10_cmos_configuration = OUT10_CMOS_CONFIGURATION_AB_ON;
        out10_polarity = OUT10_POLARITY_LVDS_A_NON_B_INV;
        out10_lvds_diff_voltage = OUT10_LVDS_DIFF_VOLTAGE_3_5MA;
        out10_lvds_power_down = 0;
        out11_format = OUT11_FORMAT_LVDS;
        out11_cmos_configuration = OUT11_CMOS_CONFIGURATION_AB_ON;
        out11_polarity = OUT11_POLARITY_LVDS_A_NON_B_INV;
        out11_lvds_diff_voltage = OUT11_LVDS_DIFF_VOLTAGE_3_5MA;
        out11_lvds_power_down = 0;
        csdld_en_out_7 = CSDLD_EN_OUT_7_IGNORE;
        csdld_en_out_6 = CSDLD_EN_OUT_6_IGNORE;
        csdld_en_out_5 = CSDLD_EN_OUT_5_IGNORE;
        csdld_en_out_4 = CSDLD_EN_OUT_4_IGNORE;
        csdld_en_out_3 = CSDLD_EN_OUT_3_IGNORE;
        csdld_en_out_2 = CSDLD_EN_OUT_2_IGNORE;
        csdld_en_out_1 = CSDLD_EN_OUT_1_IGNORE;
        csdld_en_out_0 = CSDLD_EN_OUT_0_IGNORE;
        csdld_en_out_11 = CSDLD_EN_OUT_11_IGNORE;
        csdld_en_out_10 = CSDLD_EN_OUT_10_IGNORE;
        csdld_en_out_9 = CSDLD_EN_OUT_9_IGNORE;
        csdld_en_out_8 = CSDLD_EN_OUT_8_IGNORE;
        divider0_low_cycles = 7;
        divider0_high_cycles = 7;
        divider0_bypass = 0;
        divider0_ignore_sync = 0;
        divider0_force_high = 0;
        divider0_start_high = 0;
        divider0_phase_offset = 0;
        channel0_power_down = 0;
        disable_divider0_ddc = 0;
        divider1_low_cycles = 3;
        divider1_high_cycles = 3;
        divider1_bypass = 0;
        divider1_ignore_sync = 0;
        divider1_force_high = 0;
        divider1_start_high = 0;
        divider1_phase_offset = 0;
        channel1_power_down = 0;
        disable_divider1_ddc = 0;
        divider2_low_cycles = 1;
        divider2_high_cycles = 1;
        divider2_bypass = 0;
        divider2_ignore_sync = 0;
        divider2_force_high = 0;
        divider2_start_high = 0;
        divider2_phase_offset = 0;
        channel2_power_down = 0;
        disable_divider2_ddc = 0;
        divider3_low_cycles = 0;
        divider3_high_cycles = 0;
        divider3_bypass = 0;
        divider3_ignore_sync = 0;
        divider3_force_high = 0;
        divider3_start_high = 0;
        divider3_phase_offset = 0;
        channel3_power_down = 0;
        disable_divider3_ddc = 0;
        vco_divider = VCO_DIVIDER_DIV4;
        power_down_clock_input_sel = 0;
        power_down_vco_clock_ifc = 0;
        power_down_vco_and_clock = 0;
        select_vco_or_clock = SELECT_VCO_OR_CLOCK_EXTERNAL;
        bypass_vco_divider = 0;
        disable_power_on_sync = 0;
        power_down_sync = 0;
        power_down_dist_ref = 0;
        soft_sync = 0;
        io_update = 0;
        soft_eeprom = 0;
        enable_eeprom_write = 0;
        reg2eeprom = 0;
    }

    ~ad9522_regs_t(void){
        delete _state;
    }

    boost::uint32_t get_reg(boost::uint16_t addr){
        boost::uint32_t reg = 0;
        switch(addr){
        case 0:
            reg |= (boost::uint8_t(sdo_active) & 0x1) << 7;
            reg |= (boost::uint8_t(lsb_first_addr_incr) & 0x1) << 6;
            reg |= (boost::uint8_t(soft_reset) & 0x1) << 5;
            reg |= (boost::uint8_t(mirror) & 0xf) << 0;
            break;
        case 4:
            reg |= (boost::uint8_t(readback_active_registers) & 0x1) << 0;
            break;
        case 16:
            reg |= (boost::uint8_t(pfd_polarity) & 0x1) << 7;
            reg |= (boost::uint8_t(cp_current) & 0x7) << 4;
            reg |= (boost::uint8_t(cp_mode) & 0x3) << 2;
            reg |= (boost::uint8_t(pll_power_down) & 0x3) << 0;
            break;
        case 17:
            reg |= (boost::uint8_t(r_counter_lsb) & 0xff) << 0;
            break;
        case 18:
            reg |= (boost::uint8_t(r_counter_msb) & 0x3f) << 0;
            break;
        case 19:
            reg |= (boost::uint8_t(a_counter) & 0x3f) << 0;
            break;
        case 20:
            reg |= (boost::uint8_t(b_counter_lsb) & 0xff) << 0;
            break;
        case 21:
            reg |= (boost::uint8_t(b_counter_msb) & 0x1f) << 0;
            break;
        case 22:
            reg |= (boost::uint8_t(set_cp_pin_to_vcp_2) & 0x1) << 7;
            reg |= (boost::uint8_t(reset_r_counter) & 0x1) << 6;
            reg |= (boost::uint8_t(reset_a_and_b_counters) & 0x1) << 5;
            reg |= (boost::uint8_t(reset_all_counters) & 0x1) << 4;
            reg |= (boost::uint8_t(b_counter_bypass) & 0x1) << 3;
            reg |= (boost::uint8_t(prescaler_p) & 0x7) << 0;
            break;
        case 23:
            reg |= (boost::uint8_t(status_pin_control) & 0x3f) << 2;
            reg |= (boost::uint8_t(antibacklash_pulse_width) & 0x3) << 0;
            break;
        case 24:
            reg |= (boost::uint8_t(enb_cmos_ref_input_dc_off) & 0x1) << 7;
            reg |= (boost::uint8_t(lock_detect_counter) & 0x3) << 5;
            reg |= (boost::uint8_t(digital_lock_detect_window) & 0x1) << 4;
            reg |= (boost::uint8_t(disable_digital_lock_detect) & 0x1) << 3;
            reg |= (boost::uint8_t(vco_calibration_divider) & 0x3) << 1;
            reg |= (boost::uint8_t(vco_calibration_now) & 0x1) << 0;
            break;
        case 25:
            reg |= (boost::uint8_t(r_a_b_counters_sync_pin_rst) & 0x3) << 6;
            reg |= (boost::uint8_t(r_path_delay) & 0x7) << 3;
            reg |= (boost::uint8_t(n_path_delay) & 0x7) << 0;
            break;
        case 26:
            reg |= (boost::uint8_t(enable_status_pin_divider) & 0x1) << 7;
            reg |= (boost::uint8_t(ref_freq_monitor_threshold) & 0x1) << 6;
            reg |= (boost::uint8_t(ld_pin_control) & 0x3f) << 0;
            break;
        case 27:
            reg |= (boost::uint8_t(enable_vco_freq_monitor) & 0x1) << 7;
            reg |= (boost::uint8_t(enable_ref2_freq_monitor) & 0x1) << 6;
            reg |= (boost::uint8_t(enable_ref1_freq_monitor) & 0x1) << 5;
            reg |= (boost::uint8_t(refmon_pin_control) & 0x1f) << 0;
            break;
        case 28:
            reg |= (boost::uint8_t(disable_switchover_deglitch) & 0x1) << 7;
            reg |= (boost::uint8_t(select_ref) & 0x1) << 6;
            reg |= (boost::uint8_t(use_ref_sel_pin) & 0x1) << 5;
            reg |= (boost::uint8_t(enb_auto_ref_switchover) & 0x1) << 4;
            reg |= (boost::uint8_t(stay_on_ref2) & 0x1) << 3;
            reg |= (boost::uint8_t(enable_ref2) & 0x1) << 2;
            reg |= (boost::uint8_t(enable_ref1) & 0x1) << 1;
            reg |= (boost::uint8_t(enable_differential_ref) & 0x1) << 0;
            break;
        case 29:
            reg |= (boost::uint8_t(enb_stat_eeprom_at_stat_pin) & 0x1) << 7;
            reg |= (boost::uint8_t(enable_xtal_osc) & 0x1) << 6;
            reg |= (boost::uint8_t(enable_clock_doubler) & 0x1) << 5;
            reg |= (boost::uint8_t(disable_pll_status_reg) & 0x1) << 4;
            reg |= (boost::uint8_t(enable_ld_pin_comparator) & 0x1) << 3;
            reg |= (boost::uint8_t(enable_external_holdover) & 0x1) << 1;
            reg |= (boost::uint8_t(enable_holdover) & 0x1) << 0;
            break;
        case 30:
            reg |= (boost::uint8_t(external_zero_delay_fcds) & 0x3) << 3;
            reg |= (boost::uint8_t(enable_external_zero_delay) & 0x1) << 2;
            reg |= (boost::uint8_t(enable_zero_delay) & 0x1) << 1;
            break;
        case 31:
            reg |= (boost::uint8_t(vco_calibration_finished) & 0x1) << 6;
            reg |= (boost::uint8_t(holdover_active) & 0x1) << 5;
            reg |= (boost::uint8_t(ref2_selected) & 0x1) << 4;
            reg |= (boost::uint8_t(vco_freq_gt_thresh) & 0x1) << 3;
            reg |= (boost::uint8_t(ref2_freq_gt_thresh) & 0x1) << 2;
            reg |= (boost::uint8_t(ref1_freq_gt_thresh) & 0x1) << 1;
            reg |= (boost::uint8_t(digital_lock_detect) & 0x1) << 0;
            break;
        case 240:
            reg |= (boost::uint8_t(out0_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out0_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out0_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out0_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out0_lvds_power_down) & 0x1) << 0;
            break;
        case 241:
            reg |= (boost::uint8_t(out1_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out1_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out1_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out1_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out1_lvds_power_down) & 0x1) << 0;
            break;
        case 242:
            reg |= (boost::uint8_t(out2_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out2_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out2_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out2_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out2_lvds_power_down) & 0x1) << 0;
            break;
        case 243:
            reg |= (boost::uint8_t(out3_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out3_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out3_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out3_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out3_lvds_power_down) & 0x1) << 0;
            break;
        case 244:
            reg |= (boost::uint8_t(out4_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out4_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out4_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out4_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out4_lvds_power_down) & 0x1) << 0;
            break;
        case 245:
            reg |= (boost::uint8_t(out5_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out5_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out5_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out5_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out5_lvds_power_down) & 0x1) << 0;
            break;
        case 246:
            reg |= (boost::uint8_t(out6_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out6_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out6_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out6_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out6_lvds_power_down) & 0x1) << 0;
            break;
        case 247:
            reg |= (boost::uint8_t(out7_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out7_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out7_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out7_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out7_lvds_power_down) & 0x1) << 0;
            break;
        case 248:
            reg |= (boost::uint8_t(out8_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out8_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out8_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out8_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out8_lvds_power_down) & 0x1) << 0;
            break;
        case 249:
            reg |= (boost::uint8_t(out9_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out9_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out9_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out9_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out9_lvds_power_down) & 0x1) << 0;
            break;
        case 250:
            reg |= (boost::uint8_t(out10_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out10_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out10_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out10_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out10_lvds_power_down) & 0x1) << 0;
            break;
        case 251:
            reg |= (boost::uint8_t(out11_format) & 0x1) << 7;
            reg |= (boost::uint8_t(out11_cmos_configuration) & 0x3) << 5;
            reg |= (boost::uint8_t(out11_polarity) & 0x3) << 3;
            reg |= (boost::uint8_t(out11_lvds_diff_voltage) & 0x3) << 1;
            reg |= (boost::uint8_t(out11_lvds_power_down) & 0x1) << 0;
            break;
        case 252:
            reg |= (boost::uint8_t(csdld_en_out_7) & 0x1) << 7;
            reg |= (boost::uint8_t(csdld_en_out_6) & 0x1) << 6;
            reg |= (boost::uint8_t(csdld_en_out_5) & 0x1) << 5;
            reg |= (boost::uint8_t(csdld_en_out_4) & 0x1) << 4;
            reg |= (boost::uint8_t(csdld_en_out_3) & 0x1) << 3;
            reg |= (boost::uint8_t(csdld_en_out_2) & 0x1) << 2;
            reg |= (boost::uint8_t(csdld_en_out_1) & 0x1) << 1;
            reg |= (boost::uint8_t(csdld_en_out_0) & 0x1) << 0;
            break;
        case 253:
            reg |= (boost::uint8_t(csdld_en_out_11) & 0x1) << 3;
            reg |= (boost::uint8_t(csdld_en_out_10) & 0x1) << 2;
            reg |= (boost::uint8_t(csdld_en_out_9) & 0x1) << 1;
            reg |= (boost::uint8_t(csdld_en_out_8) & 0x1) << 0;
            break;
        case 400:
            reg |= (boost::uint8_t(divider0_low_cycles) & 0xf) << 4;
            reg |= (boost::uint8_t(divider0_high_cycles) & 0xf) << 0;
            break;
        case 401:
            reg |= (boost::uint8_t(divider0_bypass) & 0x1) << 7;
            reg |= (boost::uint8_t(divider0_ignore_sync) & 0x1) << 6;
            reg |= (boost::uint8_t(divider0_force_high) & 0x1) << 5;
            reg |= (boost::uint8_t(divider0_start_high) & 0x1) << 4;
            reg |= (boost::uint8_t(divider0_phase_offset) & 0xf) << 0;
            break;
        case 402:
            reg |= (boost::uint8_t(channel0_power_down) & 0x1) << 2;
            reg |= (boost::uint8_t(disable_divider0_ddc) & 0x1) << 0;
            break;
        case 403:
            reg |= (boost::uint8_t(divider1_low_cycles) & 0xf) << 4;
            reg |= (boost::uint8_t(divider1_high_cycles) & 0xf) << 0;
            break;
        case 404:
            reg |= (boost::uint8_t(divider1_bypass) & 0x1) << 7;
            reg |= (boost::uint8_t(divider1_ignore_sync) & 0x1) << 6;
            reg |= (boost::uint8_t(divider1_force_high) & 0x1) << 5;
            reg |= (boost::uint8_t(divider1_start_high) & 0x1) << 4;
            reg |= (boost::uint8_t(divider1_phase_offset) & 0xf) << 0;
            break;
        case 405:
            reg |= (boost::uint8_t(channel1_power_down) & 0x1) << 2;
            reg |= (boost::uint8_t(disable_divider1_ddc) & 0x1) << 0;
            break;
        case 406:
            reg |= (boost::uint8_t(divider2_low_cycles) & 0xf) << 4;
            reg |= (boost::uint8_t(divider2_high_cycles) & 0xf) << 0;
            break;
        case 407:
            reg |= (boost::uint8_t(divider2_bypass) & 0x1) << 7;
            reg |= (boost::uint8_t(divider2_ignore_sync) & 0x1) << 6;
            reg |= (boost::uint8_t(divider2_force_high) & 0x1) << 5;
            reg |= (boost::uint8_t(divider2_start_high) & 0x1) << 4;
            reg |= (boost::uint8_t(divider2_phase_offset) & 0xf) << 0;
            break;
        case 408:
            reg |= (boost::uint8_t(channel2_power_down) & 0x1) << 2;
            reg |= (boost::uint8_t(disable_divider2_ddc) & 0x1) << 0;
            break;
        case 409:
            reg |= (boost::uint8_t(divider3_low_cycles) & 0xf) << 4;
            reg |= (boost::uint8_t(divider3_high_cycles) & 0xf) << 0;
            break;
        case 410:
            reg |= (boost::uint8_t(divider3_bypass) & 0x1) << 7;
            reg |= (boost::uint8_t(divider3_ignore_sync) & 0x1) << 6;
            reg |= (boost::uint8_t(divider3_force_high) & 0x1) << 5;
            reg |= (boost::uint8_t(divider3_start_high) & 0x1) << 4;
            reg |= (boost::uint8_t(divider3_phase_offset) & 0xf) << 0;
            break;
        case 411:
            reg |= (boost::uint8_t(channel3_power_down) & 0x1) << 2;
            reg |= (boost::uint8_t(disable_divider3_ddc) & 0x1) << 0;
            break;
        case 480:
            reg |= (boost::uint8_t(vco_divider) & 0x7) << 0;
            break;
        case 481:
            reg |= (boost::uint8_t(power_down_clock_input_sel) & 0x1) << 4;
            reg |= (boost::uint8_t(power_down_vco_clock_ifc) & 0x1) << 3;
            reg |= (boost::uint8_t(power_down_vco_and_clock) & 0x1) << 2;
            reg |= (boost::uint8_t(select_vco_or_clock) & 0x1) << 1;
            reg |= (boost::uint8_t(bypass_vco_divider) & 0x1) << 0;
            break;
        case 560:
            reg |= (boost::uint8_t(disable_power_on_sync) & 0x1) << 3;
            reg |= (boost::uint8_t(power_down_sync) & 0x1) << 2;
            reg |= (boost::uint8_t(power_down_dist_ref) & 0x1) << 1;
            reg |= (boost::uint8_t(soft_sync) & 0x1) << 0;
            break;
        case 562:
            reg |= (boost::uint8_t(io_update) & 0x1) << 0;
            break;
        case 2818:
            reg |= (boost::uint8_t(soft_eeprom) & 0x1) << 1;
            reg |= (boost::uint8_t(enable_eeprom_write) & 0x1) << 0;
            break;
        case 2819:
            reg |= (boost::uint8_t(reg2eeprom) & 0x1) << 0;
            break;
        }
        if (addr == 0){ //mirror 4 bits in register 0
            reg |= ((reg >> 7) & 0x1) << 0;
            reg |= ((reg >> 6) & 0x1) << 1;
            reg |= ((reg >> 5) & 0x1) << 2;
            reg |= ((reg >> 4) & 0x1) << 3;
        }
        return reg;
    }
    
    void set_reg(boost::uint16_t addr, boost::uint32_t reg){
        switch(addr){
        case 0:
            sdo_active = sdo_active_t((reg >> 7) & 0x1);
            lsb_first_addr_incr = lsb_first_addr_incr_t((reg >> 6) & 0x1);
            soft_reset = boost::uint8_t((reg >> 5) & 0x1);
            mirror = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 4:
            readback_active_registers = readback_active_registers_t((reg >> 0) & 0x1);
            break;
        case 16:
            pfd_polarity = pfd_polarity_t((reg >> 7) & 0x1);
            cp_current = cp_current_t((reg >> 4) & 0x7);
            cp_mode = cp_mode_t((reg >> 2) & 0x3);
            pll_power_down = pll_power_down_t((reg >> 0) & 0x3);
            break;
        case 17:
            r_counter_lsb = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 18:
            r_counter_msb = boost::uint8_t((reg >> 0) & 0x3f);
            break;
        case 19:
            a_counter = boost::uint8_t((reg >> 0) & 0x3f);
            break;
        case 20:
            b_counter_lsb = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 21:
            b_counter_msb = boost::uint8_t((reg >> 0) & 0x1f);
            break;
        case 22:
            set_cp_pin_to_vcp_2 = set_cp_pin_to_vcp_2_t((reg >> 7) & 0x1);
            reset_r_counter = boost::uint8_t((reg >> 6) & 0x1);
            reset_a_and_b_counters = boost::uint8_t((reg >> 5) & 0x1);
            reset_all_counters = boost::uint8_t((reg >> 4) & 0x1);
            b_counter_bypass = b_counter_bypass_t((reg >> 3) & 0x1);
            prescaler_p = prescaler_p_t((reg >> 0) & 0x7);
            break;
        case 23:
            status_pin_control = boost::uint8_t((reg >> 2) & 0x3f);
            antibacklash_pulse_width = antibacklash_pulse_width_t((reg >> 0) & 0x3);
            break;
        case 24:
            enb_cmos_ref_input_dc_off = boost::uint8_t((reg >> 7) & 0x1);
            lock_detect_counter = lock_detect_counter_t((reg >> 5) & 0x3);
            digital_lock_detect_window = digital_lock_detect_window_t((reg >> 4) & 0x1);
            disable_digital_lock_detect = disable_digital_lock_detect_t((reg >> 3) & 0x1);
            vco_calibration_divider = vco_calibration_divider_t((reg >> 1) & 0x3);
            vco_calibration_now = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 25:
            r_a_b_counters_sync_pin_rst = r_a_b_counters_sync_pin_rst_t((reg >> 6) & 0x3);
            r_path_delay = boost::uint8_t((reg >> 3) & 0x7);
            n_path_delay = boost::uint8_t((reg >> 0) & 0x7);
            break;
        case 26:
            enable_status_pin_divider = boost::uint8_t((reg >> 7) & 0x1);
            ref_freq_monitor_threshold = ref_freq_monitor_threshold_t((reg >> 6) & 0x1);
            ld_pin_control = boost::uint8_t((reg >> 0) & 0x3f);
            break;
        case 27:
            enable_vco_freq_monitor = boost::uint8_t((reg >> 7) & 0x1);
            enable_ref2_freq_monitor = boost::uint8_t((reg >> 6) & 0x1);
            enable_ref1_freq_monitor = boost::uint8_t((reg >> 5) & 0x1);
            refmon_pin_control = boost::uint8_t((reg >> 0) & 0x1f);
            break;
        case 28:
            disable_switchover_deglitch = boost::uint8_t((reg >> 7) & 0x1);
            select_ref = select_ref_t((reg >> 6) & 0x1);
            use_ref_sel_pin = use_ref_sel_pin_t((reg >> 5) & 0x1);
            enb_auto_ref_switchover = enb_auto_ref_switchover_t((reg >> 4) & 0x1);
            stay_on_ref2 = stay_on_ref2_t((reg >> 3) & 0x1);
            enable_ref2 = boost::uint8_t((reg >> 2) & 0x1);
            enable_ref1 = boost::uint8_t((reg >> 1) & 0x1);
            enable_differential_ref = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 29:
            enb_stat_eeprom_at_stat_pin = boost::uint8_t((reg >> 7) & 0x1);
            enable_xtal_osc = boost::uint8_t((reg >> 6) & 0x1);
            enable_clock_doubler = boost::uint8_t((reg >> 5) & 0x1);
            disable_pll_status_reg = boost::uint8_t((reg >> 4) & 0x1);
            enable_ld_pin_comparator = boost::uint8_t((reg >> 3) & 0x1);
            enable_external_holdover = boost::uint8_t((reg >> 1) & 0x1);
            enable_holdover = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 30:
            external_zero_delay_fcds = boost::uint8_t((reg >> 3) & 0x3);
            enable_external_zero_delay = boost::uint8_t((reg >> 2) & 0x1);
            enable_zero_delay = boost::uint8_t((reg >> 1) & 0x1);
            break;
        case 31:
            vco_calibration_finished = boost::uint8_t((reg >> 6) & 0x1);
            holdover_active = boost::uint8_t((reg >> 5) & 0x1);
            ref2_selected = boost::uint8_t((reg >> 4) & 0x1);
            vco_freq_gt_thresh = boost::uint8_t((reg >> 3) & 0x1);
            ref2_freq_gt_thresh = boost::uint8_t((reg >> 2) & 0x1);
            ref1_freq_gt_thresh = boost::uint8_t((reg >> 1) & 0x1);
            digital_lock_detect = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 240:
            out0_format = out0_format_t((reg >> 7) & 0x1);
            out0_cmos_configuration = out0_cmos_configuration_t((reg >> 5) & 0x3);
            out0_polarity = out0_polarity_t((reg >> 3) & 0x3);
            out0_lvds_diff_voltage = out0_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out0_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 241:
            out1_format = out1_format_t((reg >> 7) & 0x1);
            out1_cmos_configuration = out1_cmos_configuration_t((reg >> 5) & 0x3);
            out1_polarity = out1_polarity_t((reg >> 3) & 0x3);
            out1_lvds_diff_voltage = out1_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out1_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 242:
            out2_format = out2_format_t((reg >> 7) & 0x1);
            out2_cmos_configuration = out2_cmos_configuration_t((reg >> 5) & 0x3);
            out2_polarity = out2_polarity_t((reg >> 3) & 0x3);
            out2_lvds_diff_voltage = out2_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out2_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 243:
            out3_format = out3_format_t((reg >> 7) & 0x1);
            out3_cmos_configuration = out3_cmos_configuration_t((reg >> 5) & 0x3);
            out3_polarity = out3_polarity_t((reg >> 3) & 0x3);
            out3_lvds_diff_voltage = out3_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out3_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 244:
            out4_format = out4_format_t((reg >> 7) & 0x1);
            out4_cmos_configuration = out4_cmos_configuration_t((reg >> 5) & 0x3);
            out4_polarity = out4_polarity_t((reg >> 3) & 0x3);
            out4_lvds_diff_voltage = out4_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out4_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 245:
            out5_format = out5_format_t((reg >> 7) & 0x1);
            out5_cmos_configuration = out5_cmos_configuration_t((reg >> 5) & 0x3);
            out5_polarity = out5_polarity_t((reg >> 3) & 0x3);
            out5_lvds_diff_voltage = out5_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out5_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 246:
            out6_format = out6_format_t((reg >> 7) & 0x1);
            out6_cmos_configuration = out6_cmos_configuration_t((reg >> 5) & 0x3);
            out6_polarity = out6_polarity_t((reg >> 3) & 0x3);
            out6_lvds_diff_voltage = out6_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out6_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 247:
            out7_format = out7_format_t((reg >> 7) & 0x1);
            out7_cmos_configuration = out7_cmos_configuration_t((reg >> 5) & 0x3);
            out7_polarity = out7_polarity_t((reg >> 3) & 0x3);
            out7_lvds_diff_voltage = out7_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out7_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 248:
            out8_format = out8_format_t((reg >> 7) & 0x1);
            out8_cmos_configuration = out8_cmos_configuration_t((reg >> 5) & 0x3);
            out8_polarity = out8_polarity_t((reg >> 3) & 0x3);
            out8_lvds_diff_voltage = out8_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out8_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 249:
            out9_format = out9_format_t((reg >> 7) & 0x1);
            out9_cmos_configuration = out9_cmos_configuration_t((reg >> 5) & 0x3);
            out9_polarity = out9_polarity_t((reg >> 3) & 0x3);
            out9_lvds_diff_voltage = out9_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out9_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 250:
            out10_format = out10_format_t((reg >> 7) & 0x1);
            out10_cmos_configuration = out10_cmos_configuration_t((reg >> 5) & 0x3);
            out10_polarity = out10_polarity_t((reg >> 3) & 0x3);
            out10_lvds_diff_voltage = out10_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out10_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 251:
            out11_format = out11_format_t((reg >> 7) & 0x1);
            out11_cmos_configuration = out11_cmos_configuration_t((reg >> 5) & 0x3);
            out11_polarity = out11_polarity_t((reg >> 3) & 0x3);
            out11_lvds_diff_voltage = out11_lvds_diff_voltage_t((reg >> 1) & 0x3);
            out11_lvds_power_down = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 252:
            csdld_en_out_7 = csdld_en_out_7_t((reg >> 7) & 0x1);
            csdld_en_out_6 = csdld_en_out_6_t((reg >> 6) & 0x1);
            csdld_en_out_5 = csdld_en_out_5_t((reg >> 5) & 0x1);
            csdld_en_out_4 = csdld_en_out_4_t((reg >> 4) & 0x1);
            csdld_en_out_3 = csdld_en_out_3_t((reg >> 3) & 0x1);
            csdld_en_out_2 = csdld_en_out_2_t((reg >> 2) & 0x1);
            csdld_en_out_1 = csdld_en_out_1_t((reg >> 1) & 0x1);
            csdld_en_out_0 = csdld_en_out_0_t((reg >> 0) & 0x1);
            break;
        case 253:
            csdld_en_out_11 = csdld_en_out_11_t((reg >> 3) & 0x1);
            csdld_en_out_10 = csdld_en_out_10_t((reg >> 2) & 0x1);
            csdld_en_out_9 = csdld_en_out_9_t((reg >> 1) & 0x1);
            csdld_en_out_8 = csdld_en_out_8_t((reg >> 0) & 0x1);
            break;
        case 400:
            divider0_low_cycles = boost::uint8_t((reg >> 4) & 0xf);
            divider0_high_cycles = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 401:
            divider0_bypass = boost::uint8_t((reg >> 7) & 0x1);
            divider0_ignore_sync = boost::uint8_t((reg >> 6) & 0x1);
            divider0_force_high = boost::uint8_t((reg >> 5) & 0x1);
            divider0_start_high = boost::uint8_t((reg >> 4) & 0x1);
            divider0_phase_offset = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 402:
            channel0_power_down = boost::uint8_t((reg >> 2) & 0x1);
            disable_divider0_ddc = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 403:
            divider1_low_cycles = boost::uint8_t((reg >> 4) & 0xf);
            divider1_high_cycles = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 404:
            divider1_bypass = boost::uint8_t((reg >> 7) & 0x1);
            divider1_ignore_sync = boost::uint8_t((reg >> 6) & 0x1);
            divider1_force_high = boost::uint8_t((reg >> 5) & 0x1);
            divider1_start_high = boost::uint8_t((reg >> 4) & 0x1);
            divider1_phase_offset = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 405:
            channel1_power_down = boost::uint8_t((reg >> 2) & 0x1);
            disable_divider1_ddc = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 406:
            divider2_low_cycles = boost::uint8_t((reg >> 4) & 0xf);
            divider2_high_cycles = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 407:
            divider2_bypass = boost::uint8_t((reg >> 7) & 0x1);
            divider2_ignore_sync = boost::uint8_t((reg >> 6) & 0x1);
            divider2_force_high = boost::uint8_t((reg >> 5) & 0x1);
            divider2_start_high = boost::uint8_t((reg >> 4) & 0x1);
            divider2_phase_offset = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 408:
            channel2_power_down = boost::uint8_t((reg >> 2) & 0x1);
            disable_divider2_ddc = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 409:
            divider3_low_cycles = boost::uint8_t((reg >> 4) & 0xf);
            divider3_high_cycles = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 410:
            divider3_bypass = boost::uint8_t((reg >> 7) & 0x1);
            divider3_ignore_sync = boost::uint8_t((reg >> 6) & 0x1);
            divider3_force_high = boost::uint8_t((reg >> 5) & 0x1);
            divider3_start_high = boost::uint8_t((reg >> 4) & 0x1);
            divider3_phase_offset = boost::uint8_t((reg >> 0) & 0xf);
            break;
        case 411:
            channel3_power_down = boost::uint8_t((reg >> 2) & 0x1);
            disable_divider3_ddc = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 480:
            vco_divider = vco_divider_t((reg >> 0) & 0x7);
            break;
        case 481:
            power_down_clock_input_sel = boost::uint8_t((reg >> 4) & 0x1);
            power_down_vco_clock_ifc = boost::uint8_t((reg >> 3) & 0x1);
            power_down_vco_and_clock = boost::uint8_t((reg >> 2) & 0x1);
            select_vco_or_clock = select_vco_or_clock_t((reg >> 1) & 0x1);
            bypass_vco_divider = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 560:
            disable_power_on_sync = boost::uint8_t((reg >> 3) & 0x1);
            power_down_sync = boost::uint8_t((reg >> 2) & 0x1);
            power_down_dist_ref = boost::uint8_t((reg >> 1) & 0x1);
            soft_sync = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 562:
            io_update = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 2818:
            soft_eeprom = boost::uint8_t((reg >> 1) & 0x1);
            enable_eeprom_write = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 2819:
            reg2eeprom = boost::uint8_t((reg >> 0) & 0x1);
            break;
        }
    }
    
    boost::uint32_t get_write_reg(boost::uint16_t addr){
        return (boost::uint32_t(addr) << 8) | get_reg(addr);
    }
    
    boost::uint32_t get_read_reg(boost::uint16_t addr){
        return (boost::uint32_t(addr) << 8) | (1 << 23);
    }
    

    void save_state(void){
        if (_state == NULL) _state = new ad9522_regs_t();
        _state->sdo_active = this->sdo_active;
        _state->lsb_first_addr_incr = this->lsb_first_addr_incr;
        _state->soft_reset = this->soft_reset;
        _state->mirror = this->mirror;
        _state->readback_active_registers = this->readback_active_registers;
        _state->pfd_polarity = this->pfd_polarity;
        _state->cp_current = this->cp_current;
        _state->cp_mode = this->cp_mode;
        _state->pll_power_down = this->pll_power_down;
        _state->r_counter_lsb = this->r_counter_lsb;
        _state->r_counter_msb = this->r_counter_msb;
        _state->a_counter = this->a_counter;
        _state->b_counter_lsb = this->b_counter_lsb;
        _state->b_counter_msb = this->b_counter_msb;
        _state->set_cp_pin_to_vcp_2 = this->set_cp_pin_to_vcp_2;
        _state->reset_r_counter = this->reset_r_counter;
        _state->reset_a_and_b_counters = this->reset_a_and_b_counters;
        _state->reset_all_counters = this->reset_all_counters;
        _state->b_counter_bypass = this->b_counter_bypass;
        _state->prescaler_p = this->prescaler_p;
        _state->status_pin_control = this->status_pin_control;
        _state->antibacklash_pulse_width = this->antibacklash_pulse_width;
        _state->enb_cmos_ref_input_dc_off = this->enb_cmos_ref_input_dc_off;
        _state->lock_detect_counter = this->lock_detect_counter;
        _state->digital_lock_detect_window = this->digital_lock_detect_window;
        _state->disable_digital_lock_detect = this->disable_digital_lock_detect;
        _state->vco_calibration_divider = this->vco_calibration_divider;
        _state->vco_calibration_now = this->vco_calibration_now;
        _state->r_a_b_counters_sync_pin_rst = this->r_a_b_counters_sync_pin_rst;
        _state->r_path_delay = this->r_path_delay;
        _state->n_path_delay = this->n_path_delay;
        _state->enable_status_pin_divider = this->enable_status_pin_divider;
        _state->ref_freq_monitor_threshold = this->ref_freq_monitor_threshold;
        _state->ld_pin_control = this->ld_pin_control;
        _state->enable_vco_freq_monitor = this->enable_vco_freq_monitor;
        _state->enable_ref2_freq_monitor = this->enable_ref2_freq_monitor;
        _state->enable_ref1_freq_monitor = this->enable_ref1_freq_monitor;
        _state->refmon_pin_control = this->refmon_pin_control;
        _state->disable_switchover_deglitch = this->disable_switchover_deglitch;
        _state->select_ref = this->select_ref;
        _state->use_ref_sel_pin = this->use_ref_sel_pin;
        _state->enb_auto_ref_switchover = this->enb_auto_ref_switchover;
        _state->stay_on_ref2 = this->stay_on_ref2;
        _state->enable_ref2 = this->enable_ref2;
        _state->enable_ref1 = this->enable_ref1;
        _state->enable_differential_ref = this->enable_differential_ref;
        _state->enb_stat_eeprom_at_stat_pin = this->enb_stat_eeprom_at_stat_pin;
        _state->enable_xtal_osc = this->enable_xtal_osc;
        _state->enable_clock_doubler = this->enable_clock_doubler;
        _state->disable_pll_status_reg = this->disable_pll_status_reg;
        _state->enable_ld_pin_comparator = this->enable_ld_pin_comparator;
        _state->enable_external_holdover = this->enable_external_holdover;
        _state->enable_holdover = this->enable_holdover;
        _state->external_zero_delay_fcds = this->external_zero_delay_fcds;
        _state->enable_external_zero_delay = this->enable_external_zero_delay;
        _state->enable_zero_delay = this->enable_zero_delay;
        _state->vco_calibration_finished = this->vco_calibration_finished;
        _state->holdover_active = this->holdover_active;
        _state->ref2_selected = this->ref2_selected;
        _state->vco_freq_gt_thresh = this->vco_freq_gt_thresh;
        _state->ref2_freq_gt_thresh = this->ref2_freq_gt_thresh;
        _state->ref1_freq_gt_thresh = this->ref1_freq_gt_thresh;
        _state->digital_lock_detect = this->digital_lock_detect;
        _state->out0_format = this->out0_format;
        _state->out0_cmos_configuration = this->out0_cmos_configuration;
        _state->out0_polarity = this->out0_polarity;
        _state->out0_lvds_diff_voltage = this->out0_lvds_diff_voltage;
        _state->out0_lvds_power_down = this->out0_lvds_power_down;
        _state->out1_format = this->out1_format;
        _state->out1_cmos_configuration = this->out1_cmos_configuration;
        _state->out1_polarity = this->out1_polarity;
        _state->out1_lvds_diff_voltage = this->out1_lvds_diff_voltage;
        _state->out1_lvds_power_down = this->out1_lvds_power_down;
        _state->out2_format = this->out2_format;
        _state->out2_cmos_configuration = this->out2_cmos_configuration;
        _state->out2_polarity = this->out2_polarity;
        _state->out2_lvds_diff_voltage = this->out2_lvds_diff_voltage;
        _state->out2_lvds_power_down = this->out2_lvds_power_down;
        _state->out3_format = this->out3_format;
        _state->out3_cmos_configuration = this->out3_cmos_configuration;
        _state->out3_polarity = this->out3_polarity;
        _state->out3_lvds_diff_voltage = this->out3_lvds_diff_voltage;
        _state->out3_lvds_power_down = this->out3_lvds_power_down;
        _state->out4_format = this->out4_format;
        _state->out4_cmos_configuration = this->out4_cmos_configuration;
        _state->out4_polarity = this->out4_polarity;
        _state->out4_lvds_diff_voltage = this->out4_lvds_diff_voltage;
        _state->out4_lvds_power_down = this->out4_lvds_power_down;
        _state->out5_format = this->out5_format;
        _state->out5_cmos_configuration = this->out5_cmos_configuration;
        _state->out5_polarity = this->out5_polarity;
        _state->out5_lvds_diff_voltage = this->out5_lvds_diff_voltage;
        _state->out5_lvds_power_down = this->out5_lvds_power_down;
        _state->out6_format = this->out6_format;
        _state->out6_cmos_configuration = this->out6_cmos_configuration;
        _state->out6_polarity = this->out6_polarity;
        _state->out6_lvds_diff_voltage = this->out6_lvds_diff_voltage;
        _state->out6_lvds_power_down = this->out6_lvds_power_down;
        _state->out7_format = this->out7_format;
        _state->out7_cmos_configuration = this->out7_cmos_configuration;
        _state->out7_polarity = this->out7_polarity;
        _state->out7_lvds_diff_voltage = this->out7_lvds_diff_voltage;
        _state->out7_lvds_power_down = this->out7_lvds_power_down;
        _state->out8_format = this->out8_format;
        _state->out8_cmos_configuration = this->out8_cmos_configuration;
        _state->out8_polarity = this->out8_polarity;
        _state->out8_lvds_diff_voltage = this->out8_lvds_diff_voltage;
        _state->out8_lvds_power_down = this->out8_lvds_power_down;
        _state->out9_format = this->out9_format;
        _state->out9_cmos_configuration = this->out9_cmos_configuration;
        _state->out9_polarity = this->out9_polarity;
        _state->out9_lvds_diff_voltage = this->out9_lvds_diff_voltage;
        _state->out9_lvds_power_down = this->out9_lvds_power_down;
        _state->out10_format = this->out10_format;
        _state->out10_cmos_configuration = this->out10_cmos_configuration;
        _state->out10_polarity = this->out10_polarity;
        _state->out10_lvds_diff_voltage = this->out10_lvds_diff_voltage;
        _state->out10_lvds_power_down = this->out10_lvds_power_down;
        _state->out11_format = this->out11_format;
        _state->out11_cmos_configuration = this->out11_cmos_configuration;
        _state->out11_polarity = this->out11_polarity;
        _state->out11_lvds_diff_voltage = this->out11_lvds_diff_voltage;
        _state->out11_lvds_power_down = this->out11_lvds_power_down;
        _state->csdld_en_out_7 = this->csdld_en_out_7;
        _state->csdld_en_out_6 = this->csdld_en_out_6;
        _state->csdld_en_out_5 = this->csdld_en_out_5;
        _state->csdld_en_out_4 = this->csdld_en_out_4;
        _state->csdld_en_out_3 = this->csdld_en_out_3;
        _state->csdld_en_out_2 = this->csdld_en_out_2;
        _state->csdld_en_out_1 = this->csdld_en_out_1;
        _state->csdld_en_out_0 = this->csdld_en_out_0;
        _state->csdld_en_out_11 = this->csdld_en_out_11;
        _state->csdld_en_out_10 = this->csdld_en_out_10;
        _state->csdld_en_out_9 = this->csdld_en_out_9;
        _state->csdld_en_out_8 = this->csdld_en_out_8;
        _state->divider0_low_cycles = this->divider0_low_cycles;
        _state->divider0_high_cycles = this->divider0_high_cycles;
        _state->divider0_bypass = this->divider0_bypass;
        _state->divider0_ignore_sync = this->divider0_ignore_sync;
        _state->divider0_force_high = this->divider0_force_high;
        _state->divider0_start_high = this->divider0_start_high;
        _state->divider0_phase_offset = this->divider0_phase_offset;
        _state->channel0_power_down = this->channel0_power_down;
        _state->disable_divider0_ddc = this->disable_divider0_ddc;
        _state->divider1_low_cycles = this->divider1_low_cycles;
        _state->divider1_high_cycles = this->divider1_high_cycles;
        _state->divider1_bypass = this->divider1_bypass;
        _state->divider1_ignore_sync = this->divider1_ignore_sync;
        _state->divider1_force_high = this->divider1_force_high;
        _state->divider1_start_high = this->divider1_start_high;
        _state->divider1_phase_offset = this->divider1_phase_offset;
        _state->channel1_power_down = this->channel1_power_down;
        _state->disable_divider1_ddc = this->disable_divider1_ddc;
        _state->divider2_low_cycles = this->divider2_low_cycles;
        _state->divider2_high_cycles = this->divider2_high_cycles;
        _state->divider2_bypass = this->divider2_bypass;
        _state->divider2_ignore_sync = this->divider2_ignore_sync;
        _state->divider2_force_high = this->divider2_force_high;
        _state->divider2_start_high = this->divider2_start_high;
        _state->divider2_phase_offset = this->divider2_phase_offset;
        _state->channel2_power_down = this->channel2_power_down;
        _state->disable_divider2_ddc = this->disable_divider2_ddc;
        _state->divider3_low_cycles = this->divider3_low_cycles;
        _state->divider3_high_cycles = this->divider3_high_cycles;
        _state->divider3_bypass = this->divider3_bypass;
        _state->divider3_ignore_sync = this->divider3_ignore_sync;
        _state->divider3_force_high = this->divider3_force_high;
        _state->divider3_start_high = this->divider3_start_high;
        _state->divider3_phase_offset = this->divider3_phase_offset;
        _state->channel3_power_down = this->channel3_power_down;
        _state->disable_divider3_ddc = this->disable_divider3_ddc;
        _state->vco_divider = this->vco_divider;
        _state->power_down_clock_input_sel = this->power_down_clock_input_sel;
        _state->power_down_vco_clock_ifc = this->power_down_vco_clock_ifc;
        _state->power_down_vco_and_clock = this->power_down_vco_and_clock;
        _state->select_vco_or_clock = this->select_vco_or_clock;
        _state->bypass_vco_divider = this->bypass_vco_divider;
        _state->disable_power_on_sync = this->disable_power_on_sync;
        _state->power_down_sync = this->power_down_sync;
        _state->power_down_dist_ref = this->power_down_dist_ref;
        _state->soft_sync = this->soft_sync;
        _state->io_update = this->io_update;
        _state->soft_eeprom = this->soft_eeprom;
        _state->enable_eeprom_write = this->enable_eeprom_write;
        _state->reg2eeprom = this->reg2eeprom;
    }

    template<typename T> std::set<T> get_changed_addrs(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if(_state->sdo_active != this->sdo_active){
            addrs.insert(0);
        }
        if(_state->lsb_first_addr_incr != this->lsb_first_addr_incr){
            addrs.insert(0);
        }
        if(_state->soft_reset != this->soft_reset){
            addrs.insert(0);
        }
        if(_state->mirror != this->mirror){
            addrs.insert(0);
        }
        if(_state->readback_active_registers != this->readback_active_registers){
            addrs.insert(4);
        }
        if(_state->pfd_polarity != this->pfd_polarity){
            addrs.insert(16);
        }
        if(_state->cp_current != this->cp_current){
            addrs.insert(16);
        }
        if(_state->cp_mode != this->cp_mode){
            addrs.insert(16);
        }
        if(_state->pll_power_down != this->pll_power_down){
            addrs.insert(16);
        }
        if(_state->r_counter_lsb != this->r_counter_lsb){
            addrs.insert(17);
        }
        if(_state->r_counter_msb != this->r_counter_msb){
            addrs.insert(18);
        }
        if(_state->a_counter != this->a_counter){
            addrs.insert(19);
        }
        if(_state->b_counter_lsb != this->b_counter_lsb){
            addrs.insert(20);
        }
        if(_state->b_counter_msb != this->b_counter_msb){
            addrs.insert(21);
        }
        if(_state->set_cp_pin_to_vcp_2 != this->set_cp_pin_to_vcp_2){
            addrs.insert(22);
        }
        if(_state->reset_r_counter != this->reset_r_counter){
            addrs.insert(22);
        }
        if(_state->reset_a_and_b_counters != this->reset_a_and_b_counters){
            addrs.insert(22);
        }
        if(_state->reset_all_counters != this->reset_all_counters){
            addrs.insert(22);
        }
        if(_state->b_counter_bypass != this->b_counter_bypass){
            addrs.insert(22);
        }
        if(_state->prescaler_p != this->prescaler_p){
            addrs.insert(22);
        }
        if(_state->status_pin_control != this->status_pin_control){
            addrs.insert(23);
        }
        if(_state->antibacklash_pulse_width != this->antibacklash_pulse_width){
            addrs.insert(23);
        }
        if(_state->enb_cmos_ref_input_dc_off != this->enb_cmos_ref_input_dc_off){
            addrs.insert(24);
        }
        if(_state->lock_detect_counter != this->lock_detect_counter){
            addrs.insert(24);
        }
        if(_state->digital_lock_detect_window != this->digital_lock_detect_window){
            addrs.insert(24);
        }
        if(_state->disable_digital_lock_detect != this->disable_digital_lock_detect){
            addrs.insert(24);
        }
        if(_state->vco_calibration_divider != this->vco_calibration_divider){
            addrs.insert(24);
        }
        if(_state->vco_calibration_now != this->vco_calibration_now){
            addrs.insert(24);
        }
        if(_state->r_a_b_counters_sync_pin_rst != this->r_a_b_counters_sync_pin_rst){
            addrs.insert(25);
        }
        if(_state->r_path_delay != this->r_path_delay){
            addrs.insert(25);
        }
        if(_state->n_path_delay != this->n_path_delay){
            addrs.insert(25);
        }
        if(_state->enable_status_pin_divider != this->enable_status_pin_divider){
            addrs.insert(26);
        }
        if(_state->ref_freq_monitor_threshold != this->ref_freq_monitor_threshold){
            addrs.insert(26);
        }
        if(_state->ld_pin_control != this->ld_pin_control){
            addrs.insert(26);
        }
        if(_state->enable_vco_freq_monitor != this->enable_vco_freq_monitor){
            addrs.insert(27);
        }
        if(_state->enable_ref2_freq_monitor != this->enable_ref2_freq_monitor){
            addrs.insert(27);
        }
        if(_state->enable_ref1_freq_monitor != this->enable_ref1_freq_monitor){
            addrs.insert(27);
        }
        if(_state->refmon_pin_control != this->refmon_pin_control){
            addrs.insert(27);
        }
        if(_state->disable_switchover_deglitch != this->disable_switchover_deglitch){
            addrs.insert(28);
        }
        if(_state->select_ref != this->select_ref){
            addrs.insert(28);
        }
        if(_state->use_ref_sel_pin != this->use_ref_sel_pin){
            addrs.insert(28);
        }
        if(_state->enb_auto_ref_switchover != this->enb_auto_ref_switchover){
            addrs.insert(28);
        }
        if(_state->stay_on_ref2 != this->stay_on_ref2){
            addrs.insert(28);
        }
        if(_state->enable_ref2 != this->enable_ref2){
            addrs.insert(28);
        }
        if(_state->enable_ref1 != this->enable_ref1){
            addrs.insert(28);
        }
        if(_state->enable_differential_ref != this->enable_differential_ref){
            addrs.insert(28);
        }
        if(_state->enb_stat_eeprom_at_stat_pin != this->enb_stat_eeprom_at_stat_pin){
            addrs.insert(29);
        }
        if(_state->enable_xtal_osc != this->enable_xtal_osc){
            addrs.insert(29);
        }
        if(_state->enable_clock_doubler != this->enable_clock_doubler){
            addrs.insert(29);
        }
        if(_state->disable_pll_status_reg != this->disable_pll_status_reg){
            addrs.insert(29);
        }
        if(_state->enable_ld_pin_comparator != this->enable_ld_pin_comparator){
            addrs.insert(29);
        }
        if(_state->enable_external_holdover != this->enable_external_holdover){
            addrs.insert(29);
        }
        if(_state->enable_holdover != this->enable_holdover){
            addrs.insert(29);
        }
        if(_state->external_zero_delay_fcds != this->external_zero_delay_fcds){
            addrs.insert(30);
        }
        if(_state->enable_external_zero_delay != this->enable_external_zero_delay){
            addrs.insert(30);
        }
        if(_state->enable_zero_delay != this->enable_zero_delay){
            addrs.insert(30);
        }
        if(_state->vco_calibration_finished != this->vco_calibration_finished){
            addrs.insert(31);
        }
        if(_state->holdover_active != this->holdover_active){
            addrs.insert(31);
        }
        if(_state->ref2_selected != this->ref2_selected){
            addrs.insert(31);
        }
        if(_state->vco_freq_gt_thresh != this->vco_freq_gt_thresh){
            addrs.insert(31);
        }
        if(_state->ref2_freq_gt_thresh != this->ref2_freq_gt_thresh){
            addrs.insert(31);
        }
        if(_state->ref1_freq_gt_thresh != this->ref1_freq_gt_thresh){
            addrs.insert(31);
        }
        if(_state->digital_lock_detect != this->digital_lock_detect){
            addrs.insert(31);
        }
        if(_state->out0_format != this->out0_format){
            addrs.insert(240);
        }
        if(_state->out0_cmos_configuration != this->out0_cmos_configuration){
            addrs.insert(240);
        }
        if(_state->out0_polarity != this->out0_polarity){
            addrs.insert(240);
        }
        if(_state->out0_lvds_diff_voltage != this->out0_lvds_diff_voltage){
            addrs.insert(240);
        }
        if(_state->out0_lvds_power_down != this->out0_lvds_power_down){
            addrs.insert(240);
        }
        if(_state->out1_format != this->out1_format){
            addrs.insert(241);
        }
        if(_state->out1_cmos_configuration != this->out1_cmos_configuration){
            addrs.insert(241);
        }
        if(_state->out1_polarity != this->out1_polarity){
            addrs.insert(241);
        }
        if(_state->out1_lvds_diff_voltage != this->out1_lvds_diff_voltage){
            addrs.insert(241);
        }
        if(_state->out1_lvds_power_down != this->out1_lvds_power_down){
            addrs.insert(241);
        }
        if(_state->out2_format != this->out2_format){
            addrs.insert(242);
        }
        if(_state->out2_cmos_configuration != this->out2_cmos_configuration){
            addrs.insert(242);
        }
        if(_state->out2_polarity != this->out2_polarity){
            addrs.insert(242);
        }
        if(_state->out2_lvds_diff_voltage != this->out2_lvds_diff_voltage){
            addrs.insert(242);
        }
        if(_state->out2_lvds_power_down != this->out2_lvds_power_down){
            addrs.insert(242);
        }
        if(_state->out3_format != this->out3_format){
            addrs.insert(243);
        }
        if(_state->out3_cmos_configuration != this->out3_cmos_configuration){
            addrs.insert(243);
        }
        if(_state->out3_polarity != this->out3_polarity){
            addrs.insert(243);
        }
        if(_state->out3_lvds_diff_voltage != this->out3_lvds_diff_voltage){
            addrs.insert(243);
        }
        if(_state->out3_lvds_power_down != this->out3_lvds_power_down){
            addrs.insert(243);
        }
        if(_state->out4_format != this->out4_format){
            addrs.insert(244);
        }
        if(_state->out4_cmos_configuration != this->out4_cmos_configuration){
            addrs.insert(244);
        }
        if(_state->out4_polarity != this->out4_polarity){
            addrs.insert(244);
        }
        if(_state->out4_lvds_diff_voltage != this->out4_lvds_diff_voltage){
            addrs.insert(244);
        }
        if(_state->out4_lvds_power_down != this->out4_lvds_power_down){
            addrs.insert(244);
        }
        if(_state->out5_format != this->out5_format){
            addrs.insert(245);
        }
        if(_state->out5_cmos_configuration != this->out5_cmos_configuration){
            addrs.insert(245);
        }
        if(_state->out5_polarity != this->out5_polarity){
            addrs.insert(245);
        }
        if(_state->out5_lvds_diff_voltage != this->out5_lvds_diff_voltage){
            addrs.insert(245);
        }
        if(_state->out5_lvds_power_down != this->out5_lvds_power_down){
            addrs.insert(245);
        }
        if(_state->out6_format != this->out6_format){
            addrs.insert(246);
        }
        if(_state->out6_cmos_configuration != this->out6_cmos_configuration){
            addrs.insert(246);
        }
        if(_state->out6_polarity != this->out6_polarity){
            addrs.insert(246);
        }
        if(_state->out6_lvds_diff_voltage != this->out6_lvds_diff_voltage){
            addrs.insert(246);
        }
        if(_state->out6_lvds_power_down != this->out6_lvds_power_down){
            addrs.insert(246);
        }
        if(_state->out7_format != this->out7_format){
            addrs.insert(247);
        }
        if(_state->out7_cmos_configuration != this->out7_cmos_configuration){
            addrs.insert(247);
        }
        if(_state->out7_polarity != this->out7_polarity){
            addrs.insert(247);
        }
        if(_state->out7_lvds_diff_voltage != this->out7_lvds_diff_voltage){
            addrs.insert(247);
        }
        if(_state->out7_lvds_power_down != this->out7_lvds_power_down){
            addrs.insert(247);
        }
        if(_state->out8_format != this->out8_format){
            addrs.insert(248);
        }
        if(_state->out8_cmos_configuration != this->out8_cmos_configuration){
            addrs.insert(248);
        }
        if(_state->out8_polarity != this->out8_polarity){
            addrs.insert(248);
        }
        if(_state->out8_lvds_diff_voltage != this->out8_lvds_diff_voltage){
            addrs.insert(248);
        }
        if(_state->out8_lvds_power_down != this->out8_lvds_power_down){
            addrs.insert(248);
        }
        if(_state->out9_format != this->out9_format){
            addrs.insert(249);
        }
        if(_state->out9_cmos_configuration != this->out9_cmos_configuration){
            addrs.insert(249);
        }
        if(_state->out9_polarity != this->out9_polarity){
            addrs.insert(249);
        }
        if(_state->out9_lvds_diff_voltage != this->out9_lvds_diff_voltage){
            addrs.insert(249);
        }
        if(_state->out9_lvds_power_down != this->out9_lvds_power_down){
            addrs.insert(249);
        }
        if(_state->out10_format != this->out10_format){
            addrs.insert(250);
        }
        if(_state->out10_cmos_configuration != this->out10_cmos_configuration){
            addrs.insert(250);
        }
        if(_state->out10_polarity != this->out10_polarity){
            addrs.insert(250);
        }
        if(_state->out10_lvds_diff_voltage != this->out10_lvds_diff_voltage){
            addrs.insert(250);
        }
        if(_state->out10_lvds_power_down != this->out10_lvds_power_down){
            addrs.insert(250);
        }
        if(_state->out11_format != this->out11_format){
            addrs.insert(251);
        }
        if(_state->out11_cmos_configuration != this->out11_cmos_configuration){
            addrs.insert(251);
        }
        if(_state->out11_polarity != this->out11_polarity){
            addrs.insert(251);
        }
        if(_state->out11_lvds_diff_voltage != this->out11_lvds_diff_voltage){
            addrs.insert(251);
        }
        if(_state->out11_lvds_power_down != this->out11_lvds_power_down){
            addrs.insert(251);
        }
        if(_state->csdld_en_out_7 != this->csdld_en_out_7){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_6 != this->csdld_en_out_6){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_5 != this->csdld_en_out_5){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_4 != this->csdld_en_out_4){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_3 != this->csdld_en_out_3){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_2 != this->csdld_en_out_2){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_1 != this->csdld_en_out_1){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_0 != this->csdld_en_out_0){
            addrs.insert(252);
        }
        if(_state->csdld_en_out_11 != this->csdld_en_out_11){
            addrs.insert(253);
        }
        if(_state->csdld_en_out_10 != this->csdld_en_out_10){
            addrs.insert(253);
        }
        if(_state->csdld_en_out_9 != this->csdld_en_out_9){
            addrs.insert(253);
        }
        if(_state->csdld_en_out_8 != this->csdld_en_out_8){
            addrs.insert(253);
        }
        if(_state->divider0_low_cycles != this->divider0_low_cycles){
            addrs.insert(400);
        }
        if(_state->divider0_high_cycles != this->divider0_high_cycles){
            addrs.insert(400);
        }
        if(_state->divider0_bypass != this->divider0_bypass){
            addrs.insert(401);
        }
        if(_state->divider0_ignore_sync != this->divider0_ignore_sync){
            addrs.insert(401);
        }
        if(_state->divider0_force_high != this->divider0_force_high){
            addrs.insert(401);
        }
        if(_state->divider0_start_high != this->divider0_start_high){
            addrs.insert(401);
        }
        if(_state->divider0_phase_offset != this->divider0_phase_offset){
            addrs.insert(401);
        }
        if(_state->channel0_power_down != this->channel0_power_down){
            addrs.insert(402);
        }
        if(_state->disable_divider0_ddc != this->disable_divider0_ddc){
            addrs.insert(402);
        }
        if(_state->divider1_low_cycles != this->divider1_low_cycles){
            addrs.insert(403);
        }
        if(_state->divider1_high_cycles != this->divider1_high_cycles){
            addrs.insert(403);
        }
        if(_state->divider1_bypass != this->divider1_bypass){
            addrs.insert(404);
        }
        if(_state->divider1_ignore_sync != this->divider1_ignore_sync){
            addrs.insert(404);
        }
        if(_state->divider1_force_high != this->divider1_force_high){
            addrs.insert(404);
        }
        if(_state->divider1_start_high != this->divider1_start_high){
            addrs.insert(404);
        }
        if(_state->divider1_phase_offset != this->divider1_phase_offset){
            addrs.insert(404);
        }
        if(_state->channel1_power_down != this->channel1_power_down){
            addrs.insert(405);
        }
        if(_state->disable_divider1_ddc != this->disable_divider1_ddc){
            addrs.insert(405);
        }
        if(_state->divider2_low_cycles != this->divider2_low_cycles){
            addrs.insert(406);
        }
        if(_state->divider2_high_cycles != this->divider2_high_cycles){
            addrs.insert(406);
        }
        if(_state->divider2_bypass != this->divider2_bypass){
            addrs.insert(407);
        }
        if(_state->divider2_ignore_sync != this->divider2_ignore_sync){
            addrs.insert(407);
        }
        if(_state->divider2_force_high != this->divider2_force_high){
            addrs.insert(407);
        }
        if(_state->divider2_start_high != this->divider2_start_high){
            addrs.insert(407);
        }
        if(_state->divider2_phase_offset != this->divider2_phase_offset){
            addrs.insert(407);
        }
        if(_state->channel2_power_down != this->channel2_power_down){
            addrs.insert(408);
        }
        if(_state->disable_divider2_ddc != this->disable_divider2_ddc){
            addrs.insert(408);
        }
        if(_state->divider3_low_cycles != this->divider3_low_cycles){
            addrs.insert(409);
        }
        if(_state->divider3_high_cycles != this->divider3_high_cycles){
            addrs.insert(409);
        }
        if(_state->divider3_bypass != this->divider3_bypass){
            addrs.insert(410);
        }
        if(_state->divider3_ignore_sync != this->divider3_ignore_sync){
            addrs.insert(410);
        }
        if(_state->divider3_force_high != this->divider3_force_high){
            addrs.insert(410);
        }
        if(_state->divider3_start_high != this->divider3_start_high){
            addrs.insert(410);
        }
        if(_state->divider3_phase_offset != this->divider3_phase_offset){
            addrs.insert(410);
        }
        if(_state->channel3_power_down != this->channel3_power_down){
            addrs.insert(411);
        }
        if(_state->disable_divider3_ddc != this->disable_divider3_ddc){
            addrs.insert(411);
        }
        if(_state->vco_divider != this->vco_divider){
            addrs.insert(480);
        }
        if(_state->power_down_clock_input_sel != this->power_down_clock_input_sel){
            addrs.insert(481);
        }
        if(_state->power_down_vco_clock_ifc != this->power_down_vco_clock_ifc){
            addrs.insert(481);
        }
        if(_state->power_down_vco_and_clock != this->power_down_vco_and_clock){
            addrs.insert(481);
        }
        if(_state->select_vco_or_clock != this->select_vco_or_clock){
            addrs.insert(481);
        }
        if(_state->bypass_vco_divider != this->bypass_vco_divider){
            addrs.insert(481);
        }
        if(_state->disable_power_on_sync != this->disable_power_on_sync){
            addrs.insert(560);
        }
        if(_state->power_down_sync != this->power_down_sync){
            addrs.insert(560);
        }
        if(_state->power_down_dist_ref != this->power_down_dist_ref){
            addrs.insert(560);
        }
        if(_state->soft_sync != this->soft_sync){
            addrs.insert(560);
        }
        if(_state->io_update != this->io_update){
            addrs.insert(562);
        }
        if(_state->soft_eeprom != this->soft_eeprom){
            addrs.insert(2818);
        }
        if(_state->enable_eeprom_write != this->enable_eeprom_write){
            addrs.insert(2818);
        }
        if(_state->reg2eeprom != this->reg2eeprom){
            addrs.insert(2819);
        }
        return addrs;
    }

    boost::uint16_t get_r_counter(void){
        return
        (boost::uint16_t(r_counter_lsb & 0xff) << 0) |
        (boost::uint16_t(r_counter_msb & 0x3f) << 8) |
        0;
    }

    void set_r_counter(boost::uint16_t reg){
        r_counter_lsb = (reg >> 0) & 0xff;
        r_counter_msb = (reg >> 8) & 0x3f;
    }

    boost::uint16_t get_b_counter(void){
        return
        (boost::uint16_t(b_counter_lsb & 0xff) << 0) |
        (boost::uint16_t(b_counter_msb & 0x1f) << 8) |
        0;
    }

    void set_b_counter(boost::uint16_t reg){
        b_counter_lsb = (reg >> 0) & 0xff;
        b_counter_msb = (reg >> 8) & 0x1f;
    }

private:
    ad9522_regs_t *_state;
};

#endif /* INCLUDED_AD9522_REGS_HPP */
