
/***********************************************************************
 * This file was generated by gen_convert_general.py on Fri Sep  6 06:41:45 2013
 **********************************************************************/

#include "convert_common.hpp"
#include <uhd/utils/byteswap.hpp>

using namespace uhd::convert;

DECLARE_CONVERTER(item32, 1, sc16_item32_be, 1, PRIORITY_GENERAL){
    const item32_t *input = reinterpret_cast<const item32_t *>(inputs[0]);
    item32_t *output = reinterpret_cast<item32_t *>(outputs[0]);

    for (size_t i = 0; i < nsamps; i++){
        output[i] = uhd::htonx(input[i]);
    }
}

DECLARE_CONVERTER(sc16_item32_be, 1, item32, 1, PRIORITY_GENERAL){
    const item32_t *input = reinterpret_cast<const item32_t *>(inputs[0]);
    item32_t *output = reinterpret_cast<item32_t *>(outputs[0]);

    for (size_t i = 0; i < nsamps; i++){
        output[i] = uhd::ntohx(input[i]);
    }
}

DECLARE_CONVERTER(item32, 1, sc16_item32_le, 1, PRIORITY_GENERAL){
    const item32_t *input = reinterpret_cast<const item32_t *>(inputs[0]);
    item32_t *output = reinterpret_cast<item32_t *>(outputs[0]);

    for (size_t i = 0; i < nsamps; i++){
        output[i] = uhd::htowx(input[i]);
    }
}

DECLARE_CONVERTER(sc16_item32_le, 1, item32, 1, PRIORITY_GENERAL){
    const item32_t *input = reinterpret_cast<const item32_t *>(inputs[0]);
    item32_t *output = reinterpret_cast<item32_t *>(outputs[0]);

    for (size_t i = 0; i < nsamps; i++){
        output[i] = uhd::wtohx(input[i]);
    }
}

DECLARE_CONVERTER(fc64, 1, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const fc64_t *input0 = reinterpret_cast<const fc64_t *>(inputs[0]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag()*scale_factor)));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, fc64, 1, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc64_t *output0 = reinterpret_cast<fc64_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, fc64, 1, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc64_t *output0 = reinterpret_cast<fc64_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
    }
}

DECLARE_CONVERTER(fc32, 1, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const fc32_t *input0 = reinterpret_cast<const fc32_t *>(inputs[0]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag()*float(scale_factor))));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, fc32, 1, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc32_t *output0 = reinterpret_cast<fc32_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, fc32, 1, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc32_t *output0 = reinterpret_cast<fc32_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
    }
}

DECLARE_CONVERTER(sc16, 1, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const sc16_t *input0 = reinterpret_cast<const sc16_t *>(inputs[0]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag())));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, sc16, 1, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    sc16_t *output0 = reinterpret_cast<sc16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, sc16, 1, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    sc16_t *output0 = reinterpret_cast<sc16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
    }
}

DECLARE_CONVERTER(fc64, 2, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const fc64_t *input0 = reinterpret_cast<const fc64_t *>(inputs[0]);
    const fc64_t *input1 = reinterpret_cast<const fc64_t *>(inputs[1]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].imag()*scale_factor)));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, fc64, 2, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc64_t *output0 = reinterpret_cast<fc64_t *>(outputs[0]);
    fc64_t *output1 = reinterpret_cast<fc64_t *>(outputs[1]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
        output1[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, fc64, 2, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc64_t *output0 = reinterpret_cast<fc64_t *>(outputs[0]);
    fc64_t *output1 = reinterpret_cast<fc64_t *>(outputs[1]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output1[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
    }
}

DECLARE_CONVERTER(fc32, 2, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const fc32_t *input0 = reinterpret_cast<const fc32_t *>(inputs[0]);
    const fc32_t *input1 = reinterpret_cast<const fc32_t *>(inputs[1]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].imag()*float(scale_factor))));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, fc32, 2, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc32_t *output0 = reinterpret_cast<fc32_t *>(outputs[0]);
    fc32_t *output1 = reinterpret_cast<fc32_t *>(outputs[1]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
        output1[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, fc32, 2, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc32_t *output0 = reinterpret_cast<fc32_t *>(outputs[0]);
    fc32_t *output1 = reinterpret_cast<fc32_t *>(outputs[1]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output1[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
    }
}

DECLARE_CONVERTER(sc16, 2, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const sc16_t *input0 = reinterpret_cast<const sc16_t *>(inputs[0]);
    const sc16_t *input1 = reinterpret_cast<const sc16_t *>(inputs[1]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].imag())));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, sc16, 2, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    sc16_t *output0 = reinterpret_cast<sc16_t *>(outputs[0]);
    sc16_t *output1 = reinterpret_cast<sc16_t *>(outputs[1]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
        output1[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, sc16, 2, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    sc16_t *output0 = reinterpret_cast<sc16_t *>(outputs[0]);
    sc16_t *output1 = reinterpret_cast<sc16_t *>(outputs[1]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output1[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
    }
}

DECLARE_CONVERTER(fc64, 4, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const fc64_t *input0 = reinterpret_cast<const fc64_t *>(inputs[0]);
    const fc64_t *input1 = reinterpret_cast<const fc64_t *>(inputs[1]);
    const fc64_t *input2 = reinterpret_cast<const fc64_t *>(inputs[2]);
    const fc64_t *input3 = reinterpret_cast<const fc64_t *>(inputs[3]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].imag()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input2[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input2[i].imag()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input3[i].real()*scale_factor)));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input3[i].imag()*scale_factor)));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, fc64, 4, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc64_t *output0 = reinterpret_cast<fc64_t *>(outputs[0]);
    fc64_t *output1 = reinterpret_cast<fc64_t *>(outputs[1]);
    fc64_t *output2 = reinterpret_cast<fc64_t *>(outputs[2]);
    fc64_t *output3 = reinterpret_cast<fc64_t *>(outputs[3]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
        output1[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
        output2[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
        output3[i] = fc64_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*scale_factor,
            boost::int16_t(uhd::wtohx(input[j+1]))*scale_factor
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, fc64, 4, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc64_t *output0 = reinterpret_cast<fc64_t *>(outputs[0]);
    fc64_t *output1 = reinterpret_cast<fc64_t *>(outputs[1]);
    fc64_t *output2 = reinterpret_cast<fc64_t *>(outputs[2]);
    fc64_t *output3 = reinterpret_cast<fc64_t *>(outputs[3]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output1[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output2[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output3[i] = fc64_t(
            boost::int8_t(num)*scale_factor,
            boost::int8_t(num >> 8)*scale_factor
        );
        }
    }
}

DECLARE_CONVERTER(fc32, 4, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const fc32_t *input0 = reinterpret_cast<const fc32_t *>(inputs[0]);
    const fc32_t *input1 = reinterpret_cast<const fc32_t *>(inputs[1]);
    const fc32_t *input2 = reinterpret_cast<const fc32_t *>(inputs[2]);
    const fc32_t *input3 = reinterpret_cast<const fc32_t *>(inputs[3]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].imag()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input2[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input2[i].imag()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input3[i].real()*float(scale_factor))));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input3[i].imag()*float(scale_factor))));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, fc32, 4, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc32_t *output0 = reinterpret_cast<fc32_t *>(outputs[0]);
    fc32_t *output1 = reinterpret_cast<fc32_t *>(outputs[1]);
    fc32_t *output2 = reinterpret_cast<fc32_t *>(outputs[2]);
    fc32_t *output3 = reinterpret_cast<fc32_t *>(outputs[3]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
        output1[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
        output2[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
        output3[i] = fc32_t(
            boost::int16_t(uhd::wtohx(input[j+0]))*float(scale_factor),
            boost::int16_t(uhd::wtohx(input[j+1]))*float(scale_factor)
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, fc32, 4, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    fc32_t *output0 = reinterpret_cast<fc32_t *>(outputs[0]);
    fc32_t *output1 = reinterpret_cast<fc32_t *>(outputs[1]);
    fc32_t *output2 = reinterpret_cast<fc32_t *>(outputs[2]);
    fc32_t *output3 = reinterpret_cast<fc32_t *>(outputs[3]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output1[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output2[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output3[i] = fc32_t(
            boost::int8_t(num)*float(scale_factor),
            boost::int8_t(num >> 8)*float(scale_factor)
        );
        }
    }
}

DECLARE_CONVERTER(sc16, 4, sc16_item16_usrp1, 1, PRIORITY_GENERAL){
    const sc16_t *input0 = reinterpret_cast<const sc16_t *>(inputs[0]);
    const sc16_t *input1 = reinterpret_cast<const sc16_t *>(inputs[1]);
    const sc16_t *input2 = reinterpret_cast<const sc16_t *>(inputs[2]);
    const sc16_t *input3 = reinterpret_cast<const sc16_t *>(inputs[3]);
    boost::uint16_t *output = reinterpret_cast<boost::uint16_t *>(outputs[0]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input0[i].imag())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input1[i].imag())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input2[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input2[i].imag())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input3[i].real())));
        output[j++] = uhd::htowx(boost::uint16_t(boost::int16_t(input3[i].imag())));
    }
}

DECLARE_CONVERTER(sc16_item16_usrp1, 1, sc16, 4, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    sc16_t *output0 = reinterpret_cast<sc16_t *>(outputs[0]);
    sc16_t *output1 = reinterpret_cast<sc16_t *>(outputs[1]);
    sc16_t *output2 = reinterpret_cast<sc16_t *>(outputs[2]);
    sc16_t *output3 = reinterpret_cast<sc16_t *>(outputs[3]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        output0[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
        output1[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
        output2[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
        output3[i] = sc16_t(
            boost::int16_t(uhd::wtohx(input[j+0])),
            boost::int16_t(uhd::wtohx(input[j+1]))
        );
        j += 2;
    }
}

DECLARE_CONVERTER(sc8_item16_usrp1, 1, sc16, 4, PRIORITY_GENERAL){
    const boost::uint16_t *input = reinterpret_cast<const boost::uint16_t *>(inputs[0]);
    sc16_t *output0 = reinterpret_cast<sc16_t *>(outputs[0]);
    sc16_t *output1 = reinterpret_cast<sc16_t *>(outputs[1]);
    sc16_t *output2 = reinterpret_cast<sc16_t *>(outputs[2]);
    sc16_t *output3 = reinterpret_cast<sc16_t *>(outputs[3]);

    for (size_t i = 0, j = 0; i < nsamps; i++){
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output0[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output1[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output2[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
        {
        const boost::uint16_t num = uhd::wtohx(input[j++]);
        output3[i] = sc16_t(
            boost::int8_t(num),
            boost::int8_t(num >> 8)
        );
        }
    }
}
