/***********************************************************************
 * This file was generated by /root/uhddev/host/lib/ic_reg_maps/gen_tuner_4937di5_regs.py on Fri Sep  6 06:41:44 2013
 **********************************************************************/

#ifndef INCLUDED_TUNER_4937DI5_REGS_HPP
#define INCLUDED_TUNER_4937DI5_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <boost/cstdint.hpp>
#include <set>

class tuner_4937di5_regs_t{
public:
    boost::uint8_t db1;
    boost::uint8_t db2;
    boost::uint8_t cb7;
    enum cp_t{
        CP_LOW = 0,
        CP_HIGH = 1
    };
    cp_t cp;
    enum os_t{
        OS_ON = 0,
        OS_OFF = 1
    };
    os_t os;
    enum rs_t{
        RS_D512 = 3,
        RS_D640 = 0,
        RS_D1024 = 1
    };
    rs_t rs;
    enum test_t{
        TEST_NORMAL = 1,
        TEST_CPOFF = 2,
        TEST_CPSINK = 6,
        TEST_CPSRC = 7,
        TEST_CPTEST1 = 4,
        TEST_CPTEST2 = 5
    };
    test_t test;
    enum bandsel_t{
        BANDSEL_UHF = 3,
        BANDSEL_VHFHI = 9,
        BANDSEL_VHFLO = 10
    };
    bandsel_t bandsel;
    enum power_t{
        POWER_ON = 0,
        POWER_OFF = 1
    };
    power_t power;

    tuner_4937di5_regs_t(void){
        _state = NULL;
        db1 = 0;
        db2 = 0;
        cb7 = 1;
        cp = CP_LOW;
        os = OS_ON;
        rs = RS_D640;
        test = TEST_NORMAL;
        bandsel = BANDSEL_UHF;
        power = POWER_ON;
    }

    ~tuner_4937di5_regs_t(void){
        delete _state;
    }

    boost::uint8_t get_reg(boost::uint8_t addr){
        boost::uint8_t reg = 0;
        switch(addr){
        case 0:
            reg |= (boost::uint8_t(db1) & 0x7f) << 0;
            break;
        case 1:
            reg |= (boost::uint8_t(db2) & 0xff) << 0;
            break;
        case 2:
            reg |= (boost::uint8_t(cb7) & 0x1) << 7;
            reg |= (boost::uint8_t(cp) & 0x1) << 6;
            reg |= (boost::uint8_t(os) & 0x1) << 0;
            reg |= (boost::uint8_t(rs) & 0x3) << 1;
            reg |= (boost::uint8_t(test) & 0x7) << 3;
            break;
        case 3:
            reg |= (boost::uint8_t(bandsel) & 0xf) << 4;
            reg |= (boost::uint8_t(power) & 0x1) << 3;
            break;
        }
        return boost::uint8_t(reg);
    }
    

    void save_state(void){
        if (_state == NULL) _state = new tuner_4937di5_regs_t();
        _state->db1 = this->db1;
        _state->db2 = this->db2;
        _state->cb7 = this->cb7;
        _state->cp = this->cp;
        _state->os = this->os;
        _state->rs = this->rs;
        _state->test = this->test;
        _state->bandsel = this->bandsel;
        _state->power = this->power;
    }

    template<typename T> std::set<T> get_changed_addrs(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if(_state->db1 != this->db1){
            addrs.insert(0);
        }
        if(_state->db2 != this->db2){
            addrs.insert(1);
        }
        if(_state->cb7 != this->cb7){
            addrs.insert(2);
        }
        if(_state->cp != this->cp){
            addrs.insert(2);
        }
        if(_state->os != this->os){
            addrs.insert(2);
        }
        if(_state->rs != this->rs){
            addrs.insert(2);
        }
        if(_state->test != this->test){
            addrs.insert(2);
        }
        if(_state->bandsel != this->bandsel){
            addrs.insert(3);
        }
        if(_state->power != this->power){
            addrs.insert(3);
        }
        return addrs;
    }

private:
    tuner_4937di5_regs_t *_state;
};

#endif /* INCLUDED_TUNER_4937DI5_REGS_HPP */
