---------------------------------------------------------------------------------------
-- Title          : Wishbone slave core for WR Endpoint 1000base-X TBI PCS register block
---------------------------------------------------------------------------------------
-- File           : ep_pcs_tbi_mdio_wb.vhd
-- Author         : auto-generated by wbgen2 from pcs_regs.wb
-- Created        : Wed Aug 16 22:43:42 2017
-- Standard       : VHDL'87
---------------------------------------------------------------------------------------
-- THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE pcs_regs.wb
-- DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!
---------------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity ep_pcs_tbi_mdio_wb is
  port (
    rst_n_i                                  : in     std_logic;
    clk_sys_i                                : in     std_logic;
    wb_adr_i                                 : in     std_logic_vector(4 downto 0);
    wb_dat_i                                 : in     std_logic_vector(31 downto 0);
    wb_dat_o                                 : out    std_logic_vector(31 downto 0);
    wb_cyc_i                                 : in     std_logic;
    wb_sel_i                                 : in     std_logic_vector(3 downto 0);
    wb_stb_i                                 : in     std_logic;
    wb_we_i                                  : in     std_logic;
    wb_ack_o                                 : out    std_logic;
    wb_stall_o                               : out    std_logic;
    tx_clk_i                                 : in     std_logic;
    rx_clk_i                                 : in     std_logic;
-- Port for BIT field: 'Unidirectional Enable' in reg: 'MDIO Control Register'
    mdio_mcr_uni_en_o                        : out    std_logic;
-- Port for MONOSTABLE field: 'Restart Auto-Negotiation' in reg: 'MDIO Control Register'
    mdio_mcr_anrestart_o                     : out    std_logic;
-- Port for BIT field: 'Power Down' in reg: 'MDIO Control Register'
    mdio_mcr_pdown_o                         : out    std_logic;
-- Port for BIT field: 'Auto-Negotiation Enable' in reg: 'MDIO Control Register'
    mdio_mcr_anenable_o                      : out    std_logic;
-- Port for BIT field: 'Loopback' in reg: 'MDIO Control Register'
    mdio_mcr_loopback_o                      : out    std_logic;
-- Port for MONOSTABLE field: 'Reset' in reg: 'MDIO Control Register'
    mdio_mcr_reset_o                         : out    std_logic;
-- Port for BIT field: 'Link Status' in reg: 'MDIO Status Register'
    mdio_msr_lstatus_i                       : in     std_logic;
    lstat_read_notify_o                      : out    std_logic;
-- Port for BIT field: 'Remote Fault' in reg: 'MDIO Status Register'
    mdio_msr_rfault_i                        : in     std_logic;
-- Port for BIT field: 'Auto-Negotiation Complete' in reg: 'MDIO Status Register'
    mdio_msr_anegcomplete_i                  : in     std_logic;
-- Port for std_logic_vector field: 'Pause' in reg: 'MDIO Auto-Negotiation Advertisement Register'
    mdio_advertise_pause_o                   : out    std_logic_vector(1 downto 0);
-- Port for std_logic_vector field: 'Remote Fault' in reg: 'MDIO Auto-Negotiation Advertisement Register'
    mdio_advertise_rfault_o                  : out    std_logic_vector(1 downto 0);
-- Port for BIT field: 'Full Duplex' in reg: 'MDIO Auto-Negotiation Link Partner Ability Register'
    mdio_lpa_full_i                          : in     std_logic;
-- Port for BIT field: 'Half Duplex' in reg: 'MDIO Auto-Negotiation Link Partner Ability Register'
    mdio_lpa_half_i                          : in     std_logic;
-- Port for std_logic_vector field: 'Pause' in reg: 'MDIO Auto-Negotiation Link Partner Ability Register'
    mdio_lpa_pause_i                         : in     std_logic_vector(1 downto 0);
-- Port for std_logic_vector field: 'Remote Fault' in reg: 'MDIO Auto-Negotiation Link Partner Ability Register'
    mdio_lpa_rfault_i                        : in     std_logic_vector(1 downto 0);
-- Port for BIT field: 'Acknowledge' in reg: 'MDIO Auto-Negotiation Link Partner Ability Register'
    mdio_lpa_lpack_i                         : in     std_logic;
-- Port for BIT field: 'Next Page' in reg: 'MDIO Auto-Negotiation Link Partner Ability Register'
    mdio_lpa_npage_i                         : in     std_logic;
-- Port for asynchronous (clock: tx_clk_i) BIT field: 'TX Calibration Pattern' in reg: 'WhiteRabbit-specific Configuration Register'
    mdio_wr_spec_tx_cal_o                    : out    std_logic;
-- Port for asynchronous (clock: rx_clk_i) BIT field: 'Calibration Pattern RX Status' in reg: 'WhiteRabbit-specific Configuration Register'
    mdio_wr_spec_rx_cal_stat_i               : in     std_logic;
-- Port for asynchronous (clock: rx_clk_i) MONOSTABLE field: 'Reset calibration counter' in reg: 'WhiteRabbit-specific Configuration Register'
    mdio_wr_spec_cal_crst_o                  : out    std_logic;
-- Port for asynchronous (clock: rx_clk_i) std_logic_vector field: 'GTP RX Bitslide' in reg: 'WhiteRabbit-specific Configuration Register'
    mdio_wr_spec_bslide_i                    : in     std_logic_vector(4 downto 0);
-- Port for std_logic_vector field: 'Loopback - detailed' in reg: 'MDIO Extended Control Register'
    mdio_ectrl_lpbck_vec_o                   : out    std_logic_vector(2 downto 0);
-- Port for BIT field: 'SFP TX Fault Status' in reg: 'MDIO Extended Control Register'
    mdio_ectrl_sfp_tx_fault_i                : in     std_logic;
-- Port for BIT field: 'SFP LOS' in reg: 'MDIO Extended Control Register'
    mdio_ectrl_sfp_loss_i                    : in     std_logic;
-- Port for BIT field: 'SFP TX Disable' in reg: 'MDIO Extended Control Register'
    mdio_ectrl_sfp_tx_disable_o              : out    std_logic;
-- Port for std_logic_vector field: 'tx_prbs_sel' in reg: 'MDIO Extended Control Register'
    mdio_ectrl_tx_prbs_sel_o                 : out    std_logic_vector(2 downto 0)
  );
end ep_pcs_tbi_mdio_wb;

architecture syn of ep_pcs_tbi_mdio_wb is

signal mdio_mcr_uni_en_int                      : std_logic      ;
signal mdio_mcr_anrestart_dly0                  : std_logic      ;
signal mdio_mcr_anrestart_int                   : std_logic      ;
signal mdio_mcr_pdown_int                       : std_logic      ;
signal mdio_mcr_anenable_int                    : std_logic      ;
signal mdio_mcr_loopback_int                    : std_logic      ;
signal mdio_mcr_reset_dly0                      : std_logic      ;
signal mdio_mcr_reset_int                       : std_logic      ;
signal mdio_advertise_pause_int                 : std_logic_vector(1 downto 0);
signal mdio_advertise_rfault_int                : std_logic_vector(1 downto 0);
signal mdio_wr_spec_tx_cal_int                  : std_logic      ;
signal mdio_wr_spec_tx_cal_sync0                : std_logic      ;
signal mdio_wr_spec_tx_cal_sync1                : std_logic      ;
signal mdio_wr_spec_rx_cal_stat_sync0           : std_logic      ;
signal mdio_wr_spec_rx_cal_stat_sync1           : std_logic      ;
signal mdio_wr_spec_cal_crst_int                : std_logic      ;
signal mdio_wr_spec_cal_crst_int_delay          : std_logic      ;
signal mdio_wr_spec_cal_crst_sync0              : std_logic      ;
signal mdio_wr_spec_cal_crst_sync1              : std_logic      ;
signal mdio_wr_spec_cal_crst_sync2              : std_logic      ;
signal mdio_wr_spec_bslide_int                  : std_logic_vector(4 downto 0);
signal mdio_wr_spec_bslide_lwb                  : std_logic      ;
signal mdio_wr_spec_bslide_lwb_delay            : std_logic      ;
signal mdio_wr_spec_bslide_lwb_in_progress      : std_logic      ;
signal mdio_wr_spec_bslide_lwb_s0               : std_logic      ;
signal mdio_wr_spec_bslide_lwb_s1               : std_logic      ;
signal mdio_wr_spec_bslide_lwb_s2               : std_logic      ;
signal mdio_ectrl_lpbck_vec_int                 : std_logic_vector(2 downto 0);
signal mdio_ectrl_sfp_tx_disable_int            : std_logic      ;
signal mdio_ectrl_tx_prbs_sel_int               : std_logic_vector(2 downto 0);
signal ack_sreg                                 : std_logic_vector(9 downto 0);
signal rddata_reg                               : std_logic_vector(31 downto 0);
signal wrdata_reg                               : std_logic_vector(31 downto 0);
signal rwaddr_reg                               : std_logic_vector(4 downto 0);
signal ack_in_progress                          : std_logic      ;

begin
-- Some internal signals assignments
  wrdata_reg <= wb_dat_i;
-- 
-- Main register bank access process.
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ack_sreg <= "0000000000";
      ack_in_progress <= '0';
      rddata_reg <= "00000000000000000000000000000000";
      mdio_mcr_uni_en_int <= '0';
      mdio_mcr_anrestart_int <= '0';
      mdio_mcr_pdown_int <= '0';
      mdio_mcr_anenable_int <= '0';
      mdio_mcr_loopback_int <= '0';
      mdio_mcr_reset_int <= '0';
      lstat_read_notify_o <= '0';
      mdio_advertise_pause_int <= "00";
      mdio_advertise_rfault_int <= "00";
      mdio_wr_spec_tx_cal_int <= '0';
      mdio_wr_spec_cal_crst_int <= '0';
      mdio_wr_spec_cal_crst_int_delay <= '0';
      mdio_wr_spec_bslide_lwb <= '0';
      mdio_wr_spec_bslide_lwb_delay <= '0';
      mdio_wr_spec_bslide_lwb_in_progress <= '0';
      mdio_ectrl_lpbck_vec_int <= "000";
      mdio_ectrl_sfp_tx_disable_int <= '0';
      mdio_ectrl_tx_prbs_sel_int <= "000";
    elsif rising_edge(clk_sys_i) then
-- advance the ACK generator shift register
      ack_sreg(8 downto 0) <= ack_sreg(9 downto 1);
      ack_sreg(9) <= '0';
      if (ack_in_progress = '1') then
        if (ack_sreg(0) = '1') then
          mdio_mcr_anrestart_int <= '0';
          mdio_mcr_reset_int <= '0';
          lstat_read_notify_o <= '0';
          ack_in_progress <= '0';
        else
          mdio_wr_spec_cal_crst_int <= mdio_wr_spec_cal_crst_int_delay;
          mdio_wr_spec_cal_crst_int_delay <= '0';
          mdio_wr_spec_bslide_lwb <= mdio_wr_spec_bslide_lwb_delay;
          mdio_wr_spec_bslide_lwb_delay <= '0';
          if ((ack_sreg(1) = '1') and (mdio_wr_spec_bslide_lwb_in_progress = '1')) then
            rddata_reg(8 downto 4) <= mdio_wr_spec_bslide_int;
            mdio_wr_spec_bslide_lwb_in_progress <= '0';
          end if;
        end if;
      else
        if ((wb_cyc_i = '1') and (wb_stb_i = '1')) then
          case rwaddr_reg(4 downto 0) is
          when "00000" => 
            if (wb_we_i = '1') then
              mdio_mcr_uni_en_int <= wrdata_reg(5);
              mdio_mcr_anrestart_int <= wrdata_reg(9);
              mdio_mcr_pdown_int <= wrdata_reg(11);
              mdio_mcr_anenable_int <= wrdata_reg(12);
              mdio_mcr_loopback_int <= wrdata_reg(14);
              mdio_mcr_reset_int <= wrdata_reg(15);
            end if;
            rddata_reg(4 downto 0) <= "00000";
            rddata_reg(5) <= mdio_mcr_uni_en_int;
            rddata_reg(6) <= '1';
            rddata_reg(7) <= '0';
            rddata_reg(8) <= '1';
            rddata_reg(9) <= '0';
            rddata_reg(10) <= '0';
            rddata_reg(11) <= mdio_mcr_pdown_int;
            rddata_reg(12) <= mdio_mcr_anenable_int;
            rddata_reg(13) <= '0';
            rddata_reg(14) <= mdio_mcr_loopback_int;
            rddata_reg(15) <= '0';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(2) <= '1';
            ack_in_progress <= '1';
          when "00001" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(0) <= '0';
            rddata_reg(1) <= '0';
            rddata_reg(2) <= mdio_msr_lstatus_i;
            lstat_read_notify_o <= '1';
            rddata_reg(3) <= '1';
            rddata_reg(4) <= mdio_msr_rfault_i;
            rddata_reg(5) <= mdio_msr_anegcomplete_i;
            rddata_reg(6) <= '0';
            rddata_reg(7) <= '1';
            rddata_reg(8) <= '1';
            rddata_reg(9) <= '0';
            rddata_reg(10) <= '0';
            rddata_reg(11) <= '0';
            rddata_reg(12) <= '0';
            rddata_reg(13) <= '0';
            rddata_reg(14) <= '0';
            rddata_reg(15) <= '0';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00010" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(15 downto 0) <= "0000000000000000";
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00011" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(3 downto 0) <= "0000";
            rddata_reg(9 downto 4) <= "000000";
            rddata_reg(15 downto 10) <= "000000";
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00100" => 
            if (wb_we_i = '1') then
              mdio_advertise_pause_int <= wrdata_reg(8 downto 7);
              mdio_advertise_rfault_int <= wrdata_reg(13 downto 12);
            end if;
            rddata_reg(4 downto 0) <= "00000";
            rddata_reg(5) <= '1';
            rddata_reg(6) <= '0';
            rddata_reg(8 downto 7) <= mdio_advertise_pause_int;
            rddata_reg(11 downto 9) <= "000";
            rddata_reg(13 downto 12) <= mdio_advertise_rfault_int;
            rddata_reg(14) <= '0';
            rddata_reg(15) <= '0';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00101" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(4 downto 0) <= "00000";
            rddata_reg(5) <= mdio_lpa_full_i;
            rddata_reg(6) <= mdio_lpa_half_i;
            rddata_reg(8 downto 7) <= mdio_lpa_pause_i;
            rddata_reg(11 downto 9) <= "000";
            rddata_reg(13 downto 12) <= mdio_lpa_rfault_i;
            rddata_reg(14) <= mdio_lpa_lpack_i;
            rddata_reg(15) <= mdio_lpa_npage_i;
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00110" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(0) <= '0';
            rddata_reg(1) <= '0';
            rddata_reg(2) <= '0';
            rddata_reg(15 downto 3) <= "0000000000000";
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01111" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(11 downto 0) <= "000000000000";
            rddata_reg(12) <= '0';
            rddata_reg(13) <= '0';
            rddata_reg(14) <= '0';
            rddata_reg(15) <= '1';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10000" => 
            if (wb_we_i = '1') then
              mdio_wr_spec_tx_cal_int <= wrdata_reg(0);
              mdio_wr_spec_cal_crst_int <= wrdata_reg(2);
              mdio_wr_spec_cal_crst_int_delay <= wrdata_reg(2);
            end if;
            rddata_reg(0) <= mdio_wr_spec_tx_cal_int;
            rddata_reg(1) <= mdio_wr_spec_rx_cal_stat_sync1;
            rddata_reg(2) <= '0';
            if (wb_we_i = '0') then
              mdio_wr_spec_bslide_lwb <= '1';
              mdio_wr_spec_bslide_lwb_delay <= '1';
              mdio_wr_spec_bslide_lwb_in_progress <= '1';
            end if;
            rddata_reg(3) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(5) <= '1';
            ack_in_progress <= '1';
          when "10001" => 
            if (wb_we_i = '1') then
              mdio_ectrl_lpbck_vec_int <= wrdata_reg(2 downto 0);
              mdio_ectrl_sfp_tx_disable_int <= wrdata_reg(5);
              mdio_ectrl_tx_prbs_sel_int <= wrdata_reg(10 downto 8);
            end if;
            rddata_reg(2 downto 0) <= mdio_ectrl_lpbck_vec_int;
            rddata_reg(3) <= mdio_ectrl_sfp_tx_fault_i;
            rddata_reg(4) <= mdio_ectrl_sfp_loss_i;
            rddata_reg(5) <= mdio_ectrl_sfp_tx_disable_int;
            rddata_reg(10 downto 8) <= mdio_ectrl_tx_prbs_sel_int;
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when others =>
-- prevent the slave from hanging the bus on invalid address
            ack_in_progress <= '1';
            ack_sreg(0) <= '1';
          end case;
        end if;
      end if;
    end if;
  end process;
  
  
-- Drive the data output bus
  wb_dat_o <= rddata_reg;
-- Unidirectional Enable
  mdio_mcr_uni_en_o <= mdio_mcr_uni_en_int;
-- Restart Auto-Negotiation
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      mdio_mcr_anrestart_dly0 <= '0';
      mdio_mcr_anrestart_o <= '0';
    elsif rising_edge(clk_sys_i) then
      mdio_mcr_anrestart_dly0 <= mdio_mcr_anrestart_int;
      mdio_mcr_anrestart_o <= mdio_mcr_anrestart_int and (not mdio_mcr_anrestart_dly0);
    end if;
  end process;
  
  
-- Power Down
  mdio_mcr_pdown_o <= mdio_mcr_pdown_int;
-- Auto-Negotiation Enable
  mdio_mcr_anenable_o <= mdio_mcr_anenable_int;
-- Loopback
  mdio_mcr_loopback_o <= mdio_mcr_loopback_int;
-- Reset
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      mdio_mcr_reset_dly0 <= '0';
      mdio_mcr_reset_o <= '0';
    elsif rising_edge(clk_sys_i) then
      mdio_mcr_reset_dly0 <= mdio_mcr_reset_int;
      mdio_mcr_reset_o <= mdio_mcr_reset_int and (not mdio_mcr_reset_dly0);
    end if;
  end process;
  
  
-- Link Status
-- Remote Fault
-- Auto-Negotiation Complete
-- Pause
  mdio_advertise_pause_o <= mdio_advertise_pause_int;
-- Remote Fault
  mdio_advertise_rfault_o <= mdio_advertise_rfault_int;
-- Full Duplex
-- Half Duplex
-- Pause
-- Remote Fault
-- Acknowledge
-- Next Page
-- TX Calibration Pattern
-- synchronizer chain for field : TX Calibration Pattern (type RW/RO, clk_sys_i <-> tx_clk_i)
  process (tx_clk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      mdio_wr_spec_tx_cal_o <= '0';
      mdio_wr_spec_tx_cal_sync0 <= '0';
      mdio_wr_spec_tx_cal_sync1 <= '0';
    elsif rising_edge(tx_clk_i) then
      mdio_wr_spec_tx_cal_sync0 <= mdio_wr_spec_tx_cal_int;
      mdio_wr_spec_tx_cal_sync1 <= mdio_wr_spec_tx_cal_sync0;
      mdio_wr_spec_tx_cal_o <= mdio_wr_spec_tx_cal_sync1;
    end if;
  end process;
  
  
-- Calibration Pattern RX Status
-- synchronizer chain for field : Calibration Pattern RX Status (type RO/WO, rx_clk_i -> clk_sys_i)
  process (rx_clk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      mdio_wr_spec_rx_cal_stat_sync0 <= '0';
      mdio_wr_spec_rx_cal_stat_sync1 <= '0';
    elsif rising_edge(rx_clk_i) then
      mdio_wr_spec_rx_cal_stat_sync0 <= mdio_wr_spec_rx_cal_stat_i;
      mdio_wr_spec_rx_cal_stat_sync1 <= mdio_wr_spec_rx_cal_stat_sync0;
    end if;
  end process;
  
  
-- Reset calibration counter
  process (rx_clk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      mdio_wr_spec_cal_crst_o <= '0';
      mdio_wr_spec_cal_crst_sync0 <= '0';
      mdio_wr_spec_cal_crst_sync1 <= '0';
      mdio_wr_spec_cal_crst_sync2 <= '0';
    elsif rising_edge(rx_clk_i) then
      mdio_wr_spec_cal_crst_sync0 <= mdio_wr_spec_cal_crst_int;
      mdio_wr_spec_cal_crst_sync1 <= mdio_wr_spec_cal_crst_sync0;
      mdio_wr_spec_cal_crst_sync2 <= mdio_wr_spec_cal_crst_sync1;
      mdio_wr_spec_cal_crst_o <= mdio_wr_spec_cal_crst_sync2 and (not mdio_wr_spec_cal_crst_sync1);
    end if;
  end process;
  
  
-- GTP RX Bitslide
-- asynchronous std_logic_vector register : GTP RX Bitslide (type RO/WO, rx_clk_i <-> clk_sys_i)
  process (rx_clk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      mdio_wr_spec_bslide_lwb_s0 <= '0';
      mdio_wr_spec_bslide_lwb_s1 <= '0';
      mdio_wr_spec_bslide_lwb_s2 <= '0';
      mdio_wr_spec_bslide_int <= "00000";
    elsif rising_edge(rx_clk_i) then
      mdio_wr_spec_bslide_lwb_s0 <= mdio_wr_spec_bslide_lwb;
      mdio_wr_spec_bslide_lwb_s1 <= mdio_wr_spec_bslide_lwb_s0;
      mdio_wr_spec_bslide_lwb_s2 <= mdio_wr_spec_bslide_lwb_s1;
      if ((mdio_wr_spec_bslide_lwb_s1 = '1') and (mdio_wr_spec_bslide_lwb_s2 = '0')) then
        mdio_wr_spec_bslide_int <= mdio_wr_spec_bslide_i;
      end if;
    end if;
  end process;
  
  
-- Loopback - detailed
  mdio_ectrl_lpbck_vec_o <= mdio_ectrl_lpbck_vec_int;
-- SFP TX Fault Status
-- SFP LOS
-- SFP TX Disable
  mdio_ectrl_sfp_tx_disable_o <= mdio_ectrl_sfp_tx_disable_int;
-- tx_prbs_sel
  mdio_ectrl_tx_prbs_sel_o <= mdio_ectrl_tx_prbs_sel_int;
  rwaddr_reg <= wb_adr_i;
  wb_stall_o <= (not ack_sreg(0)) and (wb_stb_i and wb_cyc_i);
-- ACK signal generation. Just pass the LSB of ACK counter.
  wb_ack_o <= ack_sreg(0);
end syn;
