/***********************************************************************
 * This file was generated by /root/uhddev/host/lib/ic_reg_maps/gen_ad9862_regs.py on Fri Sep  6 06:41:44 2013
 **********************************************************************/

#ifndef INCLUDED_AD9862_REGS_HPP
#define INCLUDED_AD9862_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <boost/cstdint.hpp>
#include <set>

class ad9862_regs_t{
public:
    enum sdio_bidir_t{
        SDIO_BIDIR_SDIO_SDO = 0,
        SDIO_BIDIR_SDIO = 1
    };
    sdio_bidir_t sdio_bidir;
    enum lsb_first_t{
        LSB_FIRST_MSB = 0,
        LSB_FIRST_LSB = 1
    };
    lsb_first_t lsb_first;
    boost::uint8_t soft_reset;
    boost::uint8_t vref_diff_pd;
    boost::uint8_t vref_pd;
    boost::uint8_t rx_digital_pd;
    boost::uint8_t rx_channel_b_pd;
    boost::uint8_t rx_channel_a_pd;
    boost::uint8_t buffer_b_pd;
    boost::uint8_t buffer_a_pd;
    boost::uint8_t all_rx_pd;
    boost::uint8_t byp_buffer_a;
    boost::uint8_t rx_pga_a;
    boost::uint8_t byp_buffer_b;
    boost::uint8_t rx_pga_b;
    boost::uint8_t hs_duty_cycle;
    boost::uint8_t shared_ref;
    boost::uint8_t clk_duty;
    boost::uint8_t three_state;
    enum rx_retime_t{
        RX_RETIME_CLKOUT1 = 0,
        RX_RETIME_CLKOUT2 = 1
    };
    rx_retime_t rx_retime;
    boost::uint8_t rx_twos_comp;
    boost::uint8_t inv_rxsync;
    enum mux_out_t{
        MUX_OUT_RX_MUX_MODE = 1,
        MUX_OUT_DUAL_PORT_MODE = 0
    };
    mux_out_t mux_out;
    enum two_channel_t{
        TWO_CHANNEL_RX_B_DIS = 0,
        TWO_CHANNEL_BOTH_ENB = 1
    };
    two_channel_t two_channel;
    enum rx_keep_ve_t{
        RX_KEEP_VE_PASS_POS = 0,
        RX_KEEP_VE_PASS_NEG = 1
    };
    rx_keep_ve_t rx_keep_ve;
    enum rx_hilbert_t{
        RX_HILBERT_DIS = 0,
        RX_HILBERT_ENB = 1
    };
    rx_hilbert_t rx_hilbert;
    enum decimate_t{
        DECIMATE_DIS = 0,
        DECIMATE_ENB = 1
    };
    decimate_t decimate;
    boost::uint8_t alt_timing_mode;
    boost::uint8_t txoff_enable;
    boost::uint8_t tx_digital_pd;
    enum tx_analog_pd_t{
        TX_ANALOG_PD_NONE = 0,
        TX_ANALOG_PD_TXB = 4,
        TX_ANALOG_PD_TXA = 2,
        TX_ANALOG_PD_BOTH = 7
    };
    tx_analog_pd_t tx_analog_pd;
    boost::uint8_t dac_a_offset_1_0;
    enum dac_a_offset_dir_t{
        DAC_A_OFFSET_DIR_NEG_DIFF = 0,
        DAC_A_OFFSET_DIR_POS_DIF = 1
    };
    dac_a_offset_dir_t dac_a_offset_dir;
    boost::uint8_t dac_a_offset_9_2;
    boost::uint8_t dac_a_coarse_gain;
    boost::uint8_t dac_a_fine_gain;
    boost::uint8_t dac_b_offset_1_0;
    enum dac_b_offset_dir_t{
        DAC_B_OFFSET_DIR_NEG_DIFF = 0,
        DAC_B_OFFSET_DIR_POS_DIF = 1
    };
    dac_b_offset_dir_t dac_b_offset_dir;
    boost::uint8_t dac_b_offset_9_2;
    boost::uint8_t dac_b_coarse_gain;
    boost::uint8_t dac_b_fine_gain;
    boost::uint8_t tx_pga_gain;
    boost::uint8_t tx_slave_enable;
    enum tx_pga_mode_t{
        TX_PGA_MODE_NORMAL = 0,
        TX_PGA_MODE_FAST = 1
    };
    tx_pga_mode_t tx_pga_mode;
    enum tx_retime_t{
        TX_RETIME_CLKOUT1 = 1,
        TX_RETIME_CLKOUT2 = 0
    };
    tx_retime_t tx_retime;
    enum qi_order_t{
        QI_ORDER_IQ = 0,
        QI_ORDER_QI = 1
    };
    qi_order_t qi_order;
    boost::uint8_t inv_txsync;
    boost::uint8_t tx_twos_comp;
    enum inverse_samp_t{
        INVERSE_SAMP_RISE = 0,
        INVERSE_SAMP_FALL = 1
    };
    inverse_samp_t inverse_samp;
    enum edges_t{
        EDGES_NORMAL = 0,
        EDGES_BOTH = 1
    };
    edges_t edges;
    enum interleaved_t{
        INTERLEAVED_SINGLE = 0,
        INTERLEAVED_INTERLEAVED = 1
    };
    interleaved_t interleaved;
    enum two_data_paths_t{
        TWO_DATA_PATHS_SINGLE = 0,
        TWO_DATA_PATHS_BOTH = 1
    };
    two_data_paths_t two_data_paths;
    enum tx_keep_ve_t{
        TX_KEEP_VE_PASS_POS = 0,
        TX_KEEP_VE_PASS_NEG = 1
    };
    tx_keep_ve_t tx_keep_ve;
    enum tx_hilbert_t{
        TX_HILBERT_DIS = 0,
        TX_HILBERT_ENB = 1
    };
    tx_hilbert_t tx_hilbert;
    enum interp_t{
        INTERP_1 = 0,
        INTERP_2 = 1,
        INTERP_4 = 2
    };
    interp_t interp;
    enum neg_fine_tune_t{
        NEG_FINE_TUNE_POS_SHIFT = 0,
        NEG_FINE_TUNE_NEG_SHIFT = 1
    };
    neg_fine_tune_t neg_fine_tune;
    enum fine_mode_t{
        FINE_MODE_BYPASS = 0,
        FINE_MODE_NCO = 1
    };
    fine_mode_t fine_mode;
    enum real_mix_mode_t{
        REAL_MIX_MODE_COMPLEX = 0,
        REAL_MIX_MODE_REAL = 1
    };
    real_mix_mode_t real_mix_mode;
    enum neg_coarse_tune_t{
        NEG_COARSE_TUNE_POS_SHIFT = 0,
        NEG_COARSE_TUNE_NEG_SHIFT = 1
    };
    neg_coarse_tune_t neg_coarse_tune;
    enum coarse_mod_t{
        COARSE_MOD_BYPASS = 0,
        COARSE_MOD_FDAC_4 = 1,
        COARSE_MOD_FDAC_8 = 2
    };
    coarse_mod_t coarse_mod;
    boost::uint8_t ftw_7_0;
    boost::uint8_t ftw_15_8;
    boost::uint8_t ftw_23_16;
    enum input_clk_ctrl_t{
        INPUT_CLK_CTRL_INTERNAL = 0,
        INPUT_CLK_CTRL_EXTERNAL = 1
    };
    input_clk_ctrl_t input_clk_ctrl;
    enum adc_div2_t{
        ADC_DIV2_NORMAL = 0,
        ADC_DIV2_DIV2 = 1
    };
    adc_div2_t adc_div2;
    enum dll_mult_t{
        DLL_MULT_1 = 0,
        DLL_MULT_2 = 1,
        DLL_MULT_4 = 2
    };
    dll_mult_t dll_mult;
    boost::uint8_t dll_pd;
    enum dll_mode_t{
        DLL_MODE_SLOW = 0,
        DLL_MODE_FAST = 1
    };
    dll_mode_t dll_mode;
    enum clkout2_div_factor_t{
        CLKOUT2_DIV_FACTOR_1 = 0,
        CLKOUT2_DIV_FACTOR_2 = 1,
        CLKOUT2_DIV_FACTOR_4 = 2,
        CLKOUT2_DIV_FACTOR_8 = 3
    };
    clkout2_div_factor_t clkout2_div_factor;
    enum inv2_t{
        INV2_NORMAL = 0,
        INV2_INVERTED = 1
    };
    inv2_t inv2;
    enum inv1_t{
        INV1_NORMAL = 0,
        INV1_INVERTED = 1
    };
    inv1_t inv1;
    enum dis2_t{
        DIS2_ENB = 0,
        DIS2_DIS = 1
    };
    dis2_t dis2;
    enum dis1_t{
        DIS1_ENB = 0,
        DIS1_DIS = 1
    };
    dis1_t dis1;
    boost::uint8_t aux_adc_a2_1_0;
    boost::uint8_t aux_adc_a2_9_2;
    boost::uint8_t aux_adc_a1_1_0;
    boost::uint8_t aux_adc_a1_9_2;
    boost::uint8_t aux_adc_b2_1_0;
    boost::uint8_t aux_adc_b2_9_2;
    boost::uint8_t aux_adc_b1_1_0;
    boost::uint8_t aux_adc_b1_9_2;
    enum aux_spi_t{
        AUX_SPI_DIS = 0,
        AUX_SPI_ENB = 1
    };
    aux_spi_t aux_spi;
    enum sel_bnota_t{
        SEL_BNOTA_ADC_A = 0,
        SEL_BNOTA_ADC_B = 1
    };
    sel_bnota_t sel_bnota;
    enum refsel_b_t{
        REFSEL_B_EXTERNAL = 0,
        REFSEL_B_INTERNAL = 1
    };
    refsel_b_t refsel_b;
    enum select_b_t{
        SELECT_B_AUX_ADC2 = 0,
        SELECT_B_AUX_ADC1 = 1
    };
    select_b_t select_b;
    boost::uint8_t start_b;
    enum refsel_a_t{
        REFSEL_A_EXTERNAL = 0,
        REFSEL_A_INTERNAL = 1
    };
    refsel_a_t refsel_a;
    enum select_a_t{
        SELECT_A_AUX_ADC2 = 0,
        SELECT_A_AUX_ADC1 = 1
    };
    select_a_t select_a;
    boost::uint8_t start_a;
    enum clk_4_t{
        CLK_4_1_2 = 0,
        CLK_4_1_4 = 1
    };
    clk_4_t clk_4;
    boost::uint8_t aux_dac_a;
    boost::uint8_t aux_dac_b;
    boost::uint8_t aux_dac_c;
    boost::uint8_t aux_dac_slave_enable;
    boost::uint8_t aux_dacupdate_c;
    boost::uint8_t aux_dacupdate_b;
    boost::uint8_t aux_dacupdate_a;
    boost::uint8_t aux_dac_pd_a;
    boost::uint8_t aux_dac_pd_b;
    boost::uint8_t aux_dac_pd_c;
    boost::uint8_t aux_dac_invert_a;
    boost::uint8_t aux_dac_invert_b;
    boost::uint8_t aux_dac_invert_c;
    boost::uint8_t sig_delt_3_0;
    boost::uint8_t sig_delt_11_4;
    boost::uint8_t rx_low_power_mode_r49;
    boost::uint8_t rx_low_power_mode_r50;
    boost::uint8_t chip_id;

    ad9862_regs_t(void){
        _state = NULL;
        sdio_bidir = SDIO_BIDIR_SDIO_SDO;
        lsb_first = LSB_FIRST_MSB;
        soft_reset = 0;
        vref_diff_pd = 0;
        vref_pd = 0;
        rx_digital_pd = 0;
        rx_channel_b_pd = 0;
        rx_channel_a_pd = 0;
        buffer_b_pd = 0;
        buffer_a_pd = 0;
        all_rx_pd = 0;
        byp_buffer_a = 0;
        rx_pga_a = 0;
        byp_buffer_b = 0;
        rx_pga_b = 0;
        hs_duty_cycle = 0;
        shared_ref = 0;
        clk_duty = 0;
        three_state = 0;
        rx_retime = RX_RETIME_CLKOUT1;
        rx_twos_comp = 0;
        inv_rxsync = 0;
        mux_out = MUX_OUT_DUAL_PORT_MODE;
        two_channel = TWO_CHANNEL_BOTH_ENB;
        rx_keep_ve = RX_KEEP_VE_PASS_POS;
        rx_hilbert = RX_HILBERT_DIS;
        decimate = DECIMATE_DIS;
        alt_timing_mode = 0;
        txoff_enable = 0;
        tx_digital_pd = 0;
        tx_analog_pd = TX_ANALOG_PD_NONE;
        dac_a_offset_1_0 = 0;
        dac_a_offset_dir = DAC_A_OFFSET_DIR_NEG_DIFF;
        dac_a_offset_9_2 = 0;
        dac_a_coarse_gain = 0;
        dac_a_fine_gain = 0;
        dac_b_offset_1_0 = 0;
        dac_b_offset_dir = DAC_B_OFFSET_DIR_NEG_DIFF;
        dac_b_offset_9_2 = 0;
        dac_b_coarse_gain = 0;
        dac_b_fine_gain = 0;
        tx_pga_gain = 0;
        tx_slave_enable = 0;
        tx_pga_mode = TX_PGA_MODE_NORMAL;
        tx_retime = TX_RETIME_CLKOUT1;
        qi_order = QI_ORDER_IQ;
        inv_txsync = 0;
        tx_twos_comp = 0;
        inverse_samp = INVERSE_SAMP_RISE;
        edges = EDGES_NORMAL;
        interleaved = INTERLEAVED_SINGLE;
        two_data_paths = TWO_DATA_PATHS_SINGLE;
        tx_keep_ve = TX_KEEP_VE_PASS_POS;
        tx_hilbert = TX_HILBERT_DIS;
        interp = INTERP_1;
        neg_fine_tune = NEG_FINE_TUNE_POS_SHIFT;
        fine_mode = FINE_MODE_BYPASS;
        real_mix_mode = REAL_MIX_MODE_COMPLEX;
        neg_coarse_tune = NEG_COARSE_TUNE_POS_SHIFT;
        coarse_mod = COARSE_MOD_BYPASS;
        ftw_7_0 = 0;
        ftw_15_8 = 0;
        ftw_23_16 = 0;
        input_clk_ctrl = INPUT_CLK_CTRL_INTERNAL;
        adc_div2 = ADC_DIV2_NORMAL;
        dll_mult = DLL_MULT_1;
        dll_pd = 0;
        dll_mode = DLL_MODE_SLOW;
        clkout2_div_factor = CLKOUT2_DIV_FACTOR_1;
        inv2 = INV2_NORMAL;
        inv1 = INV1_NORMAL;
        dis2 = DIS2_ENB;
        dis1 = DIS1_ENB;
        aux_adc_a2_1_0 = 0;
        aux_adc_a2_9_2 = 0;
        aux_adc_a1_1_0 = 0;
        aux_adc_a1_9_2 = 0;
        aux_adc_b2_1_0 = 0;
        aux_adc_b2_9_2 = 0;
        aux_adc_b1_1_0 = 0;
        aux_adc_b1_9_2 = 0;
        aux_spi = AUX_SPI_DIS;
        sel_bnota = SEL_BNOTA_ADC_A;
        refsel_b = REFSEL_B_EXTERNAL;
        select_b = SELECT_B_AUX_ADC2;
        start_b = 0;
        refsel_a = REFSEL_A_EXTERNAL;
        select_a = SELECT_A_AUX_ADC2;
        start_a = 0;
        clk_4 = CLK_4_1_2;
        aux_dac_a = 0;
        aux_dac_b = 0;
        aux_dac_c = 0;
        aux_dac_slave_enable = 0;
        aux_dacupdate_c = 0;
        aux_dacupdate_b = 0;
        aux_dacupdate_a = 0;
        aux_dac_pd_a = 0;
        aux_dac_pd_b = 0;
        aux_dac_pd_c = 0;
        aux_dac_invert_a = 0;
        aux_dac_invert_b = 0;
        aux_dac_invert_c = 0;
        sig_delt_3_0 = 0;
        sig_delt_11_4 = 0;
        rx_low_power_mode_r49 = 0;
        rx_low_power_mode_r50 = 0;
        chip_id = 0;
    }

    ~ad9862_regs_t(void){
        delete _state;
    }

    
    boost::uint8_t get_reg(boost::uint8_t addr){
        boost::uint8_t reg = 0;
        switch(addr){
        case 0:
            reg |= (boost::uint16_t(sdio_bidir) & 0x1) << 7;
            reg |= (boost::uint16_t(lsb_first) & 0x1) << 6;
            reg |= (boost::uint16_t(soft_reset) & 0x1) << 5;
            break;
        case 1:
            reg |= (boost::uint16_t(vref_diff_pd) & 0x1) << 7;
            reg |= (boost::uint16_t(vref_pd) & 0x1) << 6;
            reg |= (boost::uint16_t(rx_digital_pd) & 0x1) << 5;
            reg |= (boost::uint16_t(rx_channel_b_pd) & 0x1) << 4;
            reg |= (boost::uint16_t(rx_channel_a_pd) & 0x1) << 3;
            reg |= (boost::uint16_t(buffer_b_pd) & 0x1) << 2;
            reg |= (boost::uint16_t(buffer_a_pd) & 0x1) << 1;
            reg |= (boost::uint16_t(all_rx_pd) & 0x1) << 0;
            break;
        case 2:
            reg |= (boost::uint16_t(byp_buffer_a) & 0x1) << 7;
            reg |= (boost::uint16_t(rx_pga_a) & 0x1f) << 0;
            break;
        case 3:
            reg |= (boost::uint16_t(byp_buffer_b) & 0x1) << 7;
            reg |= (boost::uint16_t(rx_pga_b) & 0x1f) << 0;
            break;
        case 4:
            reg |= (boost::uint16_t(hs_duty_cycle) & 0x1) << 2;
            reg |= (boost::uint16_t(shared_ref) & 0x1) << 1;
            reg |= (boost::uint16_t(clk_duty) & 0x1) << 0;
            break;
        case 5:
            reg |= (boost::uint16_t(three_state) & 0x1) << 4;
            reg |= (boost::uint16_t(rx_retime) & 0x1) << 3;
            reg |= (boost::uint16_t(rx_twos_comp) & 0x1) << 2;
            reg |= (boost::uint16_t(inv_rxsync) & 0x1) << 1;
            reg |= (boost::uint16_t(mux_out) & 0x1) << 0;
            break;
        case 6:
            reg |= (boost::uint16_t(two_channel) & 0x1) << 3;
            reg |= (boost::uint16_t(rx_keep_ve) & 0x1) << 2;
            reg |= (boost::uint16_t(rx_hilbert) & 0x1) << 1;
            reg |= (boost::uint16_t(decimate) & 0x1) << 0;
            break;
        case 7:
            break;
        case 8:
            reg |= (boost::uint16_t(alt_timing_mode) & 0x1) << 5;
            reg |= (boost::uint16_t(txoff_enable) & 0x1) << 4;
            reg |= (boost::uint16_t(tx_digital_pd) & 0x1) << 3;
            reg |= (boost::uint16_t(tx_analog_pd) & 0x7) << 0;
            break;
        case 9:
            break;
        case 10:
            reg |= (boost::uint16_t(dac_a_offset_1_0) & 0x3) << 6;
            reg |= (boost::uint16_t(dac_a_offset_dir) & 0x1) << 0;
            break;
        case 11:
            reg |= (boost::uint16_t(dac_a_offset_9_2) & 0xff) << 0;
            break;
        case 12:
            reg |= (boost::uint16_t(dac_b_offset_1_0) & 0x3) << 6;
            reg |= (boost::uint16_t(dac_b_offset_dir) & 0x1) << 0;
            break;
        case 13:
            reg |= (boost::uint16_t(dac_b_offset_9_2) & 0xff) << 0;
            break;
        case 14:
            reg |= (boost::uint16_t(dac_a_coarse_gain) & 0x3) << 6;
            reg |= (boost::uint16_t(dac_a_fine_gain) & 0x3f) << 0;
            break;
        case 15:
            reg |= (boost::uint16_t(dac_b_coarse_gain) & 0x3) << 6;
            reg |= (boost::uint16_t(dac_b_fine_gain) & 0x3f) << 0;
            break;
        case 16:
            reg |= (boost::uint16_t(tx_pga_gain) & 0xff) << 0;
            break;
        case 17:
            reg |= (boost::uint16_t(tx_slave_enable) & 0x1) << 1;
            reg |= (boost::uint16_t(tx_pga_mode) & 0x1) << 0;
            break;
        case 18:
            reg |= (boost::uint16_t(tx_retime) & 0x1) << 6;
            reg |= (boost::uint16_t(qi_order) & 0x1) << 5;
            reg |= (boost::uint16_t(inv_txsync) & 0x1) << 4;
            reg |= (boost::uint16_t(tx_twos_comp) & 0x1) << 3;
            reg |= (boost::uint16_t(inverse_samp) & 0x1) << 2;
            reg |= (boost::uint16_t(edges) & 0x1) << 1;
            reg |= (boost::uint16_t(interleaved) & 0x1) << 0;
            break;
        case 19:
            reg |= (boost::uint16_t(two_data_paths) & 0x1) << 4;
            reg |= (boost::uint16_t(tx_keep_ve) & 0x1) << 3;
            reg |= (boost::uint16_t(tx_hilbert) & 0x1) << 2;
            reg |= (boost::uint16_t(interp) & 0x3) << 0;
            break;
        case 20:
            reg |= (boost::uint16_t(neg_fine_tune) & 0x1) << 5;
            reg |= (boost::uint16_t(fine_mode) & 0x1) << 4;
            reg |= (boost::uint16_t(real_mix_mode) & 0x1) << 3;
            reg |= (boost::uint16_t(neg_coarse_tune) & 0x1) << 2;
            reg |= (boost::uint16_t(coarse_mod) & 0x3) << 0;
            break;
        case 21:
            reg |= (boost::uint16_t(ftw_7_0) & 0xff) << 0;
            break;
        case 22:
            reg |= (boost::uint16_t(ftw_15_8) & 0xff) << 0;
            break;
        case 23:
            reg |= (boost::uint16_t(ftw_23_16) & 0xff) << 0;
            break;
        case 24:
            reg |= (boost::uint16_t(input_clk_ctrl) & 0x1) << 6;
            reg |= (boost::uint16_t(adc_div2) & 0x1) << 5;
            reg |= (boost::uint16_t(dll_mult) & 0x3) << 3;
            reg |= (boost::uint16_t(dll_pd) & 0x1) << 2;
            reg |= (boost::uint16_t(dll_mode) & 0x1) << 0;
            break;
        case 25:
            reg |= (boost::uint16_t(clkout2_div_factor) & 0x3) << 6;
            reg |= (boost::uint16_t(inv2) & 0x1) << 5;
            reg |= (boost::uint16_t(inv1) & 0x1) << 1;
            reg |= (boost::uint16_t(dis2) & 0x1) << 4;
            reg |= (boost::uint16_t(dis1) & 0x1) << 0;
            break;
        case 26:
            reg |= (boost::uint16_t(aux_adc_a2_1_0) & 0x3) << 6;
            break;
        case 27:
            reg |= (boost::uint16_t(aux_adc_a2_9_2) & 0xff) << 0;
            break;
        case 28:
            reg |= (boost::uint16_t(aux_adc_a1_1_0) & 0x3) << 6;
            break;
        case 29:
            reg |= (boost::uint16_t(aux_adc_a1_9_2) & 0xff) << 0;
            break;
        case 30:
            reg |= (boost::uint16_t(aux_adc_b2_1_0) & 0x3) << 6;
            break;
        case 31:
            reg |= (boost::uint16_t(aux_adc_b2_9_2) & 0xff) << 0;
            break;
        case 32:
            reg |= (boost::uint16_t(aux_adc_b1_1_0) & 0x3) << 6;
            break;
        case 33:
            reg |= (boost::uint16_t(aux_adc_b1_9_2) & 0xff) << 0;
            break;
        case 34:
            reg |= (boost::uint16_t(aux_spi) & 0x1) << 7;
            reg |= (boost::uint16_t(sel_bnota) & 0x1) << 6;
            reg |= (boost::uint16_t(refsel_b) & 0x1) << 5;
            reg |= (boost::uint16_t(select_b) & 0x1) << 4;
            reg |= (boost::uint16_t(start_b) & 0x1) << 3;
            reg |= (boost::uint16_t(refsel_a) & 0x1) << 2;
            reg |= (boost::uint16_t(select_a) & 0x1) << 1;
            reg |= (boost::uint16_t(start_a) & 0x1) << 0;
            break;
        case 35:
            reg |= (boost::uint16_t(clk_4) & 0x1) << 0;
            break;
        case 36:
            reg |= (boost::uint16_t(aux_dac_a) & 0xff) << 0;
            break;
        case 37:
            reg |= (boost::uint16_t(aux_dac_b) & 0xff) << 0;
            break;
        case 38:
            reg |= (boost::uint16_t(aux_dac_c) & 0xff) << 0;
            break;
        case 39:
            reg |= (boost::uint16_t(aux_dac_slave_enable) & 0x1) << 7;
            reg |= (boost::uint16_t(aux_dacupdate_c) & 0x1) << 2;
            reg |= (boost::uint16_t(aux_dacupdate_b) & 0x1) << 1;
            reg |= (boost::uint16_t(aux_dacupdate_a) & 0x1) << 0;
            break;
        case 40:
            reg |= (boost::uint16_t(aux_dac_pd_a) & 0x1) << 2;
            reg |= (boost::uint16_t(aux_dac_pd_b) & 0x1) << 1;
            reg |= (boost::uint16_t(aux_dac_pd_c) & 0x1) << 0;
            break;
        case 41:
            reg |= (boost::uint16_t(aux_dac_invert_a) & 0x1) << 2;
            reg |= (boost::uint16_t(aux_dac_invert_b) & 0x1) << 1;
            reg |= (boost::uint16_t(aux_dac_invert_c) & 0x1) << 0;
            break;
        case 42:
            reg |= (boost::uint16_t(sig_delt_3_0) & 0xf) << 4;
            break;
        case 43:
            reg |= (boost::uint16_t(sig_delt_11_4) & 0xff) << 0;
            break;
        case 44:
            break;
        case 45:
            break;
        case 46:
            break;
        case 47:
            break;
        case 48:
            break;
        case 49:
            reg |= (boost::uint16_t(rx_low_power_mode_r49) & 0xff) << 0;
            break;
        case 50:
            reg |= (boost::uint16_t(rx_low_power_mode_r50) & 0xff) << 0;
            break;
        case 51:
            break;
        case 52:
            break;
        case 53:
            break;
        case 54:
            break;
        case 55:
            break;
        case 56:
            break;
        case 57:
            break;
        case 58:
            break;
        case 59:
            break;
        case 60:
            break;
        case 61:
            break;
        case 62:
            break;
        case 63:
            reg |= (boost::uint16_t(chip_id) & 0xff) << 0;
            break;
        }
        return reg;
    }
    
    void set_reg(boost::uint8_t addr, boost::uint16_t reg){
        switch(addr){
        case 0:
            sdio_bidir = sdio_bidir_t((reg >> 7) & 0x1);
            lsb_first = lsb_first_t((reg >> 6) & 0x1);
            soft_reset = boost::uint8_t((reg >> 5) & 0x1);
            break;
        case 1:
            vref_diff_pd = boost::uint8_t((reg >> 7) & 0x1);
            vref_pd = boost::uint8_t((reg >> 6) & 0x1);
            rx_digital_pd = boost::uint8_t((reg >> 5) & 0x1);
            rx_channel_b_pd = boost::uint8_t((reg >> 4) & 0x1);
            rx_channel_a_pd = boost::uint8_t((reg >> 3) & 0x1);
            buffer_b_pd = boost::uint8_t((reg >> 2) & 0x1);
            buffer_a_pd = boost::uint8_t((reg >> 1) & 0x1);
            all_rx_pd = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 2:
            byp_buffer_a = boost::uint8_t((reg >> 7) & 0x1);
            rx_pga_a = boost::uint8_t((reg >> 0) & 0x1f);
            break;
        case 3:
            byp_buffer_b = boost::uint8_t((reg >> 7) & 0x1);
            rx_pga_b = boost::uint8_t((reg >> 0) & 0x1f);
            break;
        case 4:
            hs_duty_cycle = boost::uint8_t((reg >> 2) & 0x1);
            shared_ref = boost::uint8_t((reg >> 1) & 0x1);
            clk_duty = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 5:
            three_state = boost::uint8_t((reg >> 4) & 0x1);
            rx_retime = rx_retime_t((reg >> 3) & 0x1);
            rx_twos_comp = boost::uint8_t((reg >> 2) & 0x1);
            inv_rxsync = boost::uint8_t((reg >> 1) & 0x1);
            mux_out = mux_out_t((reg >> 0) & 0x1);
            break;
        case 6:
            two_channel = two_channel_t((reg >> 3) & 0x1);
            rx_keep_ve = rx_keep_ve_t((reg >> 2) & 0x1);
            rx_hilbert = rx_hilbert_t((reg >> 1) & 0x1);
            decimate = decimate_t((reg >> 0) & 0x1);
            break;
        case 8:
            alt_timing_mode = boost::uint8_t((reg >> 5) & 0x1);
            txoff_enable = boost::uint8_t((reg >> 4) & 0x1);
            tx_digital_pd = boost::uint8_t((reg >> 3) & 0x1);
            tx_analog_pd = tx_analog_pd_t((reg >> 0) & 0x7);
            break;
        case 10:
            dac_a_offset_1_0 = boost::uint8_t((reg >> 6) & 0x3);
            dac_a_offset_dir = dac_a_offset_dir_t((reg >> 0) & 0x1);
            break;
        case 11:
            dac_a_offset_9_2 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 12:
            dac_b_offset_1_0 = boost::uint8_t((reg >> 6) & 0x3);
            dac_b_offset_dir = dac_b_offset_dir_t((reg >> 0) & 0x1);
            break;
        case 13:
            dac_b_offset_9_2 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 14:
            dac_a_coarse_gain = boost::uint8_t((reg >> 6) & 0x3);
            dac_a_fine_gain = boost::uint8_t((reg >> 0) & 0x3f);
            break;
        case 15:
            dac_b_coarse_gain = boost::uint8_t((reg >> 6) & 0x3);
            dac_b_fine_gain = boost::uint8_t((reg >> 0) & 0x3f);
            break;
        case 16:
            tx_pga_gain = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 17:
            tx_slave_enable = boost::uint8_t((reg >> 1) & 0x1);
            tx_pga_mode = tx_pga_mode_t((reg >> 0) & 0x1);
            break;
        case 18:
            tx_retime = tx_retime_t((reg >> 6) & 0x1);
            qi_order = qi_order_t((reg >> 5) & 0x1);
            inv_txsync = boost::uint8_t((reg >> 4) & 0x1);
            tx_twos_comp = boost::uint8_t((reg >> 3) & 0x1);
            inverse_samp = inverse_samp_t((reg >> 2) & 0x1);
            edges = edges_t((reg >> 1) & 0x1);
            interleaved = interleaved_t((reg >> 0) & 0x1);
            break;
        case 19:
            two_data_paths = two_data_paths_t((reg >> 4) & 0x1);
            tx_keep_ve = tx_keep_ve_t((reg >> 3) & 0x1);
            tx_hilbert = tx_hilbert_t((reg >> 2) & 0x1);
            interp = interp_t((reg >> 0) & 0x3);
            break;
        case 20:
            neg_fine_tune = neg_fine_tune_t((reg >> 5) & 0x1);
            fine_mode = fine_mode_t((reg >> 4) & 0x1);
            real_mix_mode = real_mix_mode_t((reg >> 3) & 0x1);
            neg_coarse_tune = neg_coarse_tune_t((reg >> 2) & 0x1);
            coarse_mod = coarse_mod_t((reg >> 0) & 0x3);
            break;
        case 21:
            ftw_7_0 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 22:
            ftw_15_8 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 23:
            ftw_23_16 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 24:
            input_clk_ctrl = input_clk_ctrl_t((reg >> 6) & 0x1);
            adc_div2 = adc_div2_t((reg >> 5) & 0x1);
            dll_mult = dll_mult_t((reg >> 3) & 0x3);
            dll_pd = boost::uint8_t((reg >> 2) & 0x1);
            dll_mode = dll_mode_t((reg >> 0) & 0x1);
            break;
        case 25:
            clkout2_div_factor = clkout2_div_factor_t((reg >> 6) & 0x3);
            inv2 = inv2_t((reg >> 5) & 0x1);
            inv1 = inv1_t((reg >> 1) & 0x1);
            dis2 = dis2_t((reg >> 4) & 0x1);
            dis1 = dis1_t((reg >> 0) & 0x1);
            break;
        case 26:
            aux_adc_a2_1_0 = boost::uint8_t((reg >> 6) & 0x3);
            break;
        case 27:
            aux_adc_a2_9_2 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 28:
            aux_adc_a1_1_0 = boost::uint8_t((reg >> 6) & 0x3);
            break;
        case 29:
            aux_adc_a1_9_2 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 30:
            aux_adc_b2_1_0 = boost::uint8_t((reg >> 6) & 0x3);
            break;
        case 31:
            aux_adc_b2_9_2 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 32:
            aux_adc_b1_1_0 = boost::uint8_t((reg >> 6) & 0x3);
            break;
        case 33:
            aux_adc_b1_9_2 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 34:
            aux_spi = aux_spi_t((reg >> 7) & 0x1);
            sel_bnota = sel_bnota_t((reg >> 6) & 0x1);
            refsel_b = refsel_b_t((reg >> 5) & 0x1);
            select_b = select_b_t((reg >> 4) & 0x1);
            start_b = boost::uint8_t((reg >> 3) & 0x1);
            refsel_a = refsel_a_t((reg >> 2) & 0x1);
            select_a = select_a_t((reg >> 1) & 0x1);
            start_a = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 35:
            clk_4 = clk_4_t((reg >> 0) & 0x1);
            break;
        case 36:
            aux_dac_a = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 37:
            aux_dac_b = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 38:
            aux_dac_c = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 39:
            aux_dac_slave_enable = boost::uint8_t((reg >> 7) & 0x1);
            aux_dacupdate_c = boost::uint8_t((reg >> 2) & 0x1);
            aux_dacupdate_b = boost::uint8_t((reg >> 1) & 0x1);
            aux_dacupdate_a = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 40:
            aux_dac_pd_a = boost::uint8_t((reg >> 2) & 0x1);
            aux_dac_pd_b = boost::uint8_t((reg >> 1) & 0x1);
            aux_dac_pd_c = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 41:
            aux_dac_invert_a = boost::uint8_t((reg >> 2) & 0x1);
            aux_dac_invert_b = boost::uint8_t((reg >> 1) & 0x1);
            aux_dac_invert_c = boost::uint8_t((reg >> 0) & 0x1);
            break;
        case 42:
            sig_delt_3_0 = boost::uint8_t((reg >> 4) & 0xf);
            break;
        case 43:
            sig_delt_11_4 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 49:
            rx_low_power_mode_r49 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 50:
            rx_low_power_mode_r50 = boost::uint8_t((reg >> 0) & 0xff);
            break;
        case 63:
            chip_id = boost::uint8_t((reg >> 0) & 0xff);
            break;
        }
    }
    
    boost::uint16_t get_write_reg(boost::uint8_t addr){
        return (boost::uint16_t(addr) << 8) | get_reg(addr);
    }
    
    boost::uint16_t get_read_reg(boost::uint8_t addr){
        return (boost::uint16_t(addr) << 8) | (1 << 15);
    }

    void save_state(void){
        if (_state == NULL) _state = new ad9862_regs_t();
        _state->sdio_bidir = this->sdio_bidir;
        _state->lsb_first = this->lsb_first;
        _state->soft_reset = this->soft_reset;
        _state->vref_diff_pd = this->vref_diff_pd;
        _state->vref_pd = this->vref_pd;
        _state->rx_digital_pd = this->rx_digital_pd;
        _state->rx_channel_b_pd = this->rx_channel_b_pd;
        _state->rx_channel_a_pd = this->rx_channel_a_pd;
        _state->buffer_b_pd = this->buffer_b_pd;
        _state->buffer_a_pd = this->buffer_a_pd;
        _state->all_rx_pd = this->all_rx_pd;
        _state->byp_buffer_a = this->byp_buffer_a;
        _state->rx_pga_a = this->rx_pga_a;
        _state->byp_buffer_b = this->byp_buffer_b;
        _state->rx_pga_b = this->rx_pga_b;
        _state->hs_duty_cycle = this->hs_duty_cycle;
        _state->shared_ref = this->shared_ref;
        _state->clk_duty = this->clk_duty;
        _state->three_state = this->three_state;
        _state->rx_retime = this->rx_retime;
        _state->rx_twos_comp = this->rx_twos_comp;
        _state->inv_rxsync = this->inv_rxsync;
        _state->mux_out = this->mux_out;
        _state->two_channel = this->two_channel;
        _state->rx_keep_ve = this->rx_keep_ve;
        _state->rx_hilbert = this->rx_hilbert;
        _state->decimate = this->decimate;
        _state->alt_timing_mode = this->alt_timing_mode;
        _state->txoff_enable = this->txoff_enable;
        _state->tx_digital_pd = this->tx_digital_pd;
        _state->tx_analog_pd = this->tx_analog_pd;
        _state->dac_a_offset_1_0 = this->dac_a_offset_1_0;
        _state->dac_a_offset_dir = this->dac_a_offset_dir;
        _state->dac_a_offset_9_2 = this->dac_a_offset_9_2;
        _state->dac_a_coarse_gain = this->dac_a_coarse_gain;
        _state->dac_a_fine_gain = this->dac_a_fine_gain;
        _state->dac_b_offset_1_0 = this->dac_b_offset_1_0;
        _state->dac_b_offset_dir = this->dac_b_offset_dir;
        _state->dac_b_offset_9_2 = this->dac_b_offset_9_2;
        _state->dac_b_coarse_gain = this->dac_b_coarse_gain;
        _state->dac_b_fine_gain = this->dac_b_fine_gain;
        _state->tx_pga_gain = this->tx_pga_gain;
        _state->tx_slave_enable = this->tx_slave_enable;
        _state->tx_pga_mode = this->tx_pga_mode;
        _state->tx_retime = this->tx_retime;
        _state->qi_order = this->qi_order;
        _state->inv_txsync = this->inv_txsync;
        _state->tx_twos_comp = this->tx_twos_comp;
        _state->inverse_samp = this->inverse_samp;
        _state->edges = this->edges;
        _state->interleaved = this->interleaved;
        _state->two_data_paths = this->two_data_paths;
        _state->tx_keep_ve = this->tx_keep_ve;
        _state->tx_hilbert = this->tx_hilbert;
        _state->interp = this->interp;
        _state->neg_fine_tune = this->neg_fine_tune;
        _state->fine_mode = this->fine_mode;
        _state->real_mix_mode = this->real_mix_mode;
        _state->neg_coarse_tune = this->neg_coarse_tune;
        _state->coarse_mod = this->coarse_mod;
        _state->ftw_7_0 = this->ftw_7_0;
        _state->ftw_15_8 = this->ftw_15_8;
        _state->ftw_23_16 = this->ftw_23_16;
        _state->input_clk_ctrl = this->input_clk_ctrl;
        _state->adc_div2 = this->adc_div2;
        _state->dll_mult = this->dll_mult;
        _state->dll_pd = this->dll_pd;
        _state->dll_mode = this->dll_mode;
        _state->clkout2_div_factor = this->clkout2_div_factor;
        _state->inv2 = this->inv2;
        _state->inv1 = this->inv1;
        _state->dis2 = this->dis2;
        _state->dis1 = this->dis1;
        _state->aux_adc_a2_1_0 = this->aux_adc_a2_1_0;
        _state->aux_adc_a2_9_2 = this->aux_adc_a2_9_2;
        _state->aux_adc_a1_1_0 = this->aux_adc_a1_1_0;
        _state->aux_adc_a1_9_2 = this->aux_adc_a1_9_2;
        _state->aux_adc_b2_1_0 = this->aux_adc_b2_1_0;
        _state->aux_adc_b2_9_2 = this->aux_adc_b2_9_2;
        _state->aux_adc_b1_1_0 = this->aux_adc_b1_1_0;
        _state->aux_adc_b1_9_2 = this->aux_adc_b1_9_2;
        _state->aux_spi = this->aux_spi;
        _state->sel_bnota = this->sel_bnota;
        _state->refsel_b = this->refsel_b;
        _state->select_b = this->select_b;
        _state->start_b = this->start_b;
        _state->refsel_a = this->refsel_a;
        _state->select_a = this->select_a;
        _state->start_a = this->start_a;
        _state->clk_4 = this->clk_4;
        _state->aux_dac_a = this->aux_dac_a;
        _state->aux_dac_b = this->aux_dac_b;
        _state->aux_dac_c = this->aux_dac_c;
        _state->aux_dac_slave_enable = this->aux_dac_slave_enable;
        _state->aux_dacupdate_c = this->aux_dacupdate_c;
        _state->aux_dacupdate_b = this->aux_dacupdate_b;
        _state->aux_dacupdate_a = this->aux_dacupdate_a;
        _state->aux_dac_pd_a = this->aux_dac_pd_a;
        _state->aux_dac_pd_b = this->aux_dac_pd_b;
        _state->aux_dac_pd_c = this->aux_dac_pd_c;
        _state->aux_dac_invert_a = this->aux_dac_invert_a;
        _state->aux_dac_invert_b = this->aux_dac_invert_b;
        _state->aux_dac_invert_c = this->aux_dac_invert_c;
        _state->sig_delt_3_0 = this->sig_delt_3_0;
        _state->sig_delt_11_4 = this->sig_delt_11_4;
        _state->rx_low_power_mode_r49 = this->rx_low_power_mode_r49;
        _state->rx_low_power_mode_r50 = this->rx_low_power_mode_r50;
        _state->chip_id = this->chip_id;
    }

    template<typename T> std::set<T> get_changed_addrs(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if(_state->sdio_bidir != this->sdio_bidir){
            addrs.insert(0);
        }
        if(_state->lsb_first != this->lsb_first){
            addrs.insert(0);
        }
        if(_state->soft_reset != this->soft_reset){
            addrs.insert(0);
        }
        if(_state->vref_diff_pd != this->vref_diff_pd){
            addrs.insert(1);
        }
        if(_state->vref_pd != this->vref_pd){
            addrs.insert(1);
        }
        if(_state->rx_digital_pd != this->rx_digital_pd){
            addrs.insert(1);
        }
        if(_state->rx_channel_b_pd != this->rx_channel_b_pd){
            addrs.insert(1);
        }
        if(_state->rx_channel_a_pd != this->rx_channel_a_pd){
            addrs.insert(1);
        }
        if(_state->buffer_b_pd != this->buffer_b_pd){
            addrs.insert(1);
        }
        if(_state->buffer_a_pd != this->buffer_a_pd){
            addrs.insert(1);
        }
        if(_state->all_rx_pd != this->all_rx_pd){
            addrs.insert(1);
        }
        if(_state->byp_buffer_a != this->byp_buffer_a){
            addrs.insert(2);
        }
        if(_state->rx_pga_a != this->rx_pga_a){
            addrs.insert(2);
        }
        if(_state->byp_buffer_b != this->byp_buffer_b){
            addrs.insert(3);
        }
        if(_state->rx_pga_b != this->rx_pga_b){
            addrs.insert(3);
        }
        if(_state->hs_duty_cycle != this->hs_duty_cycle){
            addrs.insert(4);
        }
        if(_state->shared_ref != this->shared_ref){
            addrs.insert(4);
        }
        if(_state->clk_duty != this->clk_duty){
            addrs.insert(4);
        }
        if(_state->three_state != this->three_state){
            addrs.insert(5);
        }
        if(_state->rx_retime != this->rx_retime){
            addrs.insert(5);
        }
        if(_state->rx_twos_comp != this->rx_twos_comp){
            addrs.insert(5);
        }
        if(_state->inv_rxsync != this->inv_rxsync){
            addrs.insert(5);
        }
        if(_state->mux_out != this->mux_out){
            addrs.insert(5);
        }
        if(_state->two_channel != this->two_channel){
            addrs.insert(6);
        }
        if(_state->rx_keep_ve != this->rx_keep_ve){
            addrs.insert(6);
        }
        if(_state->rx_hilbert != this->rx_hilbert){
            addrs.insert(6);
        }
        if(_state->decimate != this->decimate){
            addrs.insert(6);
        }
        if(_state->alt_timing_mode != this->alt_timing_mode){
            addrs.insert(8);
        }
        if(_state->txoff_enable != this->txoff_enable){
            addrs.insert(8);
        }
        if(_state->tx_digital_pd != this->tx_digital_pd){
            addrs.insert(8);
        }
        if(_state->tx_analog_pd != this->tx_analog_pd){
            addrs.insert(8);
        }
        if(_state->dac_a_offset_1_0 != this->dac_a_offset_1_0){
            addrs.insert(10);
        }
        if(_state->dac_a_offset_dir != this->dac_a_offset_dir){
            addrs.insert(10);
        }
        if(_state->dac_a_offset_9_2 != this->dac_a_offset_9_2){
            addrs.insert(11);
        }
        if(_state->dac_a_coarse_gain != this->dac_a_coarse_gain){
            addrs.insert(14);
        }
        if(_state->dac_a_fine_gain != this->dac_a_fine_gain){
            addrs.insert(14);
        }
        if(_state->dac_b_offset_1_0 != this->dac_b_offset_1_0){
            addrs.insert(12);
        }
        if(_state->dac_b_offset_dir != this->dac_b_offset_dir){
            addrs.insert(12);
        }
        if(_state->dac_b_offset_9_2 != this->dac_b_offset_9_2){
            addrs.insert(13);
        }
        if(_state->dac_b_coarse_gain != this->dac_b_coarse_gain){
            addrs.insert(15);
        }
        if(_state->dac_b_fine_gain != this->dac_b_fine_gain){
            addrs.insert(15);
        }
        if(_state->tx_pga_gain != this->tx_pga_gain){
            addrs.insert(16);
        }
        if(_state->tx_slave_enable != this->tx_slave_enable){
            addrs.insert(17);
        }
        if(_state->tx_pga_mode != this->tx_pga_mode){
            addrs.insert(17);
        }
        if(_state->tx_retime != this->tx_retime){
            addrs.insert(18);
        }
        if(_state->qi_order != this->qi_order){
            addrs.insert(18);
        }
        if(_state->inv_txsync != this->inv_txsync){
            addrs.insert(18);
        }
        if(_state->tx_twos_comp != this->tx_twos_comp){
            addrs.insert(18);
        }
        if(_state->inverse_samp != this->inverse_samp){
            addrs.insert(18);
        }
        if(_state->edges != this->edges){
            addrs.insert(18);
        }
        if(_state->interleaved != this->interleaved){
            addrs.insert(18);
        }
        if(_state->two_data_paths != this->two_data_paths){
            addrs.insert(19);
        }
        if(_state->tx_keep_ve != this->tx_keep_ve){
            addrs.insert(19);
        }
        if(_state->tx_hilbert != this->tx_hilbert){
            addrs.insert(19);
        }
        if(_state->interp != this->interp){
            addrs.insert(19);
        }
        if(_state->neg_fine_tune != this->neg_fine_tune){
            addrs.insert(20);
        }
        if(_state->fine_mode != this->fine_mode){
            addrs.insert(20);
        }
        if(_state->real_mix_mode != this->real_mix_mode){
            addrs.insert(20);
        }
        if(_state->neg_coarse_tune != this->neg_coarse_tune){
            addrs.insert(20);
        }
        if(_state->coarse_mod != this->coarse_mod){
            addrs.insert(20);
        }
        if(_state->ftw_7_0 != this->ftw_7_0){
            addrs.insert(21);
        }
        if(_state->ftw_15_8 != this->ftw_15_8){
            addrs.insert(22);
        }
        if(_state->ftw_23_16 != this->ftw_23_16){
            addrs.insert(23);
        }
        if(_state->input_clk_ctrl != this->input_clk_ctrl){
            addrs.insert(24);
        }
        if(_state->adc_div2 != this->adc_div2){
            addrs.insert(24);
        }
        if(_state->dll_mult != this->dll_mult){
            addrs.insert(24);
        }
        if(_state->dll_pd != this->dll_pd){
            addrs.insert(24);
        }
        if(_state->dll_mode != this->dll_mode){
            addrs.insert(24);
        }
        if(_state->clkout2_div_factor != this->clkout2_div_factor){
            addrs.insert(25);
        }
        if(_state->inv2 != this->inv2){
            addrs.insert(25);
        }
        if(_state->inv1 != this->inv1){
            addrs.insert(25);
        }
        if(_state->dis2 != this->dis2){
            addrs.insert(25);
        }
        if(_state->dis1 != this->dis1){
            addrs.insert(25);
        }
        if(_state->aux_adc_a2_1_0 != this->aux_adc_a2_1_0){
            addrs.insert(26);
        }
        if(_state->aux_adc_a2_9_2 != this->aux_adc_a2_9_2){
            addrs.insert(27);
        }
        if(_state->aux_adc_a1_1_0 != this->aux_adc_a1_1_0){
            addrs.insert(28);
        }
        if(_state->aux_adc_a1_9_2 != this->aux_adc_a1_9_2){
            addrs.insert(29);
        }
        if(_state->aux_adc_b2_1_0 != this->aux_adc_b2_1_0){
            addrs.insert(30);
        }
        if(_state->aux_adc_b2_9_2 != this->aux_adc_b2_9_2){
            addrs.insert(31);
        }
        if(_state->aux_adc_b1_1_0 != this->aux_adc_b1_1_0){
            addrs.insert(32);
        }
        if(_state->aux_adc_b1_9_2 != this->aux_adc_b1_9_2){
            addrs.insert(33);
        }
        if(_state->aux_spi != this->aux_spi){
            addrs.insert(34);
        }
        if(_state->sel_bnota != this->sel_bnota){
            addrs.insert(34);
        }
        if(_state->refsel_b != this->refsel_b){
            addrs.insert(34);
        }
        if(_state->select_b != this->select_b){
            addrs.insert(34);
        }
        if(_state->start_b != this->start_b){
            addrs.insert(34);
        }
        if(_state->refsel_a != this->refsel_a){
            addrs.insert(34);
        }
        if(_state->select_a != this->select_a){
            addrs.insert(34);
        }
        if(_state->start_a != this->start_a){
            addrs.insert(34);
        }
        if(_state->clk_4 != this->clk_4){
            addrs.insert(35);
        }
        if(_state->aux_dac_a != this->aux_dac_a){
            addrs.insert(36);
        }
        if(_state->aux_dac_b != this->aux_dac_b){
            addrs.insert(37);
        }
        if(_state->aux_dac_c != this->aux_dac_c){
            addrs.insert(38);
        }
        if(_state->aux_dac_slave_enable != this->aux_dac_slave_enable){
            addrs.insert(39);
        }
        if(_state->aux_dacupdate_c != this->aux_dacupdate_c){
            addrs.insert(39);
        }
        if(_state->aux_dacupdate_b != this->aux_dacupdate_b){
            addrs.insert(39);
        }
        if(_state->aux_dacupdate_a != this->aux_dacupdate_a){
            addrs.insert(39);
        }
        if(_state->aux_dac_pd_a != this->aux_dac_pd_a){
            addrs.insert(40);
        }
        if(_state->aux_dac_pd_b != this->aux_dac_pd_b){
            addrs.insert(40);
        }
        if(_state->aux_dac_pd_c != this->aux_dac_pd_c){
            addrs.insert(40);
        }
        if(_state->aux_dac_invert_a != this->aux_dac_invert_a){
            addrs.insert(41);
        }
        if(_state->aux_dac_invert_b != this->aux_dac_invert_b){
            addrs.insert(41);
        }
        if(_state->aux_dac_invert_c != this->aux_dac_invert_c){
            addrs.insert(41);
        }
        if(_state->sig_delt_3_0 != this->sig_delt_3_0){
            addrs.insert(42);
        }
        if(_state->sig_delt_11_4 != this->sig_delt_11_4){
            addrs.insert(43);
        }
        if(_state->rx_low_power_mode_r49 != this->rx_low_power_mode_r49){
            addrs.insert(49);
        }
        if(_state->rx_low_power_mode_r50 != this->rx_low_power_mode_r50){
            addrs.insert(50);
        }
        if(_state->chip_id != this->chip_id){
            addrs.insert(63);
        }
        return addrs;
    }

private:
    ad9862_regs_t *_state;
};

#endif /* INCLUDED_AD9862_REGS_HPP */
