//
// Copyright 2016 Ettus Research LLC
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "twinrx_gain_tables.hpp"
#include <uhd/exception.hpp>
#include <boost/assign/list_of.hpp>

using namespace uhd::usrp::dboard::twinrx;

static const std::vector<twinrx_gain_config_t> HIGHBAND1_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      3,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      4,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      5,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      6,  -28.3,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      7,  -27.3,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      8,  -26.3,   31,   29, false, false ) )
        ( twinrx_gain_config_t(      9,  -25.3,   31,   28, false, false ) )
        ( twinrx_gain_config_t(     10,  -24.3,   31,   27, false, false ) )
        ( twinrx_gain_config_t(     11,  -23.3,   31,   26, false, false ) )
        ( twinrx_gain_config_t(     12,  -22.3,   31,   25, false, false ) )
        ( twinrx_gain_config_t(     13,  -21.3,   31,   24, false, false ) )
        ( twinrx_gain_config_t(     14,  -20.3,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     15,  -19.3,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     16,  -18.3,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     17,  -17.3,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     18,  -16.3,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     19,  -15.3,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     20,  -14.3,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     21,  -13.3,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     22,  -12.3,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     23,  -11.3,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     24,  -10.3,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     25,   -9.3,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     26,   -8.3,   30,   12, false, false ) )
        ( twinrx_gain_config_t(     27,   -7.3,   30,   11, false, false ) )
        ( twinrx_gain_config_t(     28,   -6.3,   29,   11, false, false ) )
        ( twinrx_gain_config_t(     29,   -5.3,   28,   11, false, false ) )
        ( twinrx_gain_config_t(     30,   -4.3,   27,   11, false, false ) )
        ( twinrx_gain_config_t(     31,   -3.3,   27,   10, false, false ) )
        ( twinrx_gain_config_t(     32,   -2.3,   26,   10, false, false ) )
        ( twinrx_gain_config_t(     33,   -1.3,   25,   10, false, false ) )
        ( twinrx_gain_config_t(     34,   -0.3,   24,   10, false, false ) )
        ( twinrx_gain_config_t(     35,    0.7,   23,   10, false, false ) )
        ( twinrx_gain_config_t(     36,    1.7,   22,   10, false, false ) )
        ( twinrx_gain_config_t(     37,    2.7,   21,   10, false, false ) )
        ( twinrx_gain_config_t(     38,    3.7,   21,    9, false, false ) )
        ( twinrx_gain_config_t(     39,    4.7,   20,    9, false, false ) )
        ( twinrx_gain_config_t(     40,    5.7,   19,    9, false, false ) )
        ( twinrx_gain_config_t(     41,    6.7,   18,    9, false, false ) )
        ( twinrx_gain_config_t(     42,    7.7,   17,    9, false, false ) )
        ( twinrx_gain_config_t(     43,    8.7,   16,    9, false, false ) )
        ( twinrx_gain_config_t(     44,    9.7,   15,    9, false, false ) )
        ( twinrx_gain_config_t(     45,   10.7,   14,    9, false, false ) )
        ( twinrx_gain_config_t(     46,   11.7,   13,    9, false, false ) )
        ( twinrx_gain_config_t(     47,   12.7,   12,    9, false, false ) )
        ( twinrx_gain_config_t(     48,   13.7,   11,    9, false, false ) )
        ( twinrx_gain_config_t(     49,   14.7,   10,    9, false, false ) )
        ( twinrx_gain_config_t(     50,   15.7,    9,    9, false, false ) )
        ( twinrx_gain_config_t(     51,   16.7,    8,    9, false, false ) )
        ( twinrx_gain_config_t(     52,   17.7,    7,    9, false, false ) )
        ( twinrx_gain_config_t(     53,   18.7,    6,    9, false, false ) )
        ( twinrx_gain_config_t(     54,   19.7,    5,    9, false, false ) )
        ( twinrx_gain_config_t(     55,   20.7,    4,    9, false, false ) )
        ( twinrx_gain_config_t(     56,   21.7,    3,    9, false, false ) )
        ( twinrx_gain_config_t(     57,   22.7,    2,    9, false, false ) )
        ( twinrx_gain_config_t(     58,   23.7,    1,    9, false, false ) )
        ( twinrx_gain_config_t(     59,   24.7,    0,    9, false, false ) )
        ( twinrx_gain_config_t(     60,   25.7,    0,    8, false, false ) )
        ( twinrx_gain_config_t(     61,   26.7,    0,    7, false, false ) )
        ( twinrx_gain_config_t(     62,   27.7,    0,    6, false, false ) )
        ( twinrx_gain_config_t(     63,   28.7,    0,    5, false, false ) )
        ( twinrx_gain_config_t(     64,   29.7,    0,    4, false, false ) )
        ( twinrx_gain_config_t(     65,   30.7,    0,    3, false, false ) )
        ( twinrx_gain_config_t(     66,   31.7,    0,    2, false, false ) )
        ( twinrx_gain_config_t(     67,   32.7,    0,    1, false, false ) )
        ( twinrx_gain_config_t(     68,   33.7,    0,    0, false, false ) )
        ( twinrx_gain_config_t(     69,   33.9,    3,    9,  true, false ) )
        ( twinrx_gain_config_t(     70,   34.9,    2,    9,  true, false ) )
        ( twinrx_gain_config_t(     71,   35.9,    1,    9,  true, false ) )
        ( twinrx_gain_config_t(     72,   36.9,    0,    9,  true, false ) )
        ( twinrx_gain_config_t(     73,   37.9,    0,    8,  true, false ) )
        ( twinrx_gain_config_t(     74,   38.9,    0,    7,  true, false ) )
        ( twinrx_gain_config_t(     75,   39.9,    0,    6,  true, false ) )
        ( twinrx_gain_config_t(     76,   40.9,    0,    5,  true, false ) )
        ( twinrx_gain_config_t(     77,   41.9,    0,    4,  true, false ) )
        ( twinrx_gain_config_t(     78,   42.9,    0,    3,  true, false ) )
        ( twinrx_gain_config_t(     79,   43.9,    0,    2,  true, false ) )
        ( twinrx_gain_config_t(     80,   44.9,    0,    1,  true, false ) )
        ( twinrx_gain_config_t(     81,   45.9,    0,    0,  true, false ) )
        ( twinrx_gain_config_t(     82,   47.3,    1,   10,  true,  true ) )
        ( twinrx_gain_config_t(     83,   48.3,    0,   10,  true,  true ) )
        ( twinrx_gain_config_t(     84,   49.3,    0,    9,  true,  true ) )
        ( twinrx_gain_config_t(     85,   50.3,    0,    8,  true,  true ) )
        ( twinrx_gain_config_t(     86,   51.3,    0,    7,  true,  true ) )
        ( twinrx_gain_config_t(     87,   52.3,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   53.3,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   54.3,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   55.3,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   56.3,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   57.3,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   58.3,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> HIGHBAND2_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      3,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      4,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      5,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      6,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      7,  -30.9,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      8,  -29.9,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      9,  -28.9,   31,   29, false, false ) )
        ( twinrx_gain_config_t(     10,  -27.9,   31,   28, false, false ) )
        ( twinrx_gain_config_t(     11,  -26.9,   31,   27, false, false ) )
        ( twinrx_gain_config_t(     12,  -25.9,   31,   26, false, false ) )
        ( twinrx_gain_config_t(     13,  -24.9,   31,   25, false, false ) )
        ( twinrx_gain_config_t(     14,  -23.9,   31,   24, false, false ) )
        ( twinrx_gain_config_t(     15,  -22.9,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     16,  -21.9,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     17,  -20.9,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     18,  -19.9,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     19,  -18.9,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     20,  -17.9,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     21,  -16.9,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     22,  -15.9,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     23,  -14.9,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     24,  -13.9,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     25,  -12.9,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     26,  -11.9,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     27,  -10.9,   31,   11, false, false ) )
        ( twinrx_gain_config_t(     28,   -9.9,   30,   11, false, false ) )
        ( twinrx_gain_config_t(     29,   -8.9,   29,   11, false, false ) )
        ( twinrx_gain_config_t(     30,   -7.9,   29,   10, false, false ) )
        ( twinrx_gain_config_t(     31,   -6.9,   28,   10, false, false ) )
        ( twinrx_gain_config_t(     32,   -5.9,   27,   10, false, false ) )
        ( twinrx_gain_config_t(     33,   -4.9,   27,    9, false, false ) )
        ( twinrx_gain_config_t(     34,   -3.9,   26,    9, false, false ) )
        ( twinrx_gain_config_t(     35,   -2.9,   25,    9, false, false ) )
        ( twinrx_gain_config_t(     36,   -1.9,   24,    9, false, false ) )
        ( twinrx_gain_config_t(     37,   -0.9,   23,    9, false, false ) )
        ( twinrx_gain_config_t(     38,    0.1,   23,    8, false, false ) )
        ( twinrx_gain_config_t(     39,    1.1,   22,    8, false, false ) )
        ( twinrx_gain_config_t(     40,    2.1,   21,    8, false, false ) )
        ( twinrx_gain_config_t(     41,    3.1,   20,    8, false, false ) )
        ( twinrx_gain_config_t(     42,    4.1,   19,    8, false, false ) )
        ( twinrx_gain_config_t(     43,    5.1,   18,    8, false, false ) )
        ( twinrx_gain_config_t(     44,    6.1,   17,    8, false, false ) )
        ( twinrx_gain_config_t(     45,    7.1,   16,    8, false, false ) )
        ( twinrx_gain_config_t(     46,    8.1,   15,    8, false, false ) )
        ( twinrx_gain_config_t(     47,    9.1,   14,    8, false, false ) )
        ( twinrx_gain_config_t(     48,   10.1,   13,    8, false, false ) )
        ( twinrx_gain_config_t(     49,   11.1,   12,    8, false, false ) )
        ( twinrx_gain_config_t(     50,   12.1,   11,    8, false, false ) )
        ( twinrx_gain_config_t(     51,   13.1,   10,    8, false, false ) )
        ( twinrx_gain_config_t(     52,   14.1,    9,    8, false, false ) )
        ( twinrx_gain_config_t(     53,   15.1,    8,    8, false, false ) )
        ( twinrx_gain_config_t(     54,   16.1,    7,    8, false, false ) )
        ( twinrx_gain_config_t(     55,   17.1,    6,    8, false, false ) )
        ( twinrx_gain_config_t(     56,   18.1,    5,    8, false, false ) )
        ( twinrx_gain_config_t(     57,   19.1,    4,    8, false, false ) )
        ( twinrx_gain_config_t(     58,   20.1,    3,    8, false, false ) )
        ( twinrx_gain_config_t(     59,   21.1,    2,    8, false, false ) )
        ( twinrx_gain_config_t(     60,   22.1,    1,    8, false, false ) )
        ( twinrx_gain_config_t(     61,   23.1,    0,    8, false, false ) )
        ( twinrx_gain_config_t(     62,   24.1,    0,    7, false, false ) )
        ( twinrx_gain_config_t(     63,   25.1,    0,    6, false, false ) )
        ( twinrx_gain_config_t(     64,   26.1,    0,    5, false, false ) )
        ( twinrx_gain_config_t(     65,   27.1,    0,    4, false, false ) )
        ( twinrx_gain_config_t(     66,   28.1,    0,    3, false, false ) )
        ( twinrx_gain_config_t(     67,   29.1,    0,    2, false, false ) )
        ( twinrx_gain_config_t(     68,   30.1,    0,    1, false, false ) )
        ( twinrx_gain_config_t(     69,   31.9,    0,   10, false,  true ) )
        ( twinrx_gain_config_t(     70,   31.9,    0,   10, false,  true ) )
        ( twinrx_gain_config_t(     71,   32.9,    0,    9, false,  true ) )
        ( twinrx_gain_config_t(     72,   33.9,    0,    8, false,  true ) )
        ( twinrx_gain_config_t(     73,   34.9,    0,    7, false,  true ) )
        ( twinrx_gain_config_t(     74,   35.9,    0,    6, false,  true ) )
        ( twinrx_gain_config_t(     75,   36.9,    0,    5, false,  true ) )
        ( twinrx_gain_config_t(     76,   38.6,    0,    6,  true, false ) )
        ( twinrx_gain_config_t(     77,   39.6,    0,    5,  true, false ) )
        ( twinrx_gain_config_t(     78,   40.6,    0,    4,  true, false ) )
        ( twinrx_gain_config_t(     79,   41.6,    0,    3,  true, false ) )
        ( twinrx_gain_config_t(     80,   42.6,    0,    2,  true, false ) )
        ( twinrx_gain_config_t(     81,   43.6,    0,    1,  true, false ) )
        ( twinrx_gain_config_t(     82,   44.4,    2,    9,  true,  true ) )
        ( twinrx_gain_config_t(     83,   45.4,    1,    9,  true,  true ) )
        ( twinrx_gain_config_t(     84,   46.4,    0,    9,  true,  true ) )
        ( twinrx_gain_config_t(     85,   47.4,    0,    8,  true,  true ) )
        ( twinrx_gain_config_t(     86,   48.4,    0,    7,  true,  true ) )
        ( twinrx_gain_config_t(     87,   49.4,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   50.4,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   51.4,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   52.4,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   53.4,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   54.4,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   55.4,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> HIGHBAND3_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      3,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      4,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      5,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      6,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      7,  -30.1,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      8,  -29.1,   31,   29, false, false ) )
        ( twinrx_gain_config_t(      9,  -28.1,   31,   28, false, false ) )
        ( twinrx_gain_config_t(     10,  -27.1,   31,   27, false, false ) )
        ( twinrx_gain_config_t(     11,  -26.1,   31,   26, false, false ) )
        ( twinrx_gain_config_t(     12,  -25.1,   31,   25, false, false ) )
        ( twinrx_gain_config_t(     13,  -24.1,   31,   24, false, false ) )
        ( twinrx_gain_config_t(     14,  -23.1,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     15,  -22.1,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     16,  -21.1,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     17,  -20.1,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     18,  -19.1,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     19,  -18.1,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     20,  -17.1,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     21,  -16.1,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     22,  -15.1,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     23,  -14.1,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     24,  -13.1,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     25,  -12.1,   30,   13, false, false ) )
        ( twinrx_gain_config_t(     26,  -11.1,   30,   12, false, false ) )
        ( twinrx_gain_config_t(     27,  -10.1,   29,   12, false, false ) )
        ( twinrx_gain_config_t(     28,   -9.1,   28,   12, false, false ) )
        ( twinrx_gain_config_t(     29,   -8.1,   28,   11, false, false ) )
        ( twinrx_gain_config_t(     30,   -7.1,   27,   11, false, false ) )
        ( twinrx_gain_config_t(     31,   -6.1,   26,   11, false, false ) )
        ( twinrx_gain_config_t(     32,   -5.1,   26,   10, false, false ) )
        ( twinrx_gain_config_t(     33,   -4.1,   25,   10, false, false ) )
        ( twinrx_gain_config_t(     34,   -3.1,   24,   10, false, false ) )
        ( twinrx_gain_config_t(     35,   -2.1,   23,   10, false, false ) )
        ( twinrx_gain_config_t(     36,   -1.1,   22,   10, false, false ) )
        ( twinrx_gain_config_t(     37,   -0.1,   21,   10, false, false ) )
        ( twinrx_gain_config_t(     38,    0.9,   21,    9, false, false ) )
        ( twinrx_gain_config_t(     39,    1.9,   20,    9, false, false ) )
        ( twinrx_gain_config_t(     40,    2.9,   19,    9, false, false ) )
        ( twinrx_gain_config_t(     41,    3.9,   18,    9, false, false ) )
        ( twinrx_gain_config_t(     42,    4.9,   17,    9, false, false ) )
        ( twinrx_gain_config_t(     43,    5.9,   16,    9, false, false ) )
        ( twinrx_gain_config_t(     44,    6.9,   15,    9, false, false ) )
        ( twinrx_gain_config_t(     45,    7.9,   14,    9, false, false ) )
        ( twinrx_gain_config_t(     46,    8.9,   13,    9, false, false ) )
        ( twinrx_gain_config_t(     47,    9.9,   12,    9, false, false ) )
        ( twinrx_gain_config_t(     48,   10.9,   11,    9, false, false ) )
        ( twinrx_gain_config_t(     49,   11.9,   10,    9, false, false ) )
        ( twinrx_gain_config_t(     50,   12.9,    9,    9, false, false ) )
        ( twinrx_gain_config_t(     51,   13.9,    8,    9, false, false ) )
        ( twinrx_gain_config_t(     52,   14.9,    7,    9, false, false ) )
        ( twinrx_gain_config_t(     53,   15.9,    6,    9, false, false ) )
        ( twinrx_gain_config_t(     54,   16.9,    5,    9, false, false ) )
        ( twinrx_gain_config_t(     55,   17.9,    4,    9, false, false ) )
        ( twinrx_gain_config_t(     56,   18.9,    3,    9, false, false ) )
        ( twinrx_gain_config_t(     57,   19.9,    2,    9, false, false ) )
        ( twinrx_gain_config_t(     58,   20.9,    1,    9, false, false ) )
        ( twinrx_gain_config_t(     59,   21.9,    0,    9, false, false ) )
        ( twinrx_gain_config_t(     60,   22.9,    0,    8, false, false ) )
        ( twinrx_gain_config_t(     61,   23.9,    0,    7, false, false ) )
        ( twinrx_gain_config_t(     62,   24.9,    0,    6, false, false ) )
        ( twinrx_gain_config_t(     63,   25.9,    0,    5, false, false ) )
        ( twinrx_gain_config_t(     64,   26.9,    0,    4, false, false ) )
        ( twinrx_gain_config_t(     65,   27.9,    0,    3, false, false ) )
        ( twinrx_gain_config_t(     66,   28.9,    0,    2, false, false ) )
        ( twinrx_gain_config_t(     67,   29.9,    0,    1, false, false ) )
        ( twinrx_gain_config_t(     68,   31.3,    0,    9, false,  true ) )
        ( twinrx_gain_config_t(     69,   32.3,    0,    8, false,  true ) )
        ( twinrx_gain_config_t(     70,   33.3,    0,    7, false,  true ) )
        ( twinrx_gain_config_t(     71,   34.3,    0,    6, false,  true ) )
        ( twinrx_gain_config_t(     72,   35.3,    0,    5, false,  true ) )
        ( twinrx_gain_config_t(     73,   36.3,    0,    4, false,  true ) )
        ( twinrx_gain_config_t(     74,   37.3,    0,    3, false,  true ) )
        ( twinrx_gain_config_t(     75,   37.6,    0,    9,  true, false ) )
        ( twinrx_gain_config_t(     76,   38.6,    0,    8,  true, false ) )
        ( twinrx_gain_config_t(     77,   39.6,    0,    7,  true, false ) )
        ( twinrx_gain_config_t(     78,   40.6,    0,    6,  true, false ) )
        ( twinrx_gain_config_t(     79,   41.6,    0,    5,  true, false ) )
        ( twinrx_gain_config_t(     80,   42.6,    0,    4,  true, false ) )
        ( twinrx_gain_config_t(     81,   43.6,    0,    3,  true, false ) )
        ( twinrx_gain_config_t(     82,   44.6,    0,    2,  true, false ) )
        ( twinrx_gain_config_t(     83,   45.6,    0,    1,  true, false ) )
        ( twinrx_gain_config_t(     84,   47.0,    0,    9,  true,  true ) )
        ( twinrx_gain_config_t(     85,   48.0,    0,    8,  true,  true ) )
        ( twinrx_gain_config_t(     86,   49.0,    0,    7,  true,  true ) )
        ( twinrx_gain_config_t(     87,   50.0,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   51.0,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   52.0,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   53.0,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   54.0,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   55.0,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   56.0,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> HIGHBAND4_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      3,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      4,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      5,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      6,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      7,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      8,  -37.2,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      9,  -36.2,   31,   30, false, false ) )
        ( twinrx_gain_config_t(     10,  -35.2,   31,   29, false, false ) )
        ( twinrx_gain_config_t(     11,  -34.2,   31,   28, false, false ) )
        ( twinrx_gain_config_t(     12,  -33.2,   31,   27, false, false ) )
        ( twinrx_gain_config_t(     13,  -32.2,   31,   26, false, false ) )
        ( twinrx_gain_config_t(     14,  -31.2,   31,   25, false, false ) )
        ( twinrx_gain_config_t(     15,  -30.2,   31,   24, false, false ) )
        ( twinrx_gain_config_t(     16,  -29.2,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     17,  -28.2,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     18,  -27.2,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     19,  -26.2,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     20,  -25.2,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     21,  -24.2,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     22,  -23.2,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     23,  -22.2,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     24,  -21.2,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     25,  -20.2,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     26,  -19.2,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     27,  -18.2,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     28,  -17.2,   31,   11, false, false ) )
        ( twinrx_gain_config_t(     29,  -16.2,   31,   10, false, false ) )
        ( twinrx_gain_config_t(     30,  -15.2,   30,   10, false, false ) )
        ( twinrx_gain_config_t(     31,  -14.2,   30,    9, false, false ) )
        ( twinrx_gain_config_t(     32,  -13.2,   29,    9, false, false ) )
        ( twinrx_gain_config_t(     33,  -12.2,   28,    9, false, false ) )
        ( twinrx_gain_config_t(     34,  -11.2,   28,    8, false, false ) )
        ( twinrx_gain_config_t(     35,  -10.2,   27,    8, false, false ) )
        ( twinrx_gain_config_t(     36,   -9.2,   27,    7, false, false ) )
        ( twinrx_gain_config_t(     37,   -8.2,   26,    7, false, false ) )
        ( twinrx_gain_config_t(     38,   -7.2,   25,    7, false, false ) )
        ( twinrx_gain_config_t(     39,   -6.2,   24,    7, false, false ) )
        ( twinrx_gain_config_t(     40,   -5.2,   24,    6, false, false ) )
        ( twinrx_gain_config_t(     41,   -4.2,   23,    6, false, false ) )
        ( twinrx_gain_config_t(     42,   -3.2,   22,    6, false, false ) )
        ( twinrx_gain_config_t(     43,   -2.2,   21,    6, false, false ) )
        ( twinrx_gain_config_t(     44,   -1.2,   20,    6, false, false ) )
        ( twinrx_gain_config_t(     45,   -0.2,   19,    6, false, false ) )
        ( twinrx_gain_config_t(     46,    0.8,   18,    6, false, false ) )
        ( twinrx_gain_config_t(     47,    1.8,   17,    6, false, false ) )
        ( twinrx_gain_config_t(     48,    2.8,   16,    6, false, false ) )
        ( twinrx_gain_config_t(     49,    3.8,   16,    5, false, false ) )
        ( twinrx_gain_config_t(     50,    4.8,   15,    5, false, false ) )
        ( twinrx_gain_config_t(     51,    5.8,   14,    5, false, false ) )
        ( twinrx_gain_config_t(     52,    6.8,   13,    5, false, false ) )
        ( twinrx_gain_config_t(     53,    7.8,   12,    5, false, false ) )
        ( twinrx_gain_config_t(     54,    8.8,   11,    5, false, false ) )
        ( twinrx_gain_config_t(     55,    9.8,   10,    5, false, false ) )
        ( twinrx_gain_config_t(     56,   10.8,    9,    5, false, false ) )
        ( twinrx_gain_config_t(     57,   11.8,    8,    5, false, false ) )
        ( twinrx_gain_config_t(     58,   12.8,    7,    5, false, false ) )
        ( twinrx_gain_config_t(     59,   13.8,    6,    5, false, false ) )
        ( twinrx_gain_config_t(     60,   14.8,    5,    5, false, false ) )
        ( twinrx_gain_config_t(     61,   15.8,    4,    5, false, false ) )
        ( twinrx_gain_config_t(     62,   16.8,    3,    5, false, false ) )
        ( twinrx_gain_config_t(     63,   17.8,    2,    5, false, false ) )
        ( twinrx_gain_config_t(     64,   18.8,    1,    5, false, false ) )
        ( twinrx_gain_config_t(     65,   19.8,    0,    5, false, false ) )
        ( twinrx_gain_config_t(     66,   20.8,    0,    4, false, false ) )
        ( twinrx_gain_config_t(     67,   21.8,    0,    3, false, false ) )
        ( twinrx_gain_config_t(     68,   22.8,    0,    2, false, false ) )
        ( twinrx_gain_config_t(     69,   23.8,    0,    1, false, false ) )
        ( twinrx_gain_config_t(     70,   24.8,    0,    0, false, false ) )
        ( twinrx_gain_config_t(     71,   26.1,    0,    6, false,  true ) )
        ( twinrx_gain_config_t(     72,   26.1,    0,    6, false,  true ) )
        ( twinrx_gain_config_t(     73,   27.1,    0,    5, false,  true ) )
        ( twinrx_gain_config_t(     74,   28.1,    0,    4, false,  true ) )
        ( twinrx_gain_config_t(     75,   29.1,    0,    3, false,  true ) )
        ( twinrx_gain_config_t(     76,   30.1,    0,    2, false,  true ) )
        ( twinrx_gain_config_t(     77,   31.1,    0,    1, false,  true ) )
        ( twinrx_gain_config_t(     78,   32.1,    0,    0, false,  true ) )
        ( twinrx_gain_config_t(     79,   33.3,    0,    7,  true, false ) )
        ( twinrx_gain_config_t(     80,   34.3,    0,    6,  true, false ) )
        ( twinrx_gain_config_t(     81,   35.3,    0,    5,  true, false ) )
        ( twinrx_gain_config_t(     82,   36.3,    0,    4,  true, false ) )
        ( twinrx_gain_config_t(     83,   37.3,    0,    3,  true, false ) )
        ( twinrx_gain_config_t(     84,   38.3,    0,    2,  true, false ) )
        ( twinrx_gain_config_t(     85,   39.3,    0,    1,  true, false ) )
        ( twinrx_gain_config_t(     86,   40.3,    0,    0,  true, false ) )
        ( twinrx_gain_config_t(     87,   41.6,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   42.6,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   43.6,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   44.6,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   45.6,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   46.6,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   47.6,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> LOWBAND1_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -31.1,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -30.1,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      2,  -29.1,   31,   29, false, false ) )
        ( twinrx_gain_config_t(      3,  -28.1,   31,   28, false, false ) )
        ( twinrx_gain_config_t(      4,  -27.1,   31,   27, false, false ) )
        ( twinrx_gain_config_t(      5,  -26.1,   31,   26, false, false ) )
        ( twinrx_gain_config_t(      6,  -25.1,   31,   25, false, false ) )
        ( twinrx_gain_config_t(      7,  -24.1,   31,   24, false, false ) )
        ( twinrx_gain_config_t(      8,  -23.1,   31,   23, false, false ) )
        ( twinrx_gain_config_t(      9,  -22.1,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     10,  -21.1,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     11,  -20.1,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     12,  -19.1,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     13,  -18.1,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     14,  -17.1,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     15,  -16.1,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     16,  -15.1,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     17,  -14.1,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     18,  -13.1,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     19,  -12.1,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     20,  -11.1,   31,   11, false, false ) )
        ( twinrx_gain_config_t(     21,  -10.1,   31,   10, false, false ) )
        ( twinrx_gain_config_t(     22,   -9.1,   31,    9, false, false ) )
        ( twinrx_gain_config_t(     23,   -8.1,   31,    8, false, false ) )
        ( twinrx_gain_config_t(     24,   -7.1,   31,    7, false, false ) )
        ( twinrx_gain_config_t(     25,   -6.1,   31,    6, false, false ) )
        ( twinrx_gain_config_t(     26,   -5.1,   31,    5, false, false ) )
        ( twinrx_gain_config_t(     27,   -4.1,   31,    4, false, false ) )
        ( twinrx_gain_config_t(     28,   -3.1,   31,    3, false, false ) )
        ( twinrx_gain_config_t(     29,   -2.1,   31,    2, false, false ) )
        ( twinrx_gain_config_t(     30,   -1.1,   31,    1, false, false ) )
        ( twinrx_gain_config_t(     31,   -0.1,   31,    0, false, false ) )
        ( twinrx_gain_config_t(     32,    0.9,   30,    0, false, false ) )
        ( twinrx_gain_config_t(     33,    1.9,   29,    0, false, false ) )
        ( twinrx_gain_config_t(     34,    2.9,   28,    0, false, false ) )
        ( twinrx_gain_config_t(     35,    3.9,   27,    0, false, false ) )
        ( twinrx_gain_config_t(     36,    4.9,   26,    0, false, false ) )
        ( twinrx_gain_config_t(     37,    5.9,   25,    0, false, false ) )
        ( twinrx_gain_config_t(     38,    6.9,   24,    0, false, false ) )
        ( twinrx_gain_config_t(     39,    7.9,   23,    0, false, false ) )
        ( twinrx_gain_config_t(     40,    8.9,   22,    0, false, false ) )
        ( twinrx_gain_config_t(     41,    9.9,   21,    0, false, false ) )
        ( twinrx_gain_config_t(     42,   10.9,   20,    0, false, false ) )
        ( twinrx_gain_config_t(     43,   11.9,   19,    0, false, false ) )
        ( twinrx_gain_config_t(     44,   12.9,   18,    0, false, false ) )
        ( twinrx_gain_config_t(     45,   13.9,   17,    0, false, false ) )
        ( twinrx_gain_config_t(     46,   14.9,   16,    0, false, false ) )
        ( twinrx_gain_config_t(     47,   15.9,   15,    0, false, false ) )
        ( twinrx_gain_config_t(     48,   16.9,   14,    0, false, false ) )
        ( twinrx_gain_config_t(     49,   17.9,   13,    0, false, false ) )
        ( twinrx_gain_config_t(     50,   18.9,   12,    0, false, false ) )
        ( twinrx_gain_config_t(     51,   19.9,   11,    0, false, false ) )
        ( twinrx_gain_config_t(     52,   20.9,   10,    0, false, false ) )
        ( twinrx_gain_config_t(     53,   21.9,    9,    0, false, false ) )
        ( twinrx_gain_config_t(     54,   22.9,    8,    0, false, false ) )
        ( twinrx_gain_config_t(     55,   23.9,    7,    0, false, false ) )
        ( twinrx_gain_config_t(     56,   24.9,    6,    0, false, false ) )
        ( twinrx_gain_config_t(     57,   25.9,    5,    0, false, false ) )
        ( twinrx_gain_config_t(     58,   26.9,    4,    0, false, false ) )
        ( twinrx_gain_config_t(     59,   27.9,    3,    0, false, false ) )
        ( twinrx_gain_config_t(     60,   28.9,    2,    0, false, false ) )
        ( twinrx_gain_config_t(     61,   29.9,    1,    0, false, false ) )
        ( twinrx_gain_config_t(     62,   30.9,    0,    0, false, false ) )
        ( twinrx_gain_config_t(     63,   31.2,    4,   11, false,  true ) )
        ( twinrx_gain_config_t(     64,   32.2,    3,   11, false,  true ) )
        ( twinrx_gain_config_t(     65,   33.2,    2,   11, false,  true ) )
        ( twinrx_gain_config_t(     66,   34.2,    1,   11, false,  true ) )
        ( twinrx_gain_config_t(     67,   35.2,    0,   11, false,  true ) )
        ( twinrx_gain_config_t(     68,   36.2,   10,    0,  true, false ) )
        ( twinrx_gain_config_t(     69,   37.2,    9,    0,  true, false ) )
        ( twinrx_gain_config_t(     70,   38.2,    8,    0,  true, false ) )
        ( twinrx_gain_config_t(     71,   39.2,    7,    0,  true, false ) )
        ( twinrx_gain_config_t(     72,   40.2,    6,    0,  true, false ) )
        ( twinrx_gain_config_t(     73,   41.2,    5,    0,  true, false ) )
        ( twinrx_gain_config_t(     74,   42.2,    4,    0,  true, false ) )
        ( twinrx_gain_config_t(     75,   43.2,    3,    0,  true, false ) )
        ( twinrx_gain_config_t(     76,   44.2,    2,    0,  true, false ) )
        ( twinrx_gain_config_t(     77,   45.2,    1,    0,  true, false ) )
        ( twinrx_gain_config_t(     78,   46.2,    0,    0,  true, false ) )
        ( twinrx_gain_config_t(     79,   47.5,    4,   10,  true,  true ) )
        ( twinrx_gain_config_t(     80,   48.5,    3,   10,  true,  true ) )
        ( twinrx_gain_config_t(     81,   49.5,    3,    9,  true,  true ) )
        ( twinrx_gain_config_t(     82,   50.5,    2,    9,  true,  true ) )
        ( twinrx_gain_config_t(     83,   51.5,    1,    9,  true,  true ) )
        ( twinrx_gain_config_t(     84,   52.5,    1,    8,  true,  true ) )
        ( twinrx_gain_config_t(     85,   53.5,    0,    8,  true,  true ) )
        ( twinrx_gain_config_t(     86,   54.5,    0,    7,  true,  true ) )
        ( twinrx_gain_config_t(     87,   55.5,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   56.5,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   57.5,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   58.5,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   59.5,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   60.5,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   61.5,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> LOWBAND2_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -33.4,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -33.4,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -32.4,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      3,  -31.4,   31,   29, false, false ) )
        ( twinrx_gain_config_t(      4,  -30.4,   31,   28, false, false ) )
        ( twinrx_gain_config_t(      5,  -29.4,   31,   27, false, false ) )
        ( twinrx_gain_config_t(      6,  -28.4,   31,   26, false, false ) )
        ( twinrx_gain_config_t(      7,  -27.4,   31,   25, false, false ) )
        ( twinrx_gain_config_t(      8,  -26.4,   31,   24, false, false ) )
        ( twinrx_gain_config_t(      9,  -25.4,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     10,  -24.4,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     11,  -23.4,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     12,  -22.4,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     13,  -21.4,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     14,  -20.4,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     15,  -19.4,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     16,  -18.4,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     17,  -17.4,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     18,  -16.4,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     19,  -15.4,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     20,  -14.4,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     21,  -13.4,   31,   11, false, false ) )
        ( twinrx_gain_config_t(     22,  -12.4,   31,   10, false, false ) )
        ( twinrx_gain_config_t(     23,  -11.4,   31,    9, false, false ) )
        ( twinrx_gain_config_t(     24,  -10.4,   31,    8, false, false ) )
        ( twinrx_gain_config_t(     25,   -9.4,   31,    7, false, false ) )
        ( twinrx_gain_config_t(     26,   -8.4,   31,    6, false, false ) )
        ( twinrx_gain_config_t(     27,   -7.4,   31,    5, false, false ) )
        ( twinrx_gain_config_t(     28,   -6.4,   31,    4, false, false ) )
        ( twinrx_gain_config_t(     29,   -5.4,   31,    3, false, false ) )
        ( twinrx_gain_config_t(     30,   -4.4,   31,    2, false, false ) )
        ( twinrx_gain_config_t(     31,   -3.4,   31,    1, false, false ) )
        ( twinrx_gain_config_t(     32,   -2.4,   31,    0, false, false ) )
        ( twinrx_gain_config_t(     33,   -1.4,   30,    0, false, false ) )
        ( twinrx_gain_config_t(     34,   -0.4,   29,    0, false, false ) )
        ( twinrx_gain_config_t(     35,    0.6,   28,    0, false, false ) )
        ( twinrx_gain_config_t(     36,    1.6,   27,    0, false, false ) )
        ( twinrx_gain_config_t(     37,    2.6,   26,    0, false, false ) )
        ( twinrx_gain_config_t(     38,    3.6,   25,    0, false, false ) )
        ( twinrx_gain_config_t(     39,    4.6,   24,    0, false, false ) )
        ( twinrx_gain_config_t(     40,    5.6,   23,    0, false, false ) )
        ( twinrx_gain_config_t(     41,    6.6,   22,    0, false, false ) )
        ( twinrx_gain_config_t(     42,    7.6,   21,    0, false, false ) )
        ( twinrx_gain_config_t(     43,    8.6,   20,    0, false, false ) )
        ( twinrx_gain_config_t(     44,    9.6,   19,    0, false, false ) )
        ( twinrx_gain_config_t(     45,   10.6,   18,    0, false, false ) )
        ( twinrx_gain_config_t(     46,   11.6,   17,    0, false, false ) )
        ( twinrx_gain_config_t(     47,   12.6,   16,    0, false, false ) )
        ( twinrx_gain_config_t(     48,   13.6,   15,    0, false, false ) )
        ( twinrx_gain_config_t(     49,   14.6,   14,    0, false, false ) )
        ( twinrx_gain_config_t(     50,   15.6,   13,    0, false, false ) )
        ( twinrx_gain_config_t(     51,   16.6,   12,    0, false, false ) )
        ( twinrx_gain_config_t(     52,   17.6,   11,    0, false, false ) )
        ( twinrx_gain_config_t(     53,   18.6,   10,    0, false, false ) )
        ( twinrx_gain_config_t(     54,   19.6,    9,    0, false, false ) )
        ( twinrx_gain_config_t(     55,   20.6,    8,    0, false, false ) )
        ( twinrx_gain_config_t(     56,   21.6,    7,    0, false, false ) )
        ( twinrx_gain_config_t(     57,   22.6,    6,    0, false, false ) )
        ( twinrx_gain_config_t(     58,   23.6,    5,    0, false, false ) )
        ( twinrx_gain_config_t(     59,   24.6,    4,    0, false, false ) )
        ( twinrx_gain_config_t(     60,   25.6,    3,    0, false, false ) )
        ( twinrx_gain_config_t(     61,   26.6,    2,    0, false, false ) )
        ( twinrx_gain_config_t(     62,   27.6,    1,    0, false, false ) )
        ( twinrx_gain_config_t(     63,   28.6,    0,    0, false, false ) )
        ( twinrx_gain_config_t(     64,   29.7,    5,    9, false,  true ) )
        ( twinrx_gain_config_t(     65,   30.7,    4,    9, false,  true ) )
        ( twinrx_gain_config_t(     66,   31.7,    3,    9, false,  true ) )
        ( twinrx_gain_config_t(     67,   32.7,    2,    9, false,  true ) )
        ( twinrx_gain_config_t(     68,   33.7,    1,    9, false,  true ) )
        ( twinrx_gain_config_t(     69,   34.7,    0,    9, false,  true ) )
        ( twinrx_gain_config_t(     70,   35.7,    0,    8, false,  true ) )
        ( twinrx_gain_config_t(     71,   36.7,    7,    0,  true, false ) )
        ( twinrx_gain_config_t(     72,   37.7,    6,    0,  true, false ) )
        ( twinrx_gain_config_t(     73,   38.7,    5,    0,  true, false ) )
        ( twinrx_gain_config_t(     74,   39.7,    4,    0,  true, false ) )
        ( twinrx_gain_config_t(     75,   40.7,    3,    0,  true, false ) )
        ( twinrx_gain_config_t(     76,   41.7,    2,    0,  true, false ) )
        ( twinrx_gain_config_t(     77,   42.7,    1,    0,  true, false ) )
        ( twinrx_gain_config_t(     78,   43.7,    0,    0,  true, false ) )
        ( twinrx_gain_config_t(     79,   44.8,    6,    8,  true,  true ) )
        ( twinrx_gain_config_t(     80,   45.8,    5,    8,  true,  true ) )
        ( twinrx_gain_config_t(     81,   46.8,    4,    8,  true,  true ) )
        ( twinrx_gain_config_t(     82,   47.8,    4,    7,  true,  true ) )
        ( twinrx_gain_config_t(     83,   48.8,    3,    7,  true,  true ) )
        ( twinrx_gain_config_t(     84,   49.8,    2,    7,  true,  true ) )
        ( twinrx_gain_config_t(     85,   50.8,    1,    7,  true,  true ) )
        ( twinrx_gain_config_t(     86,   51.8,    1,    6,  true,  true ) )
        ( twinrx_gain_config_t(     87,   52.8,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   53.8,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   54.8,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   55.8,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   56.8,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   57.8,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   58.8,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> LOWBAND3_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -34.0,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -34.0,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -34.0,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      3,  -33.0,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      4,  -32.0,   31,   29, false, false ) )
        ( twinrx_gain_config_t(      5,  -31.0,   31,   28, false, false ) )
        ( twinrx_gain_config_t(      6,  -30.0,   31,   27, false, false ) )
        ( twinrx_gain_config_t(      7,  -29.0,   31,   26, false, false ) )
        ( twinrx_gain_config_t(      8,  -28.0,   31,   25, false, false ) )
        ( twinrx_gain_config_t(      9,  -27.0,   31,   24, false, false ) )
        ( twinrx_gain_config_t(     10,  -26.0,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     11,  -25.0,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     12,  -24.0,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     13,  -23.0,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     14,  -22.0,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     15,  -21.0,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     16,  -20.0,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     17,  -19.0,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     18,  -18.0,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     19,  -17.0,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     20,  -16.0,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     21,  -15.0,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     22,  -14.0,   31,   11, false, false ) )
        ( twinrx_gain_config_t(     23,  -13.0,   31,   10, false, false ) )
        ( twinrx_gain_config_t(     24,  -12.0,   31,    9, false, false ) )
        ( twinrx_gain_config_t(     25,  -11.0,   31,    8, false, false ) )
        ( twinrx_gain_config_t(     26,  -10.0,   31,    7, false, false ) )
        ( twinrx_gain_config_t(     27,   -9.0,   31,    6, false, false ) )
        ( twinrx_gain_config_t(     28,   -8.0,   31,    5, false, false ) )
        ( twinrx_gain_config_t(     29,   -7.0,   31,    4, false, false ) )
        ( twinrx_gain_config_t(     30,   -6.0,   31,    3, false, false ) )
        ( twinrx_gain_config_t(     31,   -5.0,   31,    2, false, false ) )
        ( twinrx_gain_config_t(     32,   -4.0,   31,    1, false, false ) )
        ( twinrx_gain_config_t(     33,   -3.0,   31,    0, false, false ) )
        ( twinrx_gain_config_t(     34,   -2.0,   30,    0, false, false ) )
        ( twinrx_gain_config_t(     35,   -1.0,   29,    0, false, false ) )
        ( twinrx_gain_config_t(     36,   -0.0,   28,    0, false, false ) )
        ( twinrx_gain_config_t(     37,    1.0,   27,    0, false, false ) )
        ( twinrx_gain_config_t(     38,    2.0,   26,    0, false, false ) )
        ( twinrx_gain_config_t(     39,    3.0,   25,    0, false, false ) )
        ( twinrx_gain_config_t(     40,    4.0,   24,    0, false, false ) )
        ( twinrx_gain_config_t(     41,    5.0,   23,    0, false, false ) )
        ( twinrx_gain_config_t(     42,    6.0,   22,    0, false, false ) )
        ( twinrx_gain_config_t(     43,    7.0,   21,    0, false, false ) )
        ( twinrx_gain_config_t(     44,    8.0,   20,    0, false, false ) )
        ( twinrx_gain_config_t(     45,    9.0,   19,    0, false, false ) )
        ( twinrx_gain_config_t(     46,   10.0,   18,    0, false, false ) )
        ( twinrx_gain_config_t(     47,   11.0,   17,    0, false, false ) )
        ( twinrx_gain_config_t(     48,   12.0,   16,    0, false, false ) )
        ( twinrx_gain_config_t(     49,   13.0,   15,    0, false, false ) )
        ( twinrx_gain_config_t(     50,   14.0,   14,    0, false, false ) )
        ( twinrx_gain_config_t(     51,   15.0,   13,    0, false, false ) )
        ( twinrx_gain_config_t(     52,   16.0,   12,    0, false, false ) )
        ( twinrx_gain_config_t(     53,   17.0,   11,    0, false, false ) )
        ( twinrx_gain_config_t(     54,   18.0,   10,    0, false, false ) )
        ( twinrx_gain_config_t(     55,   19.0,    9,    0, false, false ) )
        ( twinrx_gain_config_t(     56,   20.0,    8,    0, false, false ) )
        ( twinrx_gain_config_t(     57,   21.0,    7,    0, false, false ) )
        ( twinrx_gain_config_t(     58,   22.0,    6,    0, false, false ) )
        ( twinrx_gain_config_t(     59,   23.0,    5,    0, false, false ) )
        ( twinrx_gain_config_t(     60,   24.0,    4,    0, false, false ) )
        ( twinrx_gain_config_t(     61,   25.0,    3,    0, false, false ) )
        ( twinrx_gain_config_t(     62,   26.0,    2,    0, false, false ) )
        ( twinrx_gain_config_t(     63,   27.0,    1,    0, false, false ) )
        ( twinrx_gain_config_t(     64,   28.0,    0,    0, false, false ) )
        ( twinrx_gain_config_t(     65,   29.5,    5,    8, false,  true ) )
        ( twinrx_gain_config_t(     66,   30.5,    4,    8, false,  true ) )
        ( twinrx_gain_config_t(     67,   31.5,    3,    8, false,  true ) )
        ( twinrx_gain_config_t(     68,   32.5,    2,    8, false,  true ) )
        ( twinrx_gain_config_t(     69,   33.5,    1,    8, false,  true ) )
        ( twinrx_gain_config_t(     70,   34.5,    0,    8, false,  true ) )
        ( twinrx_gain_config_t(     71,   34.5,    0,    8, false,  true ) )
        ( twinrx_gain_config_t(     72,   36.5,    6,    0,  true, false ) )
        ( twinrx_gain_config_t(     73,   36.5,    6,    0,  true, false ) )
        ( twinrx_gain_config_t(     74,   37.5,    5,    0,  true, false ) )
        ( twinrx_gain_config_t(     75,   38.5,    4,    0,  true, false ) )
        ( twinrx_gain_config_t(     76,   39.5,    3,    0,  true, false ) )
        ( twinrx_gain_config_t(     77,   40.5,    2,    0,  true, false ) )
        ( twinrx_gain_config_t(     78,   41.5,    1,    0,  true, false ) )
        ( twinrx_gain_config_t(     79,   42.5,    0,    0,  true, false ) )
        ( twinrx_gain_config_t(     80,   44.0,    6,    7,  true,  true ) )
        ( twinrx_gain_config_t(     81,   45.0,    5,    7,  true,  true ) )
        ( twinrx_gain_config_t(     82,   46.0,    4,    7,  true,  true ) )
        ( twinrx_gain_config_t(     83,   47.0,    3,    7,  true,  true ) )
        ( twinrx_gain_config_t(     84,   48.0,    3,    6,  true,  true ) )
        ( twinrx_gain_config_t(     85,   49.0,    2,    6,  true,  true ) )
        ( twinrx_gain_config_t(     86,   50.0,    1,    6,  true,  true ) )
        ( twinrx_gain_config_t(     87,   51.0,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   52.0,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   53.0,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   54.0,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   55.0,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   56.0,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   57.0,    0,    0,  true,  true ) )
;

static const std::vector<twinrx_gain_config_t> LOWBAND4_TABLE = boost::assign::list_of
        //                       Index,   Gain, Atten1, Atten2,  Amp1,  Amp2
        ( twinrx_gain_config_t(      0,  -32.8,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      1,  -32.8,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      2,  -32.8,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      3,  -32.8,   31,   31, false, false ) )
        ( twinrx_gain_config_t(      4,  -31.8,   31,   30, false, false ) )
        ( twinrx_gain_config_t(      5,  -30.8,   31,   29, false, false ) )
        ( twinrx_gain_config_t(      6,  -29.8,   31,   28, false, false ) )
        ( twinrx_gain_config_t(      7,  -28.8,   31,   27, false, false ) )
        ( twinrx_gain_config_t(      8,  -27.8,   31,   26, false, false ) )
        ( twinrx_gain_config_t(      9,  -26.8,   31,   25, false, false ) )
        ( twinrx_gain_config_t(     10,  -25.8,   31,   24, false, false ) )
        ( twinrx_gain_config_t(     11,  -24.8,   31,   23, false, false ) )
        ( twinrx_gain_config_t(     12,  -23.8,   31,   22, false, false ) )
        ( twinrx_gain_config_t(     13,  -22.8,   31,   21, false, false ) )
        ( twinrx_gain_config_t(     14,  -21.8,   31,   20, false, false ) )
        ( twinrx_gain_config_t(     15,  -20.8,   31,   19, false, false ) )
        ( twinrx_gain_config_t(     16,  -19.8,   31,   18, false, false ) )
        ( twinrx_gain_config_t(     17,  -18.8,   31,   17, false, false ) )
        ( twinrx_gain_config_t(     18,  -17.8,   31,   16, false, false ) )
        ( twinrx_gain_config_t(     19,  -16.8,   31,   15, false, false ) )
        ( twinrx_gain_config_t(     20,  -15.8,   31,   14, false, false ) )
        ( twinrx_gain_config_t(     21,  -14.8,   31,   13, false, false ) )
        ( twinrx_gain_config_t(     22,  -13.8,   31,   12, false, false ) )
        ( twinrx_gain_config_t(     23,  -12.8,   31,   11, false, false ) )
        ( twinrx_gain_config_t(     24,  -11.8,   31,   10, false, false ) )
        ( twinrx_gain_config_t(     25,  -10.8,   31,    9, false, false ) )
        ( twinrx_gain_config_t(     26,   -9.8,   31,    8, false, false ) )
        ( twinrx_gain_config_t(     27,   -8.8,   31,    7, false, false ) )
        ( twinrx_gain_config_t(     28,   -7.8,   31,    6, false, false ) )
        ( twinrx_gain_config_t(     29,   -6.8,   31,    5, false, false ) )
        ( twinrx_gain_config_t(     30,   -5.8,   31,    4, false, false ) )
        ( twinrx_gain_config_t(     31,   -4.8,   31,    3, false, false ) )
        ( twinrx_gain_config_t(     32,   -3.8,   31,    2, false, false ) )
        ( twinrx_gain_config_t(     33,   -2.8,   31,    1, false, false ) )
        ( twinrx_gain_config_t(     34,   -1.8,   31,    0, false, false ) )
        ( twinrx_gain_config_t(     35,   -0.8,   30,    0, false, false ) )
        ( twinrx_gain_config_t(     36,    0.2,   29,    0, false, false ) )
        ( twinrx_gain_config_t(     37,    1.2,   28,    0, false, false ) )
        ( twinrx_gain_config_t(     38,    2.2,   27,    0, false, false ) )
        ( twinrx_gain_config_t(     39,    3.2,   26,    0, false, false ) )
        ( twinrx_gain_config_t(     40,    4.2,   25,    0, false, false ) )
        ( twinrx_gain_config_t(     41,    5.2,   24,    0, false, false ) )
        ( twinrx_gain_config_t(     42,    6.2,   23,    0, false, false ) )
        ( twinrx_gain_config_t(     43,    7.2,   22,    0, false, false ) )
        ( twinrx_gain_config_t(     44,    8.2,   21,    0, false, false ) )
        ( twinrx_gain_config_t(     45,    9.2,   20,    0, false, false ) )
        ( twinrx_gain_config_t(     46,   10.2,   19,    0, false, false ) )
        ( twinrx_gain_config_t(     47,   11.2,   18,    0, false, false ) )
        ( twinrx_gain_config_t(     48,   12.2,   17,    0, false, false ) )
        ( twinrx_gain_config_t(     49,   13.2,   16,    0, false, false ) )
        ( twinrx_gain_config_t(     50,   14.2,   15,    0, false, false ) )
        ( twinrx_gain_config_t(     51,   15.2,   14,    0, false, false ) )
        ( twinrx_gain_config_t(     52,   16.2,   13,    0, false, false ) )
        ( twinrx_gain_config_t(     53,   17.2,   12,    0, false, false ) )
        ( twinrx_gain_config_t(     54,   18.2,   11,    0, false, false ) )
        ( twinrx_gain_config_t(     55,   19.2,   10,    0, false, false ) )
        ( twinrx_gain_config_t(     56,   20.2,    9,    0, false, false ) )
        ( twinrx_gain_config_t(     57,   21.2,    8,    0, false, false ) )
        ( twinrx_gain_config_t(     58,   22.2,    7,    0, false, false ) )
        ( twinrx_gain_config_t(     59,   23.2,    6,    0, false, false ) )
        ( twinrx_gain_config_t(     60,   24.2,    5,    0, false, false ) )
        ( twinrx_gain_config_t(     61,   25.2,    4,    0, false, false ) )
        ( twinrx_gain_config_t(     62,   26.2,    3,    0, false, false ) )
        ( twinrx_gain_config_t(     63,   27.2,    2,    0, false, false ) )
        ( twinrx_gain_config_t(     64,   28.2,    1,    0, false, false ) )
        ( twinrx_gain_config_t(     65,   29.2,    0,    0, false, false ) )
        ( twinrx_gain_config_t(     66,   30.4,    4,    9, false,  true ) )
        ( twinrx_gain_config_t(     67,   31.4,    3,    9, false,  true ) )
        ( twinrx_gain_config_t(     68,   32.4,    2,    9, false,  true ) )
        ( twinrx_gain_config_t(     69,   33.4,    1,    9, false,  true ) )
        ( twinrx_gain_config_t(     70,   34.4,    0,    9, false,  true ) )
        ( twinrx_gain_config_t(     71,   35.4,    8,    0,  true, false ) )
        ( twinrx_gain_config_t(     72,   36.4,    7,    0,  true, false ) )
        ( twinrx_gain_config_t(     73,   37.4,    6,    0,  true, false ) )
        ( twinrx_gain_config_t(     74,   38.4,    5,    0,  true, false ) )
        ( twinrx_gain_config_t(     75,   39.4,    4,    0,  true, false ) )
        ( twinrx_gain_config_t(     76,   40.4,    3,    0,  true, false ) )
        ( twinrx_gain_config_t(     77,   41.4,    2,    0,  true, false ) )
        ( twinrx_gain_config_t(     78,   42.4,    1,    0,  true, false ) )
        ( twinrx_gain_config_t(     79,   43.4,    0,    0,  true, false ) )
        ( twinrx_gain_config_t(     80,   44.6,    4,    9,  true,  true ) )
        ( twinrx_gain_config_t(     81,   45.6,    4,    8,  true,  true ) )
        ( twinrx_gain_config_t(     82,   46.6,    3,    8,  true,  true ) )
        ( twinrx_gain_config_t(     83,   47.6,    2,    8,  true,  true ) )
        ( twinrx_gain_config_t(     84,   48.6,    1,    8,  true,  true ) )
        ( twinrx_gain_config_t(     85,   49.6,    1,    7,  true,  true ) )
        ( twinrx_gain_config_t(     86,   50.6,    0,    7,  true,  true ) )
        ( twinrx_gain_config_t(     87,   51.6,    0,    6,  true,  true ) )
        ( twinrx_gain_config_t(     88,   52.6,    0,    5,  true,  true ) )
        ( twinrx_gain_config_t(     89,   53.6,    0,    4,  true,  true ) )
        ( twinrx_gain_config_t(     90,   54.6,    0,    3,  true,  true ) )
        ( twinrx_gain_config_t(     91,   55.6,    0,    2,  true,  true ) )
        ( twinrx_gain_config_t(     92,   56.6,    0,    1,  true,  true ) )
        ( twinrx_gain_config_t(     93,   57.6,    0,    0,  true,  true ) )
;

const twinrx_gain_table twinrx_gain_table::lookup_table
(
    twinrx_ctrl::signal_path_t signal_path,
    twinrx_ctrl::preselector_path_t preselector_path,
    std::string
) {

    if (signal_path == twinrx_ctrl::PATH_HIGHBAND) {
        switch (preselector_path) {
            case twinrx_ctrl::PRESEL_PATH1:
                return twinrx_gain_table(HIGHBAND1_TABLE);
            case twinrx_ctrl::PRESEL_PATH2:
                return twinrx_gain_table(HIGHBAND2_TABLE);
            case twinrx_ctrl::PRESEL_PATH3:
                return twinrx_gain_table(HIGHBAND3_TABLE);
            case twinrx_ctrl::PRESEL_PATH4:
                return twinrx_gain_table(HIGHBAND4_TABLE);
        }
    } else {
        switch (preselector_path) {
            case twinrx_ctrl::PRESEL_PATH1:
                return twinrx_gain_table(LOWBAND1_TABLE);
            case twinrx_ctrl::PRESEL_PATH2:
                return twinrx_gain_table(LOWBAND2_TABLE);
            case twinrx_ctrl::PRESEL_PATH3:
                return twinrx_gain_table(LOWBAND3_TABLE);
            case twinrx_ctrl::PRESEL_PATH4:
                return twinrx_gain_table(LOWBAND4_TABLE);
        }
    }
    throw runtime_error("NO GAIN TABLE SELECTED");
    return twinrx_gain_table(HIGHBAND1_TABLE);
}

const twinrx_gain_config_t& twinrx_gain_table::find_by_index(size_t index) const {
    if (index >= get_num_entries()) throw uhd::value_error("invalid gain table index");
    return _tbl.at(index);
}

uhd::gain_range_t twinrx_gain_table::get_gain_range() const {
    double max = std::numeric_limits<double>::min();
    double min = std::numeric_limits<double>::max();
    for (size_t i = 0; i < get_num_entries(); i++) {
        const twinrx_gain_config_t& config = find_by_index(i);
        if (config.sys_gain > max) {
            max = config.sys_gain;
        }
        if (config.sys_gain < min) {
            min = config.sys_gain;
        }
    }
    return uhd::gain_range_t(min, max, 1.0);
}
