---------------------------------------------------------------------
--
-- Copyright 2021 Ettus Research, A National Instruments Brand
-- SPDX-License-Identifier: LGPL-3.0-or-later
--
-- Module: PkgRFDC_REGS_REGMAP.vhd
--
-- Purpose:
--   The constants in this file are autogenerated by XmlParse.
--
----------------------------------------------------------------------
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

package PkgRFDC_REGS_REGMAP is

--===============================================================================
-- A numerically ordered list of registers and their HDL source files
--===============================================================================

  -- MMCM                 : 0x0 (common_regs.v)
  -- INVERT_IQ_REG        : 0x10000 (common_regs.v)
  -- MMCM_RESET_REG       : 0x11000 (common_regs.v)
  -- RF_RESET_CONTROL_REG : 0x12000 (common_regs.v)
  -- RF_RESET_STATUS_REG  : 0x12008 (common_regs.v)
  -- RF_AXI_STATUS_REG    : 0x13000 (common_regs.v)
  -- FABRIC_DSP_REG       : 0x13008 (common_regs.v)
  -- CALIBRATION_DATA     : 0x14000 (common_regs.v)
  -- CALIBRATION_ENABLE   : 0x14008 (common_regs.v)
  -- THRESHOLD_STATUS     : 0x15000 (common_regs.v)
  -- RF_PLL_CONTROL_REG   : 0x16000 (common_regs.v)
  -- RF_PLL_STATUS_REG    : 0x16008 (common_regs.v)

--===============================================================================
-- RegTypes
--===============================================================================

--===============================================================================
-- Register Group RFDC_REGS
--===============================================================================

  -- Enumerated type FABRIC_DSP_BW_ENUM
  constant kFABRIC_DSP_BW_ENUMSize : integer := 4;
  constant kFABRIC_DSP_BW_NONE : integer := 0;  -- FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_NONE
  constant kFABRIC_DSP_BW_100M : integer := 100;  -- FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_100M
  constant kFABRIC_DSP_BW_200M : integer := 200;  -- FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_200M
  constant kFABRIC_DSP_BW_400M : integer := 400;  -- FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_400M

  -- MMCM Window (from common_regs.v)
  constant kMMCM : integer := 16#0#; -- Window Offset
  constant kMMCMSize: integer := 16#10000#;  -- size in bytes
  --function kMMCMRec return XReg2_t; -- Window Record function commented out due to programmable attributes

  -- INVERT_IQ_REG Register (from common_regs.v)
  constant kINVERT_IQ_REG : integer := 16#10000#; -- Register Offset
  constant kINVERT_IQ_REGSize: integer := 32;  -- register width in bits
  constant kINVERT_IQ_REGMask : std_logic_vector(31 downto 0) := X"0000ffff";
  constant kINVERT_DB0_ADC0_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_ADC0_IQ
  constant kINVERT_DB0_ADC0_IQMsb        : integer := 0;  --INVERT_IQ_REG:INVERT_DB0_ADC0_IQ
  constant kINVERT_DB0_ADC0_IQ           : integer := 0;  --INVERT_IQ_REG:INVERT_DB0_ADC0_IQ
  constant kINVERT_DB0_ADC1_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_ADC1_IQ
  constant kINVERT_DB0_ADC1_IQMsb        : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_ADC1_IQ
  constant kINVERT_DB0_ADC1_IQ           : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_ADC1_IQ
  constant kINVERT_DB0_ADC2_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_ADC2_IQ
  constant kINVERT_DB0_ADC2_IQMsb        : integer := 2;  --INVERT_IQ_REG:INVERT_DB0_ADC2_IQ
  constant kINVERT_DB0_ADC2_IQ           : integer := 2;  --INVERT_IQ_REG:INVERT_DB0_ADC2_IQ
  constant kINVERT_DB0_ADC3_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_ADC3_IQ
  constant kINVERT_DB0_ADC3_IQMsb        : integer := 3;  --INVERT_IQ_REG:INVERT_DB0_ADC3_IQ
  constant kINVERT_DB0_ADC3_IQ           : integer := 3;  --INVERT_IQ_REG:INVERT_DB0_ADC3_IQ
  constant kINVERT_DB1_ADC0_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB1_ADC0_IQ
  constant kINVERT_DB1_ADC0_IQMsb        : integer := 4;  --INVERT_IQ_REG:INVERT_DB1_ADC0_IQ
  constant kINVERT_DB1_ADC0_IQ           : integer := 4;  --INVERT_IQ_REG:INVERT_DB1_ADC0_IQ
  constant kINVERT_DB1_ADC1_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB1_ADC1_IQ
  constant kINVERT_DB1_ADC1_IQMsb        : integer := 5;  --INVERT_IQ_REG:INVERT_DB1_ADC1_IQ
  constant kINVERT_DB1_ADC1_IQ           : integer := 5;  --INVERT_IQ_REG:INVERT_DB1_ADC1_IQ
  constant kINVERT_DB1_ADC2_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB1_ADC2_IQ
  constant kINVERT_DB1_ADC2_IQMsb        : integer := 6;  --INVERT_IQ_REG:INVERT_DB1_ADC2_IQ
  constant kINVERT_DB1_ADC2_IQ           : integer := 6;  --INVERT_IQ_REG:INVERT_DB1_ADC2_IQ
  constant kINVERT_DB1_ADC3_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB1_ADC3_IQ
  constant kINVERT_DB1_ADC3_IQMsb        : integer := 7;  --INVERT_IQ_REG:INVERT_DB1_ADC3_IQ
  constant kINVERT_DB1_ADC3_IQ           : integer := 7;  --INVERT_IQ_REG:INVERT_DB1_ADC3_IQ
  constant kINVERT_DB0_DAC0_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_DAC0_IQ
  constant kINVERT_DB0_DAC0_IQMsb        : integer := 8;  --INVERT_IQ_REG:INVERT_DB0_DAC0_IQ
  constant kINVERT_DB0_DAC0_IQ           : integer := 8;  --INVERT_IQ_REG:INVERT_DB0_DAC0_IQ
  constant kINVERT_DB0_DAC1_IQSize       : integer := 1;  --INVERT_IQ_REG:INVERT_DB0_DAC1_IQ
  constant kINVERT_DB0_DAC1_IQMsb        : integer := 9;  --INVERT_IQ_REG:INVERT_DB0_DAC1_IQ
  constant kINVERT_DB0_DAC1_IQ           : integer := 9;  --INVERT_IQ_REG:INVERT_DB0_DAC1_IQ
  constant kINVERT_DB0_DAC2_IQSize       : integer :=  1;  --INVERT_IQ_REG:INVERT_DB0_DAC2_IQ
  constant kINVERT_DB0_DAC2_IQMsb        : integer := 10;  --INVERT_IQ_REG:INVERT_DB0_DAC2_IQ
  constant kINVERT_DB0_DAC2_IQ           : integer := 10;  --INVERT_IQ_REG:INVERT_DB0_DAC2_IQ
  constant kINVERT_DB0_DAC3_IQSize       : integer :=  1;  --INVERT_IQ_REG:INVERT_DB0_DAC3_IQ
  constant kINVERT_DB0_DAC3_IQMsb        : integer := 11;  --INVERT_IQ_REG:INVERT_DB0_DAC3_IQ
  constant kINVERT_DB0_DAC3_IQ           : integer := 11;  --INVERT_IQ_REG:INVERT_DB0_DAC3_IQ
  constant kINVERT_DB1_DAC0_IQSize       : integer :=  1;  --INVERT_IQ_REG:INVERT_DB1_DAC0_IQ
  constant kINVERT_DB1_DAC0_IQMsb        : integer := 12;  --INVERT_IQ_REG:INVERT_DB1_DAC0_IQ
  constant kINVERT_DB1_DAC0_IQ           : integer := 12;  --INVERT_IQ_REG:INVERT_DB1_DAC0_IQ
  constant kINVERT_DB1_DAC1_IQSize       : integer :=  1;  --INVERT_IQ_REG:INVERT_DB1_DAC1_IQ
  constant kINVERT_DB1_DAC1_IQMsb        : integer := 13;  --INVERT_IQ_REG:INVERT_DB1_DAC1_IQ
  constant kINVERT_DB1_DAC1_IQ           : integer := 13;  --INVERT_IQ_REG:INVERT_DB1_DAC1_IQ
  constant kINVERT_DB1_DAC2_IQSize       : integer :=  1;  --INVERT_IQ_REG:INVERT_DB1_DAC2_IQ
  constant kINVERT_DB1_DAC2_IQMsb        : integer := 14;  --INVERT_IQ_REG:INVERT_DB1_DAC2_IQ
  constant kINVERT_DB1_DAC2_IQ           : integer := 14;  --INVERT_IQ_REG:INVERT_DB1_DAC2_IQ
  constant kINVERT_DB1_DAC3_IQSize       : integer :=  1;  --INVERT_IQ_REG:INVERT_DB1_DAC3_IQ
  constant kINVERT_DB1_DAC3_IQMsb        : integer := 15;  --INVERT_IQ_REG:INVERT_DB1_DAC3_IQ
  constant kINVERT_DB1_DAC3_IQ           : integer := 15;  --INVERT_IQ_REG:INVERT_DB1_DAC3_IQ
  --function kINVERT_IQ_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- MMCM_RESET_REG Register (from common_regs.v)
  constant kMMCM_RESET_REG : integer := 16#11000#; -- Register Offset
  constant kMMCM_RESET_REGSize: integer := 32;  -- register width in bits
  constant kMMCM_RESET_REGMask : std_logic_vector(31 downto 0) := X"00000001";
  constant kRESET_MMCMSize       : integer := 1;  --MMCM_RESET_REG:RESET_MMCM
  constant kRESET_MMCMMsb        : integer := 0;  --MMCM_RESET_REG:RESET_MMCM
  constant kRESET_MMCM           : integer := 0;  --MMCM_RESET_REG:RESET_MMCM
  --function kMMCM_RESET_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- RF_RESET_CONTROL_REG Register (from common_regs.v)
  constant kRF_RESET_CONTROL_REG : integer := 16#12000#; -- Register Offset
  constant kRF_RESET_CONTROL_REGSize: integer := 32;  -- register width in bits
  constant kRF_RESET_CONTROL_REGMask : std_logic_vector(31 downto 0) := X"00000331";
  constant kFSM_RESETSize       : integer := 1;  --RF_RESET_CONTROL_REG:FSM_RESET
  constant kFSM_RESETMsb        : integer := 0;  --RF_RESET_CONTROL_REG:FSM_RESET
  constant kFSM_RESET           : integer := 0;  --RF_RESET_CONTROL_REG:FSM_RESET
  constant kADC_RESETSize       : integer := 1;  --RF_RESET_CONTROL_REG:ADC_RESET
  constant kADC_RESETMsb        : integer := 4;  --RF_RESET_CONTROL_REG:ADC_RESET
  constant kADC_RESET           : integer := 4;  --RF_RESET_CONTROL_REG:ADC_RESET
  constant kADC_ENABLESize       : integer := 1;  --RF_RESET_CONTROL_REG:ADC_ENABLE
  constant kADC_ENABLEMsb        : integer := 5;  --RF_RESET_CONTROL_REG:ADC_ENABLE
  constant kADC_ENABLE           : integer := 5;  --RF_RESET_CONTROL_REG:ADC_ENABLE
  constant kDAC_RESETSize       : integer := 1;  --RF_RESET_CONTROL_REG:DAC_RESET
  constant kDAC_RESETMsb        : integer := 8;  --RF_RESET_CONTROL_REG:DAC_RESET
  constant kDAC_RESET           : integer := 8;  --RF_RESET_CONTROL_REG:DAC_RESET
  constant kDAC_ENABLESize       : integer := 1;  --RF_RESET_CONTROL_REG:DAC_ENABLE
  constant kDAC_ENABLEMsb        : integer := 9;  --RF_RESET_CONTROL_REG:DAC_ENABLE
  constant kDAC_ENABLE           : integer := 9;  --RF_RESET_CONTROL_REG:DAC_ENABLE
  --function kRF_RESET_CONTROL_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- RF_RESET_STATUS_REG Register (from common_regs.v)
  constant kRF_RESET_STATUS_REG : integer := 16#12008#; -- Register Offset
  constant kRF_RESET_STATUS_REGSize: integer := 32;  -- register width in bits
  constant kRF_RESET_STATUS_REGMask : std_logic_vector(31 downto 0) := X"00000888";
  constant kFSM_RESET_DONESize       : integer := 1;  --RF_RESET_STATUS_REG:FSM_RESET_DONE
  constant kFSM_RESET_DONEMsb        : integer := 3;  --RF_RESET_STATUS_REG:FSM_RESET_DONE
  constant kFSM_RESET_DONE           : integer := 3;  --RF_RESET_STATUS_REG:FSM_RESET_DONE
  constant kADC_SEQ_DONESize       : integer := 1;  --RF_RESET_STATUS_REG:ADC_SEQ_DONE
  constant kADC_SEQ_DONEMsb        : integer := 7;  --RF_RESET_STATUS_REG:ADC_SEQ_DONE
  constant kADC_SEQ_DONE           : integer := 7;  --RF_RESET_STATUS_REG:ADC_SEQ_DONE
  constant kDAC_SEQ_DONESize       : integer :=  1;  --RF_RESET_STATUS_REG:DAC_SEQ_DONE
  constant kDAC_SEQ_DONEMsb        : integer := 11;  --RF_RESET_STATUS_REG:DAC_SEQ_DONE
  constant kDAC_SEQ_DONE           : integer := 11;  --RF_RESET_STATUS_REG:DAC_SEQ_DONE
  --function kRF_RESET_STATUS_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- RF_AXI_STATUS_REG Register (from common_regs.v)
  constant kRF_AXI_STATUS_REG : integer := 16#13000#; -- Register Offset
  constant kRF_AXI_STATUS_REGSize: integer := 32;  -- register width in bits
  constant kRF_AXI_STATUS_REGMask : std_logic_vector(31 downto 0) := X"ffffffff";
  constant kRFDC_DAC_TREADYSize       : integer := 2;  --RF_AXI_STATUS_REG:RFDC_DAC_TREADY
  constant kRFDC_DAC_TREADYMsb        : integer := 1;  --RF_AXI_STATUS_REG:RFDC_DAC_TREADY
  constant kRFDC_DAC_TREADY           : integer := 0;  --RF_AXI_STATUS_REG:RFDC_DAC_TREADY
  constant kRFDC_DAC_TVALIDSize       : integer := 2;  --RF_AXI_STATUS_REG:RFDC_DAC_TVALID
  constant kRFDC_DAC_TVALIDMsb        : integer := 3;  --RF_AXI_STATUS_REG:RFDC_DAC_TVALID
  constant kRFDC_DAC_TVALID           : integer := 2;  --RF_AXI_STATUS_REG:RFDC_DAC_TVALID
  constant kRFDC_ADC_Q_TREADYSize       : integer := 2;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TREADY
  constant kRFDC_ADC_Q_TREADYMsb        : integer := 5;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TREADY
  constant kRFDC_ADC_Q_TREADY           : integer := 4;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TREADY
  constant kRFDC_ADC_I_TREADYSize       : integer := 2;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TREADY
  constant kRFDC_ADC_I_TREADYMsb        : integer := 7;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TREADY
  constant kRFDC_ADC_I_TREADY           : integer := 6;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TREADY
  constant kRFDC_ADC_Q_TVALIDSize       : integer := 2;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TVALID
  constant kRFDC_ADC_Q_TVALIDMsb        : integer := 9;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TVALID
  constant kRFDC_ADC_Q_TVALID           : integer := 8;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TVALID
  constant kRFDC_ADC_I_TVALIDSize       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TVALID
  constant kRFDC_ADC_I_TVALIDMsb        : integer := 11;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TVALID
  constant kRFDC_ADC_I_TVALID           : integer := 10;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TVALID
  constant kUSER_ADC_TVALIDSize       : integer :=  2;  --RF_AXI_STATUS_REG:USER_ADC_TVALID
  constant kUSER_ADC_TVALIDMsb        : integer := 13;  --RF_AXI_STATUS_REG:USER_ADC_TVALID
  constant kUSER_ADC_TVALID           : integer := 12;  --RF_AXI_STATUS_REG:USER_ADC_TVALID
  constant kUSER_ADC_TREADYSize       : integer :=  2;  --RF_AXI_STATUS_REG:USER_ADC_TREADY
  constant kUSER_ADC_TREADYMsb        : integer := 15;  --RF_AXI_STATUS_REG:USER_ADC_TREADY
  constant kUSER_ADC_TREADY           : integer := 14;  --RF_AXI_STATUS_REG:USER_ADC_TREADY
  constant kRFDC_DAC_TREADY_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_DAC_TREADY_DB1
  constant kRFDC_DAC_TREADY_DB1Msb        : integer := 17;  --RF_AXI_STATUS_REG:RFDC_DAC_TREADY_DB1
  constant kRFDC_DAC_TREADY_DB1           : integer := 16;  --RF_AXI_STATUS_REG:RFDC_DAC_TREADY_DB1
  constant kRFDC_DAC_TVALID_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_DAC_TVALID_DB1
  constant kRFDC_DAC_TVALID_DB1Msb        : integer := 19;  --RF_AXI_STATUS_REG:RFDC_DAC_TVALID_DB1
  constant kRFDC_DAC_TVALID_DB1           : integer := 18;  --RF_AXI_STATUS_REG:RFDC_DAC_TVALID_DB1
  constant kRFDC_ADC_Q_TREADY_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TREADY_DB1
  constant kRFDC_ADC_Q_TREADY_DB1Msb        : integer := 21;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TREADY_DB1
  constant kRFDC_ADC_Q_TREADY_DB1           : integer := 20;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TREADY_DB1
  constant kRFDC_ADC_I_TREADY_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TREADY_DB1
  constant kRFDC_ADC_I_TREADY_DB1Msb        : integer := 23;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TREADY_DB1
  constant kRFDC_ADC_I_TREADY_DB1           : integer := 22;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TREADY_DB1
  constant kRFDC_ADC_Q_TVALID_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TVALID_DB1
  constant kRFDC_ADC_Q_TVALID_DB1Msb        : integer := 25;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TVALID_DB1
  constant kRFDC_ADC_Q_TVALID_DB1           : integer := 24;  --RF_AXI_STATUS_REG:RFDC_ADC_Q_TVALID_DB1
  constant kRFDC_ADC_I_TVALID_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TVALID_DB1
  constant kRFDC_ADC_I_TVALID_DB1Msb        : integer := 27;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TVALID_DB1
  constant kRFDC_ADC_I_TVALID_DB1           : integer := 26;  --RF_AXI_STATUS_REG:RFDC_ADC_I_TVALID_DB1
  constant kUSER_ADC_TVALID_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:USER_ADC_TVALID_DB1
  constant kUSER_ADC_TVALID_DB1Msb        : integer := 29;  --RF_AXI_STATUS_REG:USER_ADC_TVALID_DB1
  constant kUSER_ADC_TVALID_DB1           : integer := 28;  --RF_AXI_STATUS_REG:USER_ADC_TVALID_DB1
  constant kUSER_ADC_TREADY_DB1Size       : integer :=  2;  --RF_AXI_STATUS_REG:USER_ADC_TREADY_DB1
  constant kUSER_ADC_TREADY_DB1Msb        : integer := 31;  --RF_AXI_STATUS_REG:USER_ADC_TREADY_DB1
  constant kUSER_ADC_TREADY_DB1           : integer := 30;  --RF_AXI_STATUS_REG:USER_ADC_TREADY_DB1
  --function kRF_AXI_STATUS_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- FABRIC_DSP_REG Register (from common_regs.v)
  constant kFABRIC_DSP_REG : integer := 16#13008#; -- Register Offset
  constant kFABRIC_DSP_REGSize: integer := 32;  -- register width in bits
  constant kFABRIC_DSP_REGMask : std_logic_vector(31 downto 0) := X"ffffffff";
  constant kFABRIC_DSP_BWSize       : integer := 12;  --FABRIC_DSP_REG:FABRIC_DSP_BW
  constant kFABRIC_DSP_BWMsb        : integer := 11;  --FABRIC_DSP_REG:FABRIC_DSP_BW
  constant kFABRIC_DSP_BW           : integer :=  0;  --FABRIC_DSP_REG:FABRIC_DSP_BW
  constant kFABRIC_DSP_RX_CNTSize       : integer :=  2;  --FABRIC_DSP_REG:FABRIC_DSP_RX_CNT
  constant kFABRIC_DSP_RX_CNTMsb        : integer := 13;  --FABRIC_DSP_REG:FABRIC_DSP_RX_CNT
  constant kFABRIC_DSP_RX_CNT           : integer := 12;  --FABRIC_DSP_REG:FABRIC_DSP_RX_CNT
  constant kFABRIC_DSP_TX_CNTSize       : integer :=  2;  --FABRIC_DSP_REG:FABRIC_DSP_TX_CNT
  constant kFABRIC_DSP_TX_CNTMsb        : integer := 15;  --FABRIC_DSP_REG:FABRIC_DSP_TX_CNT
  constant kFABRIC_DSP_TX_CNT           : integer := 14;  --FABRIC_DSP_REG:FABRIC_DSP_TX_CNT
  constant kFABRIC_DSP_BW_DB1Size       : integer := 12;  --FABRIC_DSP_REG:FABRIC_DSP_BW_DB1
  constant kFABRIC_DSP_BW_DB1Msb        : integer := 27;  --FABRIC_DSP_REG:FABRIC_DSP_BW_DB1
  constant kFABRIC_DSP_BW_DB1           : integer := 16;  --FABRIC_DSP_REG:FABRIC_DSP_BW_DB1
  constant kFABRIC_DSP_RX_CNT_DB1Size       : integer :=  2;  --FABRIC_DSP_REG:FABRIC_DSP_RX_CNT_DB1
  constant kFABRIC_DSP_RX_CNT_DB1Msb        : integer := 29;  --FABRIC_DSP_REG:FABRIC_DSP_RX_CNT_DB1
  constant kFABRIC_DSP_RX_CNT_DB1           : integer := 28;  --FABRIC_DSP_REG:FABRIC_DSP_RX_CNT_DB1
  constant kFABRIC_DSP_TX_CNT_DB1Size       : integer :=  2;  --FABRIC_DSP_REG:FABRIC_DSP_TX_CNT_DB1
  constant kFABRIC_DSP_TX_CNT_DB1Msb        : integer := 31;  --FABRIC_DSP_REG:FABRIC_DSP_TX_CNT_DB1
  constant kFABRIC_DSP_TX_CNT_DB1           : integer := 30;  --FABRIC_DSP_REG:FABRIC_DSP_TX_CNT_DB1
  --function kFABRIC_DSP_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- CALIBRATION_DATA Register (from common_regs.v)
  constant kCALIBRATION_DATA : integer := 16#14000#; -- Register Offset
  constant kCALIBRATION_DATASize: integer := 32;  -- register width in bits
  constant kCALIBRATION_DATAMask : std_logic_vector(31 downto 0) := X"ffffffff";
  constant kI_DATASize       : integer := 16;  --CALIBRATION_DATA:I_DATA
  constant kI_DATAMsb        : integer := 15;  --CALIBRATION_DATA:I_DATA
  constant kI_DATA           : integer :=  0;  --CALIBRATION_DATA:I_DATA
  constant kQ_DATASize       : integer := 16;  --CALIBRATION_DATA:Q_DATA
  constant kQ_DATAMsb        : integer := 31;  --CALIBRATION_DATA:Q_DATA
  constant kQ_DATA           : integer := 16;  --CALIBRATION_DATA:Q_DATA
  --function kCALIBRATION_DATARec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- CALIBRATION_ENABLE Register (from common_regs.v)
  constant kCALIBRATION_ENABLE : integer := 16#14008#; -- Register Offset
  constant kCALIBRATION_ENABLESize: integer := 32;  -- register width in bits
  constant kCALIBRATION_ENABLEMask : std_logic_vector(31 downto 0) := X"00000033";
  constant kENABLE_CALIBRATION_DATA_0Size       : integer := 1;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_0
  constant kENABLE_CALIBRATION_DATA_0Msb        : integer := 0;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_0
  constant kENABLE_CALIBRATION_DATA_0           : integer := 0;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_0
  constant kENABLE_CALIBRATION_DATA_1Size       : integer := 1;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_1
  constant kENABLE_CALIBRATION_DATA_1Msb        : integer := 1;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_1
  constant kENABLE_CALIBRATION_DATA_1           : integer := 1;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_1
  constant kENABLE_CALIBRATION_DATA_2Size       : integer := 1;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_2
  constant kENABLE_CALIBRATION_DATA_2Msb        : integer := 4;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_2
  constant kENABLE_CALIBRATION_DATA_2           : integer := 4;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_2
  constant kENABLE_CALIBRATION_DATA_3Size       : integer := 1;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_3
  constant kENABLE_CALIBRATION_DATA_3Msb        : integer := 5;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_3
  constant kENABLE_CALIBRATION_DATA_3           : integer := 5;  --CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_3
  --function kCALIBRATION_ENABLERec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- THRESHOLD_STATUS Register (from common_regs.v)
  constant kTHRESHOLD_STATUS : integer := 16#15000#; -- Register Offset
  constant kTHRESHOLD_STATUSSize: integer := 32;  -- register width in bits
  constant kTHRESHOLD_STATUSMask : std_logic_vector(31 downto 0) := X"00000f0f";
  constant kADC0_01_THRESHOLD1Size       : integer := 1;  --THRESHOLD_STATUS:ADC0_01_THRESHOLD1
  constant kADC0_01_THRESHOLD1Msb        : integer := 0;  --THRESHOLD_STATUS:ADC0_01_THRESHOLD1
  constant kADC0_01_THRESHOLD1           : integer := 0;  --THRESHOLD_STATUS:ADC0_01_THRESHOLD1
  constant kADC0_01_THRESHOLD2Size       : integer := 1;  --THRESHOLD_STATUS:ADC0_01_THRESHOLD2
  constant kADC0_01_THRESHOLD2Msb        : integer := 1;  --THRESHOLD_STATUS:ADC0_01_THRESHOLD2
  constant kADC0_01_THRESHOLD2           : integer := 1;  --THRESHOLD_STATUS:ADC0_01_THRESHOLD2
  constant kADC0_23_THRESHOLD1Size       : integer := 1;  --THRESHOLD_STATUS:ADC0_23_THRESHOLD1
  constant kADC0_23_THRESHOLD1Msb        : integer := 2;  --THRESHOLD_STATUS:ADC0_23_THRESHOLD1
  constant kADC0_23_THRESHOLD1           : integer := 2;  --THRESHOLD_STATUS:ADC0_23_THRESHOLD1
  constant kADC0_23_THRESHOLD2Size       : integer := 1;  --THRESHOLD_STATUS:ADC0_23_THRESHOLD2
  constant kADC0_23_THRESHOLD2Msb        : integer := 3;  --THRESHOLD_STATUS:ADC0_23_THRESHOLD2
  constant kADC0_23_THRESHOLD2           : integer := 3;  --THRESHOLD_STATUS:ADC0_23_THRESHOLD2
  constant kADC2_01_THRESHOLD1Size       : integer := 1;  --THRESHOLD_STATUS:ADC2_01_THRESHOLD1
  constant kADC2_01_THRESHOLD1Msb        : integer := 8;  --THRESHOLD_STATUS:ADC2_01_THRESHOLD1
  constant kADC2_01_THRESHOLD1           : integer := 8;  --THRESHOLD_STATUS:ADC2_01_THRESHOLD1
  constant kADC2_01_THRESHOLD2Size       : integer := 1;  --THRESHOLD_STATUS:ADC2_01_THRESHOLD2
  constant kADC2_01_THRESHOLD2Msb        : integer := 9;  --THRESHOLD_STATUS:ADC2_01_THRESHOLD2
  constant kADC2_01_THRESHOLD2           : integer := 9;  --THRESHOLD_STATUS:ADC2_01_THRESHOLD2
  constant kADC2_23_THRESHOLD1Size       : integer :=  1;  --THRESHOLD_STATUS:ADC2_23_THRESHOLD1
  constant kADC2_23_THRESHOLD1Msb        : integer := 10;  --THRESHOLD_STATUS:ADC2_23_THRESHOLD1
  constant kADC2_23_THRESHOLD1           : integer := 10;  --THRESHOLD_STATUS:ADC2_23_THRESHOLD1
  constant kADC2_23_THRESHOLD2Size       : integer :=  1;  --THRESHOLD_STATUS:ADC2_23_THRESHOLD2
  constant kADC2_23_THRESHOLD2Msb        : integer := 11;  --THRESHOLD_STATUS:ADC2_23_THRESHOLD2
  constant kADC2_23_THRESHOLD2           : integer := 11;  --THRESHOLD_STATUS:ADC2_23_THRESHOLD2
  --function kTHRESHOLD_STATUSRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- RF_PLL_CONTROL_REG Register (from common_regs.v)
  constant kRF_PLL_CONTROL_REG : integer := 16#16000#; -- Register Offset
  constant kRF_PLL_CONTROL_REGSize: integer := 32;  -- register width in bits
  constant kRF_PLL_CONTROL_REGMask : std_logic_vector(31 downto 0) := X"00011111";
  constant kENABLE_DATA_CLKSize       : integer := 1;  --RF_PLL_CONTROL_REG:ENABLE_DATA_CLK
  constant kENABLE_DATA_CLKMsb        : integer := 0;  --RF_PLL_CONTROL_REG:ENABLE_DATA_CLK
  constant kENABLE_DATA_CLK           : integer := 0;  --RF_PLL_CONTROL_REG:ENABLE_DATA_CLK
  constant kENABLE_DATA_CLK_2XSize       : integer := 1;  --RF_PLL_CONTROL_REG:ENABLE_DATA_CLK_2X
  constant kENABLE_DATA_CLK_2XMsb        : integer := 4;  --RF_PLL_CONTROL_REG:ENABLE_DATA_CLK_2X
  constant kENABLE_DATA_CLK_2X           : integer := 4;  --RF_PLL_CONTROL_REG:ENABLE_DATA_CLK_2X
  constant kENABLE_RF_CLKSize       : integer := 1;  --RF_PLL_CONTROL_REG:ENABLE_RF_CLK
  constant kENABLE_RF_CLKMsb        : integer := 8;  --RF_PLL_CONTROL_REG:ENABLE_RF_CLK
  constant kENABLE_RF_CLK           : integer := 8;  --RF_PLL_CONTROL_REG:ENABLE_RF_CLK
  constant kENABLE_RF_CLK_2XSize       : integer :=  1;  --RF_PLL_CONTROL_REG:ENABLE_RF_CLK_2X
  constant kENABLE_RF_CLK_2XMsb        : integer := 12;  --RF_PLL_CONTROL_REG:ENABLE_RF_CLK_2X
  constant kENABLE_RF_CLK_2X           : integer := 12;  --RF_PLL_CONTROL_REG:ENABLE_RF_CLK_2X
  constant kCLEAR_DATA_CLK_UNLOCKEDSize       : integer :=  1;  --RF_PLL_CONTROL_REG:CLEAR_DATA_CLK_UNLOCKED
  constant kCLEAR_DATA_CLK_UNLOCKEDMsb        : integer := 16;  --RF_PLL_CONTROL_REG:CLEAR_DATA_CLK_UNLOCKED
  constant kCLEAR_DATA_CLK_UNLOCKED           : integer := 16;  --RF_PLL_CONTROL_REG:CLEAR_DATA_CLK_UNLOCKED
  --function kRF_PLL_CONTROL_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

  -- RF_PLL_STATUS_REG Register (from common_regs.v)
  constant kRF_PLL_STATUS_REG : integer := 16#16008#; -- Register Offset
  constant kRF_PLL_STATUS_REGSize: integer := 32;  -- register width in bits
  constant kRF_PLL_STATUS_REGMask : std_logic_vector(31 downto 0) := X"00110000";
  constant kDATA_CLK_PLL_UNLOCKED_STICKYSize       : integer :=  1;  --RF_PLL_STATUS_REG:DATA_CLK_PLL_UNLOCKED_STICKY
  constant kDATA_CLK_PLL_UNLOCKED_STICKYMsb        : integer := 16;  --RF_PLL_STATUS_REG:DATA_CLK_PLL_UNLOCKED_STICKY
  constant kDATA_CLK_PLL_UNLOCKED_STICKY           : integer := 16;  --RF_PLL_STATUS_REG:DATA_CLK_PLL_UNLOCKED_STICKY
  constant kDATA_CLK_PLL_LOCKEDSize       : integer :=  1;  --RF_PLL_STATUS_REG:DATA_CLK_PLL_LOCKED
  constant kDATA_CLK_PLL_LOCKEDMsb        : integer := 20;  --RF_PLL_STATUS_REG:DATA_CLK_PLL_LOCKED
  constant kDATA_CLK_PLL_LOCKED           : integer := 20;  --RF_PLL_STATUS_REG:DATA_CLK_PLL_LOCKED
  --function kRF_PLL_STATUS_REGRec return XReg2_t; -- Register Record function commented out due to programmable attributes

end package;

package body PkgRFDC_REGS_REGMAP is

  -- function kMMCMRec not implemented because MMCM has programmable attributes
  ---- Return the record of window kMMCM
  --function kMMCMRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"0");
  --  Rec.size := kMMCMSize;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"00");
  --  Rec.rmask := XRegResize(X"00");
  --  Rec.strobemask := XRegResize(X"00");
  --  Rec.clearablemask := XRegResize(X"00");
  --  Rec.iswin := true;
  --  --synopsys translate_off
  --  Rec.name := rs("MMCM");
  --  --synopsys translate_on
  --  return Rec;
  --end function kMMCMRec;

  -- function kINVERT_IQ_REGRec not implemented because INVERT_IQ_REG has programmable attributes
  ---- Return the record of register kINVERT_IQ_REG
  --function kINVERT_IQ_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"10000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"0000ffff");
  --  Rec.rmask := XRegResize(X"0000ffff");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("INVERT_IQ_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kINVERT_IQ_REGRec;

  -- function kMMCM_RESET_REGRec not implemented because MMCM_RESET_REG has programmable attributes
  ---- Return the record of register kMMCM_RESET_REG
  --function kMMCM_RESET_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"11000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"00000001");
  --  Rec.rmask := XRegResize(X"00000001");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("MMCM_RESET_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kMMCM_RESET_REGRec;

  -- function kRF_RESET_CONTROL_REGRec not implemented because RF_RESET_CONTROL_REG has programmable attributes
  ---- Return the record of register kRF_RESET_CONTROL_REG
  --function kRF_RESET_CONTROL_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"12000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"00000331");
  --  Rec.rmask := XRegResize(X"00000331");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("RF_RESET_CONTROL_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kRF_RESET_CONTROL_REGRec;

  -- function kRF_RESET_STATUS_REGRec not implemented because RF_RESET_STATUS_REG has programmable attributes
  ---- Return the record of register kRF_RESET_STATUS_REG
  --function kRF_RESET_STATUS_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"12008");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := false;
  --  Rec.wmask := XRegResize(X"00000888");
  --  Rec.rmask := XRegResize(X"00000888");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("RF_RESET_STATUS_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kRF_RESET_STATUS_REGRec;

  -- function kRF_AXI_STATUS_REGRec not implemented because RF_AXI_STATUS_REG has programmable attributes
  ---- Return the record of register kRF_AXI_STATUS_REG
  --function kRF_AXI_STATUS_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"13000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := false;
  --  Rec.wmask := XRegResize(X"ffffffff");
  --  Rec.rmask := XRegResize(X"ffffffff");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.msblookupw(kRFDC_DAC_TREADY) := kRFDC_DAC_TREADYMsb;
  --  Rec.msblookupw(kRFDC_DAC_TVALID) := kRFDC_DAC_TVALIDMsb;
  --  Rec.msblookupw(kRFDC_ADC_Q_TREADY) := kRFDC_ADC_Q_TREADYMsb;
  --  Rec.msblookupw(kRFDC_ADC_I_TREADY) := kRFDC_ADC_I_TREADYMsb;
  --  Rec.msblookupw(kRFDC_ADC_Q_TVALID) := kRFDC_ADC_Q_TVALIDMsb;
  --  Rec.msblookupw(kRFDC_ADC_I_TVALID) := kRFDC_ADC_I_TVALIDMsb;
  --  Rec.msblookupw(kUSER_ADC_TVALID) := kUSER_ADC_TVALIDMsb;
  --  Rec.msblookupw(kUSER_ADC_TREADY) := kUSER_ADC_TREADYMsb;
  --  Rec.msblookupw(kRFDC_DAC_TREADY_DB1) := kRFDC_DAC_TREADY_DB1Msb;
  --  Rec.msblookupw(kRFDC_DAC_TVALID_DB1) := kRFDC_DAC_TVALID_DB1Msb;
  --  Rec.msblookupw(kRFDC_ADC_Q_TREADY_DB1) := kRFDC_ADC_Q_TREADY_DB1Msb;
  --  Rec.msblookupw(kRFDC_ADC_I_TREADY_DB1) := kRFDC_ADC_I_TREADY_DB1Msb;
  --  Rec.msblookupw(kRFDC_ADC_Q_TVALID_DB1) := kRFDC_ADC_Q_TVALID_DB1Msb;
  --  Rec.msblookupw(kRFDC_ADC_I_TVALID_DB1) := kRFDC_ADC_I_TVALID_DB1Msb;
  --  Rec.msblookupw(kUSER_ADC_TVALID_DB1) := kUSER_ADC_TVALID_DB1Msb;
  --  Rec.msblookupw(kUSER_ADC_TREADY_DB1) := kUSER_ADC_TREADY_DB1Msb;
  --  Rec.msblookupr(kRFDC_DAC_TREADY) := kRFDC_DAC_TREADYMsb;
  --  Rec.msblookupr(kRFDC_DAC_TVALID) := kRFDC_DAC_TVALIDMsb;
  --  Rec.msblookupr(kRFDC_ADC_Q_TREADY) := kRFDC_ADC_Q_TREADYMsb;
  --  Rec.msblookupr(kRFDC_ADC_I_TREADY) := kRFDC_ADC_I_TREADYMsb;
  --  Rec.msblookupr(kRFDC_ADC_Q_TVALID) := kRFDC_ADC_Q_TVALIDMsb;
  --  Rec.msblookupr(kRFDC_ADC_I_TVALID) := kRFDC_ADC_I_TVALIDMsb;
  --  Rec.msblookupr(kUSER_ADC_TVALID) := kUSER_ADC_TVALIDMsb;
  --  Rec.msblookupr(kUSER_ADC_TREADY) := kUSER_ADC_TREADYMsb;
  --  Rec.msblookupr(kRFDC_DAC_TREADY_DB1) := kRFDC_DAC_TREADY_DB1Msb;
  --  Rec.msblookupr(kRFDC_DAC_TVALID_DB1) := kRFDC_DAC_TVALID_DB1Msb;
  --  Rec.msblookupr(kRFDC_ADC_Q_TREADY_DB1) := kRFDC_ADC_Q_TREADY_DB1Msb;
  --  Rec.msblookupr(kRFDC_ADC_I_TREADY_DB1) := kRFDC_ADC_I_TREADY_DB1Msb;
  --  Rec.msblookupr(kRFDC_ADC_Q_TVALID_DB1) := kRFDC_ADC_Q_TVALID_DB1Msb;
  --  Rec.msblookupr(kRFDC_ADC_I_TVALID_DB1) := kRFDC_ADC_I_TVALID_DB1Msb;
  --  Rec.msblookupr(kUSER_ADC_TVALID_DB1) := kUSER_ADC_TVALID_DB1Msb;
  --  Rec.msblookupr(kUSER_ADC_TREADY_DB1) := kUSER_ADC_TREADY_DB1Msb;
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("RF_AXI_STATUS_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kRF_AXI_STATUS_REGRec;

  -- function kFABRIC_DSP_REGRec not implemented because FABRIC_DSP_REG has programmable attributes
  ---- Return the record of register kFABRIC_DSP_REG
  --function kFABRIC_DSP_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"13008");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := false;
  --  Rec.wmask := XRegResize(X"ffffffff");
  --  Rec.rmask := XRegResize(X"ffffffff");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  Rec.initialvalue := XRegResize(X"00000000");
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.msblookupw(kFABRIC_DSP_BW) := kFABRIC_DSP_BWMsb;
  --  Rec.msblookupw(kFABRIC_DSP_RX_CNT) := kFABRIC_DSP_RX_CNTMsb;
  --  Rec.msblookupw(kFABRIC_DSP_TX_CNT) := kFABRIC_DSP_TX_CNTMsb;
  --  Rec.msblookupw(kFABRIC_DSP_BW_DB1) := kFABRIC_DSP_BW_DB1Msb;
  --  Rec.msblookupw(kFABRIC_DSP_RX_CNT_DB1) := kFABRIC_DSP_RX_CNT_DB1Msb;
  --  Rec.msblookupw(kFABRIC_DSP_TX_CNT_DB1) := kFABRIC_DSP_TX_CNT_DB1Msb;
  --  Rec.msblookupr(kFABRIC_DSP_BW) := kFABRIC_DSP_BWMsb;
  --  Rec.msblookupr(kFABRIC_DSP_RX_CNT) := kFABRIC_DSP_RX_CNTMsb;
  --  Rec.msblookupr(kFABRIC_DSP_TX_CNT) := kFABRIC_DSP_TX_CNTMsb;
  --  Rec.msblookupr(kFABRIC_DSP_BW_DB1) := kFABRIC_DSP_BW_DB1Msb;
  --  Rec.msblookupr(kFABRIC_DSP_RX_CNT_DB1) := kFABRIC_DSP_RX_CNT_DB1Msb;
  --  Rec.msblookupr(kFABRIC_DSP_TX_CNT_DB1) := kFABRIC_DSP_TX_CNT_DB1Msb;
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("FABRIC_DSP_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kFABRIC_DSP_REGRec;

  -- function kCALIBRATION_DATARec not implemented because CALIBRATION_DATA has programmable attributes
  ---- Return the record of register kCALIBRATION_DATA
  --function kCALIBRATION_DATARec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"14000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"ffffffff");
  --  Rec.rmask := XRegResize(X"ffffffff");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.msblookupw(kI_DATA) := kI_DATAMsb;
  --  Rec.msblookupw(kQ_DATA) := kQ_DATAMsb;
  --  Rec.msblookupr(kI_DATA) := kI_DATAMsb;
  --  Rec.msblookupr(kQ_DATA) := kQ_DATAMsb;
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("CALIBRATION_DATA");
  --  --synopsys translate_on
  --  return Rec;
  --end function kCALIBRATION_DATARec;

  -- function kCALIBRATION_ENABLERec not implemented because CALIBRATION_ENABLE has programmable attributes
  ---- Return the record of register kCALIBRATION_ENABLE
  --function kCALIBRATION_ENABLERec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"14008");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"00000033");
  --  Rec.rmask := XRegResize(X"00000033");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("CALIBRATION_ENABLE");
  --  --synopsys translate_on
  --  return Rec;
  --end function kCALIBRATION_ENABLERec;

  -- function kTHRESHOLD_STATUSRec not implemented because THRESHOLD_STATUS has programmable attributes
  ---- Return the record of register kTHRESHOLD_STATUS
  --function kTHRESHOLD_STATUSRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"15000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"00000f0f");
  --  Rec.rmask := XRegResize(X"00000f0f");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("THRESHOLD_STATUS");
  --  --synopsys translate_on
  --  return Rec;
  --end function kTHRESHOLD_STATUSRec;

  -- function kRF_PLL_CONTROL_REGRec not implemented because RF_PLL_CONTROL_REG has programmable attributes
  ---- Return the record of register kRF_PLL_CONTROL_REG
  --function kRF_PLL_CONTROL_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"16000");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := true;
  --  Rec.wmask := XRegResize(X"00011111");
  --  Rec.rmask := XRegResize(X"00011111");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("RF_PLL_CONTROL_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kRF_PLL_CONTROL_REGRec;

  -- function kRF_PLL_STATUS_REGRec not implemented because RF_PLL_STATUS_REG has programmable attributes
  ---- Return the record of register kRF_PLL_STATUS_REG
  --function kRF_PLL_STATUS_REGRec return XReg2_t is
  --  variable Rec : XReg2_t;
  --begin
  --  Rec := kXRegDefault;
  --  Rec.version := 1;
  --  Rec.offset := XAddrResize(X"16008");
  --  Rec.size := 32;
  --  Rec.readable := true;
  --  Rec.writable := false;
  --  Rec.wmask := XRegResize(X"00110000");
  --  Rec.rmask := XRegResize(X"00110000");
  --  Rec.strobemask := XRegResize(X"00000000");
  --  Rec.clearablemask := XRegResize(X"00000000");
  --  -- no initial values specified
  --  -- Single-bit bitfields are not listed here because the default for msblookup* is msb=lsb.
  --  Rec.isreg := true;
  --  --synopsys translate_off
  --  Rec.name := rs("RF_PLL_STATUS_REG");
  --  --synopsys translate_on
  --  return Rec;
  --end function kRF_PLL_STATUS_REGRec;

end package body;
